#include "stdafx.hpp"

#include "Utility.hpp"

#include <assert.h>
#include <string.h>
#include <mbctype.h>

#include <string>
#include <vector>

/*!
 * Ő󔒂ƃ^ug܂B
 * ͔j󂳂܂B
 * \param buf g镶
 * \return ύXtrueAłȂfalse
 */
bool TrimSpaceBothBuff(LPTSTR buf)
{
	//required:
	assert( buf != NULL && "bufNULL͎wł܂B" );

	//do:
	bool modified = false;
	LPTSTR p = buf;
	while( *p > 0 && *p <= ' ' ) {
		p++;
	}

	if( p != buf ) {
		// s󔒂l߂Ė܂ňړ
		LPTSTR d = buf;
		while( *p ) {
			*d++ = *p++;
		}
		*d = 0;
		modified = true;
	}
	else {
		// ܂ňړ
		while( *p ) {
			p++;
		}
	}

	// A󔒂kɒu
	while( p > buf ) {
		p = ::CharPrev( buf, p);
		if( *p <= 0 || *p > ' ' ) {
			break;
		}
		*p = 0;
		modified = true;
	}
	
	return modified;
}

/*!
 * 񂪎w肵ŏI[邱ƂۏႵ܂B
 * w肵ŏI[ĂȂ͖ɏI[񂪒ǉ܂B
 * Ώە͔jIɑ삳܂B
 * Ώە͂炩ߏI[ǉĂSȒKvłB
 * \param v_str Ώە
 * \param v_endStr I[
 * \return ǉꂽꍇtrueAǉ̕KvȂꍇfalse
 */
bool EnsureEndsWithBuff( LPTSTR v_str, LPCTSTR v_endStr )
{
	//required:
	assert( v_str != NULL && "v_strNULL͎wł܂B" );
	assert( v_endStr != NULL && "v_endStrNULL͎wł܂B" );

	//do:
	LPTSTR p1 = v_str;
	LPCTSTR p2 = v_endStr;
	while( *p1 ) p1++;
	while( *p2 ) p2++;
	while( p1 > v_str && p2 > v_endStr ) {
		p1 = ::CharPrev( v_str, p1 );
		p2 = ::CharPrev( v_endStr, p2 );
	}
	if( p2 == v_endStr ) {
		if( _tcscmp( p1, p2 ) == 0 ) {
			// ͎w肵I[
			return false;
		}
	}
	// ͏I[ZAI[vȂ
	_tcscat( v_str, v_endStr );
	return true;
}

/*!
 * p^[}b`s܂B
 * p^[ɂ́u*vƁu?v̓ꕶ܂߂邱Ƃł܂B
 * rΏƂƂȂ镶ɂ́A̓ꕶ܂߂邱Ƃ͂ł܂B
 * u*v͏I[܂߂0ȏ̃}b`Au?v͏I[ȊO̔Cӂ1ƃ}b`܂B
 * \param v_text rΏƕ
 * \param v_pattern p^[
 * \return }b`ꍇAtrue
 */
bool IsMatch( LPCTSTR v_text, LPCTSTR v_pattern ) throw()
{
	//required:
	assert( v_text != NULL && v_pattern != NULL && "null͎wł܂B" );
	
	//do:
	LPCTSTR s = v_text;
	LPCTSTR p = v_pattern;
	while( *p ) {
		const TCHAR cp = *p;
		if( cp == '?' ) {
			if( ! *s ) {
				// 1vꏊŏI[̂ߕsv
				return false;
			}
		}
		else if( cp == '*' ) {
			TCHAR cn = 0;
			do{
				p = ::CharNext( p );
				cn = *p;
			} while( cn == '*' || cn == '?' );
			if( cn == 0 ) {
				// ̕I[ł邽߁Aȍ~s
				return true;
			}
			while( *s ) {
				if( *s == cn ) {
					if( IsMatch( s, p ) ) {
						return true;
					}
				}
				s = ::CharNext( s );
			}
			return false;
		}
		else {
			if( cp != *s ) {
				// vB
				return false;
			}
#ifndef _UNICODE
			if( ::IsDBCSLeadByte( cp ) ) {
				if( *( p + 1 ) != *( s + 1 ) ) {
					// _uoCǧ㑱v
					return false;
				}
			}
#endif
		}
		s = ::CharNext( s ); // ɏI[ɒBꍇ͏I[wÂB
		p = ::CharNext( p );
	}
	
	return *s == 0 && *p == 0; // oɏI[ɂǂ蒅Ȃ}b`ĂB
}



