#include "stdafx.hpp"

#include "..\FWatch\StringExpander.hpp"

#include <assert.h>

void testPropertyStringExpander()
{
	// eXgp^[

	PropertyStringExpander expander;
	expander.addProperty( _TEXT("ABC"), _TEXT("123") );
	
	assert( expander.expandString( _TEXT("") ) == _TEXT("") );
	assert( expander.expandString( _TEXT("123 456") ) == _TEXT("123 456") );
	assert( expander.expandString( _TEXT("%ABC%") ) == _TEXT("123") );
	assert( expander.expandString( _TEXT("%abc%") ) == _TEXT("123") );
	assert( expander.expandString( _TEXT("%DEF%") ) == _TEXT("%DEF%") );
	assert( expander.expandString( _TEXT("%%ABC%%") ) == _TEXT("%123%") );
	assert( expander.expandString( _TEXT("%%DEF%%") ) == _TEXT("%%DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%%%DEF%%") ) == _TEXT("123%%DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%% %DEF%%") ) == _TEXT("123% %DEF%%") );
	assert( expander.expandString( _TEXT("%ABC%% %DEF%% ") ) == _TEXT("123% %DEF%% ") );

	assert( expander.expandString( _TEXT("%1 %2 %* -path=\"%ABC%\"" )) == _TEXT("%1 %2 %* -path=\"123\"") );
}
