#include "stdafx.hpp"

#include <assert.h>

#include <vector>
#include <fstream>

#include "..\FWatch\SAXParser.hpp"

namespace
{
	class TestSAXContentHandler : public SAXContentHandler
	{
	private:
		tstring buf;
	public:

		std::vector<tstring> result;

		TestSAXContentHandler()
		{
		}

		virtual ~TestSAXContentHandler()
		{
		}

		virtual void startDocument()
		{
			result.push_back( _TEXT("document") );
		}

		virtual void endDocument()
		{
			result.push_back( _TEXT("document/") );
		}

		virtual void startPrefixMapping(const tstring&, const tstring& )
		{
		}

		virtual void endPrefixMapping(const tstring& )
		{
		}

		virtual void startElement(
			const tstring& v_namespace,
			const tstring& v_localName,
			const tstring& v_QName,
			const SAXAttributes& attr
			)
		{
			result.push_back( v_localName );

			int mx = attr.getLength();
			for( int idx=0; idx<mx; idx++ ) {
				result.push_back( attr.getQName( idx ) + _TEXT("->") + attr.getValue( idx ) + _TEXT("/") );
			}
			buf.clear();
		}

		virtual void endElement(
			const tstring& v_namespace,
			const tstring& v_localName,
			const tstring& v_QName
			)
		{
			if( ! buf.empty() ) {
				result.push_back( buf );
			}
			result.push_back( v_localName + _TEXT("/") );
			buf.clear();
		}

		virtual void characters(const tstring& v_chars )
		{
			buf += v_chars;
		}

		virtual void ignorableWhitespace(const tstring& v_chars )
		{
		}

		virtual void processingInstruction( const tstring& , const tstring& )
		{
		}

		virtual void skippedEntity( const tstring& )
		{
		}
	};
}


void testSAXParser()
{
	std::ofstream fout;
	fout.open( "testdata.xml", std::ios::out );
	fout << "<?xml version=\"1.0\" encoding=\"csWindows31J\" ?>" << std::endl;
	fout << "<testdata>";
	fout << "<param>";
	fout << "<data name=\"ABC\" value=\"123\"/>";
	fout << "<data name=\"DEF\" value=\"456\"/>";
	fout << "<data name=\"XYZ\" value=\"789\"/>";
	fout << "<data name=\"JPN\" value=\"`{\`\"/>";
	fout << "</param>";
	fout << "<param2><![CDATA[0123456789]]></param2>";
	fout << "</testdata>" << std::endl;
	fout.close();

	SAXParserFactory factory;
	SAXParserPtr parser = factory.create();
	
	TestSAXContentHandler handler;
	parser->parse( _TEXT("testdata.xml"), handler );

	std::vector<tstring>::iterator ite = handler.result.begin();

	assert( *ite++ == _TEXT("document") );
	assert( *ite++ == _TEXT("testdata") );
	assert( *ite++ == _TEXT("param") );
	assert( *ite++ == _TEXT("data") );
	assert( *ite++ == _TEXT("name->ABC/") );
	assert( *ite++ == _TEXT("value->123/") );
	assert( *ite++ == _TEXT("data/") );
	assert( *ite++ == _TEXT("data") );
	assert( *ite++ == _TEXT("name->DEF/") );
	assert( *ite++ == _TEXT("value->456/") );
	assert( *ite++ == _TEXT("data/") );
	assert( *ite++ == _TEXT("data") );
	assert( *ite++ == _TEXT("name->XYZ/") );
	assert( *ite++ == _TEXT("value->789/") );
	assert( *ite++ == _TEXT("data/") );
	assert( *ite++ == _TEXT("data") );
	assert( *ite++ == _TEXT("name->JPN/") );
	assert( *ite++ == _TEXT("value->`{\`/") );
	assert( *ite++ == _TEXT("data/") );
	assert( *ite++ == _TEXT("param/") );
	assert( *ite++ == _TEXT("param2") );
	assert( *ite++ == _TEXT("0123456789") );
	assert( *ite++ == _TEXT("param2/") );
	assert( *ite++ == _TEXT("testdata/") );
	assert( *ite++ == _TEXT("document/") );

	assert( ite == handler.result.end() );
}
