using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FXCommon;

namespace FXCMTrader
{
	public partial class FChild : FBase
	{
		/// <summary>
		/// RAIuWFNg
		/// </summary>
		protected FXTradeDesk _tradeDesk = null;

		/// <summary>
		/// e[u^Cv
		/// </summary>
		protected string _tableType = null;

		/// <summary>
		/// g[hfXNIuWFNg擾܂B
		/// </summary>
		public FXTradeDesk TradeDesk
		{
			get { return ( this._tradeDesk ); }
		}

		/// <summary>
		/// e[u^Cv擾܂B
		/// </summary>
		public string TableType
		{
			get { return ( this._tableType ); }
		}

		/// <summary>
		/// fUCiG[p
		/// </summary>
		//public FChild()
		//{
		//    // ̌Ăяo Windows tH[ fUCiŕKvłB
		//    InitializeComponent();
		//}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="taradeDesk">g[hfXNIuWFNg</param>
		public FChild( FXTradeDesk tradeDesk, string tableType )
		{
			// ̌Ăяo Windows tH[ fUCiŕKvłB
			InitializeComponent();

			_tradeDesk = tradeDesk;
			_tableType = tableType;
		}

		protected void FChild_Load( object sender, System.EventArgs e )
		{
			if( _tableType == null || _tableType == null )
				return;

			this.SetGridData();
			this.SetSelectedRow();
		}

		/// <summary>
		/// dataGrid Ƀe[uIuWFNgݒ肵܂B
		/// </summary>
		/// <param name="primarykeyID">L[ID</param>
		#region SetGridData()
		protected void SetGridData()
		{
			grdData.Redraw = false;

			this.Text = _tableType;
			grdData.DataSource = null;
			grdData.DataSource = _tradeDesk.TableDataSet.Tables[_tableType];

			this.SetHideColumns();

			grdData.Redraw = true;

			//TODO : ̂ɗ̕w胁\bh쐬 protected abstract void SetColumnSize();
		}
		#endregion

		/// <summary>
		/// \ݒ肵܂B
		/// </summary>
		protected virtual void SetHideColumns()
		{
		}

		/// <summary>
		/// }EXōsIBENbNłsI邽߁B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region grdData_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		protected virtual void grdData_MouseDown( object sender, System.Windows.Forms.MouseEventArgs e )
		{
			grdData.Row = grdData.MouseRow;
		}
		#endregion

		protected void grdData_RowColChange( object sender, System.EventArgs e )
		{
			this.SetSelectedRow();
		}

		/// <summary>
		/// IĂs core.TradeDesk ɐݒ肵܂B
		/// sIĂȂꍇ1sڂݒ肵܂B
		/// </summary>
		protected void SetSelectedRow()
		{
			if( !grdData.Redraw )
				return;

			if( 0 < grdData.Row )
			{
				_tradeDesk.SetFormSelectedRow( ( (DataRowView)grdData.Rows[grdData.Row].DataSource ).Row );
			}
			else if( 1 < grdData.Rows.Count )
			{
				_tradeDesk.SetFormSelectedRow( ( (DataRowView)grdData.Rows[1].DataSource ).Row );
			}
		}

		private void grdData_AfterDataRefresh( object sender, System.ComponentModel.ListChangedEventArgs e )
		{
			if( grdData.Redraw
				&& ( e.ListChangedType == ListChangedType.ItemAdded
				|| e.ListChangedType == ListChangedType.Reset
				|| e.ListChangedType == ListChangedType.ItemDeleted ) )
			{
				this.SetGridData();
			}
		}
	}
}