using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FXCommon;

namespace FXCMTrader
{
	public partial class FLogin : FBase
	{
		public const string LOGIN_URL = @"http://www.fxcorporate.com";

		private FXTradeDesk _tradeDesk;

		public FLogin( FXTradeDesk tradeDesk )
		{
			InitializeComponent();

			_tradeDesk = tradeDesk;
			txtMessage.Text = "";
		}

		private void FLogin_Load( object sender, System.EventArgs e )
		{
			//TODO : O񃍃OCݒ


			cmbConnection.SelectedIndex = 0;
		}

		private void btnOk_Click( object sender, System.EventArgs e )
		{
			Cursor.Current = Cursors.WaitCursor;

			txtLoginID.Enabled = false;
			txtPassword.Enabled = false;
			btnOk.Enabled = false;
			btnCancel.Enabled = false;

			txtMessage.Text += "Login...\r\n";
			txtMessage.Refresh();

			bool isLogin = false;
			try
			{
				_tradeDesk.Login( txtLoginID.Text, txtPassword.Text, LOGIN_URL, cmbConnection.SelectedItem.ToString() );
				isLogin = true;
			}
			catch( Exception ex )
			{
				txtMessage.Text += "Failed Login!!\r\n[" + ex.Message + "]\r\n";
				txtMessage.Refresh();
			}
			finally
			{
				txtLoginID.Enabled = true;
				txtPassword.Enabled = true;
				btnOk.Enabled = true;
				btnCancel.Enabled = true;
				Cursor.Current = Cursors.Default;
			}

			if( isLogin )
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		private void FLogin_Closing( object sender, System.ComponentModel.CancelEventArgs e )
		{
			if( !btnOk.Enabled )
			{
				e.Cancel = true;
			}
		}

		private void btnCancel_Click( object sender, System.EventArgs e )
		{
			this.Close();
		}
	}
}