using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Threading;

using FXCore;
using FXCommon;

namespace FXCMTrader
{
	public partial class FMain : FBase
	{
		private Core core;
		private FXTradeDesk tradeDesk;

		private FOffers offers;
		private FTrades trades;
		private FAccounts accounts;
		private FCloseTrades closeTrades;
		private FOrders orders;
		private FSummary summary;
		private FMessages messages;

		private FXAuto fxAuto;
		private Thread autoOrderThread;

		public FMain()
		{
			InitializeComponent();

			core = new Core();
			tradeDesk = core.TradeDesk;
		}

		/// <summary>
		/// tH[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region FMain_Load(object sender, System.EventArgs e)
		private void FMain_Load( object sender, System.EventArgs e )
		{
			// ININX
			FXIni.Init();

			mnuLogout.Enabled = false;

			this.Login();
		}
		#endregion

		/// <summary>
		/// OCj[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region mnuLogin_Click(object sender, System.EventArgs e)
		private void mnuLogin_Click( object sender, System.EventArgs e )
		{
			this.Login();
		}
		#endregion

		/// <summary>
		/// OAEgj[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region mnuLogout_Click(object sender, System.EventArgs e)
		private void mnuLogout_Click( object sender, System.EventArgs e )
		{
			this.Logout();
		}
		#endregion

		/// <summary>
		/// Ij[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region mnuExit_Click(object sender, System.EventArgs e)
		private void mnuExit_Click( object sender, System.EventArgs e )
		{
			this.Close();
		}
		#endregion

		/// <summary>
		/// N[WOCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region FMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		private void FMain_Closing( object sender, System.ComponentModel.CancelEventArgs e )
		{
			if( EasyMessageBox.MessageQuestion( "I܂H", "I" ) == DialogResult.No )
			{
				e.Cancel = true;
				return;
			}

			this.Logout();
		}
		#endregion


		/// <summary>
		/// OC܂B
		/// </summary>
		#region Login()
		private void Login()
		{
			using( FLogin fLogin = new FLogin( tradeDesk ) )
			{
				if( fLogin.ShowDialog( this ) == DialogResult.Cancel )
				{
					return;
				}

				// qʍ쐬
				this.CreateChildWindows();

				mnuLogout.Enabled = true;
				mnuLogin.Enabled = false;
			}
		}
		#endregion

		/// <summary>
		/// OAEg܂B
		/// </summary>
		#region Logout()
		private void Logout()
		{
			try
			{
				// I[_[I
				if( autoOrderThread != null )
				{
					autoOrderThread.Abort();
					fxAuto = null;
				}

				tradeDesk.Logout();
				this.SetChildWindowsProperty();
			}
			catch( Exception e )
			{
				// sĂʂ
				EasyMessageBox.MessageError( e.Message, "OAEg s" );
			}

			foreach( Form mdiForm in this.MdiChildren )
			{
				mdiForm.Close();
			}

			mnuLogin.Enabled = true;
			mnuLogout.Enabled = false;
		}
		#endregion

		/// <summary>
		/// qtH[쐬܂B
		/// </summary>
		#region CreateChildWindows()
		private void CreateChildWindows()
		{
			//			TablesManagerAut manager = (TablesManagerAut)tradeDesk.TablesManager;
			/*
			table list
			
			offers 
			trades 
			accounts 
			closed trades 
			orders 
			summary 
			rquotes 
			messages 
			instr 
			*/

			offers = new FOffers( tradeDesk, FXTradeDesk.OFFERS );
			offers.MdiParent = this;

			trades = new FTrades( tradeDesk, FXTradeDesk.TRADES );
			trades.MdiParent = this;

			accounts = new FAccounts( tradeDesk, FXTradeDesk.ACCOUNTS );
			accounts.MdiParent = this;

			closeTrades = new FCloseTrades( tradeDesk, FXTradeDesk.CLOSED_TRADES );
			closeTrades.MdiParent = this;

			orders = new FOrders( tradeDesk, FXTradeDesk.ORDERS );
			orders.MdiParent = this;

			summary = new FSummary( tradeDesk, FXTradeDesk.SUMMARY );
			summary.MdiParent = this;

			messages = new FMessages( tradeDesk, FXTradeDesk.MESSAGES );
			messages.MdiParent = this;

			// show
			offers.Show();
			trades.Show();
			accounts.Show();
			closeTrades.Show();
			orders.Show();
			summary.Show();
			messages.Show();

			// vpeBݒ
			this.GetChildWindowsProperty();
		}
		#endregion

		/// <summary>
		/// tH[̃vpeBݒ肵܂B
		/// </summary>
		#region GetChildWindowsProperty()
		private void GetChildWindowsProperty()
		{
			try
			{
				this.Top = FXIni.GetInt32( "Main", "Top", this.Top );
				this.Left = FXIni.GetInt32( "Main", "Left", this.Left );
				this.Height = FXIni.GetInt32( "Main", "Height", this.Height );
				this.Width = FXIni.GetInt32( "Main", "Width", this.Width );
				string windowState = FXIni.GetString( "Main", "WindowState", this.WindowState.ToString() );

				if( windowState == "Maximized" )
				{
					this.WindowState = FormWindowState.Maximized;
				}
				else if( windowState == "Minimized" )
				{
					this.WindowState = FormWindowState.Minimized;
				}
				else
				{
					this.WindowState = FormWindowState.Normal;
				}

				offers.Top = FXIni.GetInt32( "Offers", "Top", offers.Top );
				offers.Left = FXIni.GetInt32( "Offers", "Left", offers.Left );
				offers.Height = FXIni.GetInt32( "Offers", "Height", offers.Height );
				offers.Width = FXIni.GetInt32( "Offers", "Width", offers.Width );

				trades.Top = FXIni.GetInt32( "Trades", "Top", trades.Top );
				trades.Left = FXIni.GetInt32( "Trades", "Left", trades.Left );
				trades.Height = FXIni.GetInt32( "Trades", "Height", trades.Height );
				trades.Width = FXIni.GetInt32( "Trades", "Width", trades.Width );

				accounts.Top = FXIni.GetInt32( "Accounts", "Top", accounts.Top );
				accounts.Left = FXIni.GetInt32( "Accounts", "Left", accounts.Left );
				accounts.Height = FXIni.GetInt32( "Accounts", "Height", accounts.Height );
				accounts.Width = FXIni.GetInt32( "Accounts", "Width", accounts.Width );

				closeTrades.Top = FXIni.GetInt32( "CloseTrades", "Top", closeTrades.Top );
				closeTrades.Left = FXIni.GetInt32( "CloseTrades", "Left", closeTrades.Left );
				closeTrades.Height = FXIni.GetInt32( "CloseTrades", "Height", closeTrades.Height );
				closeTrades.Width = FXIni.GetInt32( "CloseTrades", "Width", closeTrades.Width );

				orders.Top = FXIni.GetInt32( "Orders", "Top", orders.Top );
				orders.Left = FXIni.GetInt32( "Orders", "Left", orders.Left );
				orders.Height = FXIni.GetInt32( "Orders", "Height", orders.Height );
				orders.Width = FXIni.GetInt32( "Orders", "Width", orders.Width );

				summary.Top = FXIni.GetInt32( "Summary", "Top", summary.Top );
				summary.Left = FXIni.GetInt32( "Summary", "Left", summary.Left );
				summary.Height = FXIni.GetInt32( "Summary", "Height", summary.Height );
				summary.Width = FXIni.GetInt32( "Summary", "Width", summary.Width );

				messages.Top = FXIni.GetInt32( "Messages", "Top", messages.Top );
				messages.Left = FXIni.GetInt32( "Messages", "Left", messages.Left );
				messages.Height = FXIni.GetInt32( "Messages", "Height", messages.Height );
				messages.Width = FXIni.GetInt32( "Messages", "Width", messages.Width );
			}
			catch
			{

			}
		}
		#endregion

		/// <summary>
		/// tH[̃vpeB profiles.ini ɕۑ܂B
		/// </summary>
		#region SetChildWindowsProperty()
		private void SetChildWindowsProperty()
		{
			FXIni.WriteString( "Main", "Top", this.Top );
			FXIni.WriteString( "Main", "Left", this.Left );
			FXIni.WriteString( "Main", "Height", this.Height );
			FXIni.WriteString( "Main", "Width", this.Width );
			FXIni.WriteString( "Main", "WindowState", this.WindowState );

			if( offers != null )
			{
				FXIni.WriteString( "Offers", "Top", offers.Top );
				FXIni.WriteString( "Offers", "Left", offers.Left );
				FXIni.WriteString( "Offers", "Height", offers.Height );
				FXIni.WriteString( "Offers", "Width", offers.Width );
			}

			if( trades != null )
			{
				FXIni.WriteString( "Trades", "Top", trades.Top );
				FXIni.WriteString( "Trades", "Left", trades.Left );
				FXIni.WriteString( "Trades", "Height", trades.Height );
				FXIni.WriteString( "Trades", "Width", trades.Width );
			}

			if( accounts != null )
			{
				FXIni.WriteString( "Accounts", "Top", accounts.Top );
				FXIni.WriteString( "Accounts", "Left", accounts.Left );
				FXIni.WriteString( "Accounts", "Height", accounts.Height );
				FXIni.WriteString( "Accounts", "Width", accounts.Width );
			}

			if( closeTrades != null )
			{
				FXIni.WriteString( "CloseTrades", "Top", closeTrades.Top );
				FXIni.WriteString( "CloseTrades", "Left", closeTrades.Left );
				FXIni.WriteString( "CloseTrades", "Height", closeTrades.Height );
				FXIni.WriteString( "CloseTrades", "Width", closeTrades.Width );
			}

			if( orders != null )
			{
				FXIni.WriteString( "Orders", "Top", orders.Top );
				FXIni.WriteString( "Orders", "Left", orders.Left );
				FXIni.WriteString( "Orders", "Height", orders.Height );
				FXIni.WriteString( "Orders", "Width", orders.Width );
			}

			if( summary != null )
			{
				FXIni.WriteString( "Summary", "Top", summary.Top );
				FXIni.WriteString( "Summary", "Left", summary.Left );
				FXIni.WriteString( "Summary", "Height", summary.Height );
				FXIni.WriteString( "Summary", "Width", summary.Width );
			}

			if( messages != null )
			{
				FXIni.WriteString( "Messages", "Top", messages.Top );
				FXIni.WriteString( "Messages", "Left", messages.Left );
				FXIni.WriteString( "Messages", "Height", messages.Height );
				FXIni.WriteString( "Messages", "Width", messages.Width );
			}
		}
		#endregion

		/// <summary>
		/// c[o[̃{^ɔ܂B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tbMain_ButtonClick( object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e )
		{
			ToolBarButton tbb = e.Button;

			if( tbb == tbbTester )
			{
				//FTester tester = new FTester( tradeDesk );
				//tester.MdiParent = this;
				//tester.Show();
			}
			else if( tbb == tbbAuto )
			{
				if( tbbAuto.Pushed )
				{
					FAutoSetting fAutoSetting = new FAutoSetting();
					if( fAutoSetting.ShowDialog() == DialogResult.Cancel )
					{
						tbbAuto.Pushed = false;
						return;
					}

					fxAuto = new FXAuto( tradeDesk
						, tradeDesk.GetFormSelectedRow( FXTradeDesk.ACCOUNTS )["AccountID"].ToString()
						, fAutoSetting.OnePosition, fAutoSetting.MaxPosition
						, fAutoSetting.IsTwiceReturn, FXIni.GetString( "Path", "SignalFolder", null )
						, FXIni.GetString( "Path", "SignalBackupFolder", null ) );

					autoOrderThread = new Thread( new ThreadStart( fxAuto.Start ) );

					autoOrderThread.Start();
				}
				else
				{
					if( autoOrderThread != null )
					{
						// AbortɃ{^GȂ悤ɂ邽߁B
						tbbAuto.Enabled = false;

						autoOrderThread.Abort();
						fxAuto = null;

						tbbAuto.Enabled = true;
					}
				}
			}
		}
	}
}