using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FXCommon;

namespace FXCMTrader
{
	public partial class FOffers : FChild
	{
		public FOffers( FXTradeDesk tradeDesk, string tableType )
			: base( tradeDesk, tableType )
		{
			InitializeComponent();
		}

		protected override void SetHideColumns()
		{
			grdData.Cols["OfferID"].Visible = false;
			grdData.Cols["ContractCurrency"].Visible = false;
			grdData.Cols["ContractSize"].Visible = false;
			grdData.Cols["Digits"].Visible = false;
			grdData.Cols["DefaultSortOrder"].Visible = false;
			grdData.Cols["BidChangeDirection"].Visible = false;
			grdData.Cols["AskChangeDirection"].Visible = false;
			grdData.Cols["HiChangeDirection"].Visible = false;
			grdData.Cols["LowChangeDirection"].Visible = false;
			grdData.Cols["QuoteID"].Visible = false;
			grdData.Cols["BidID"].Visible = false;
			grdData.Cols["AskID"].Visible = false;
		}

		/// <summary>
		/// ObhIsf[^słȂ΃j[
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region mnuSub_Popup(object sender, System.EventArgs e)
		private void mnuSub_Popup( object sender, System.EventArgs e )
		{
			if( grdData.Row < 1 )
			{
				mnuEntry.Enabled = false;
				mnuMarket.Enabled = false;
			}
			else
			{
				mnuEntry.Enabled = true;
				mnuMarket.Enabled = true;
			}
		}
		#endregion

		private void mnuEntry_Click( object sender, System.EventArgs e )
		{
			this.OpenEntryOrder( true );
		}

		private void mnuMarket_Click( object sender, System.EventArgs e )
		{
			this.OpenMarketOrder( true );
		}

		protected override void grdData_MouseDown( object sender, System.Windows.Forms.MouseEventArgs e )
		{
			base.grdData_MouseDown( sender, e );

			// NbN̏ꍇ
			if( e.Button == MouseButtons.Left )
			{
				if( grdData.MouseCol == grdData.Cols["Instrument"].Index )
				{
					//TODO : NH[gNGXg
				}
				else if( grdData.MouseCol == grdData.Cols["Bid"].Index )
				{
					this.OpenMarketOrder( false );
				}
				else if( grdData.MouseCol == grdData.Cols["Ask"].Index )
				{
					this.OpenMarketOrder( true );
				}
			}
		}

		private void OpenEntryOrder( bool isBuy )
		{
			//MEMO : IĂAJEgAʉݏFMainɃ\bh쐬Aeʂɖ₢킹B
			// FSellBuyOrder̈coreǉBʉ݃Xg쐬AyђFSellBuyOrderōsB
			using( FSellBuyOrder fOrder = new FSellBuyOrder( TradeDesk, isBuy, false ) )
			{
				fOrder.ShowDialog( this );
			}
		}

		private void OpenMarketOrder( bool isBuy )
		{
			using( FSellBuyOrder fOrder = new FSellBuyOrder( TradeDesk, isBuy, true ) )
			{
				fOrder.ShowDialog( this );
			}
		}
	}
}