using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FXCommon;

namespace FXCMTrader
{
	public partial class FSellBuyOrder : FBase
	{
		private FXTradeDesk _tradeDesk;
		private bool _isBuy;
		private bool _isMarket;

		private DataRow rateRow;

		public FSellBuyOrder( FXTradeDesk tradeDesk, bool isBuy, bool isMarket )
		{
			InitializeComponent();

			_tradeDesk = tradeDesk;
			_isBuy = isBuy;
			_isMarket = isMarket;
		}

		private void FSellBuyOrder_Load( object sender, System.EventArgs e )
		{
			//MEMO : IłȂAvZXobNOEhŎcB
			// STOPALIMIT 召x̌vZB

			this.SetCmbAccount();	// AJEgR{{bNXݒ
			this.SetCmbInstr();		// ʉ݃R{{bNXݒ

			this.GetFormValues();

			cmbAccount.SelectedValue = _tradeDesk.GetFormSelectedRow( FXTradeDesk.ACCOUNTS )["AccountID"].ToString();

			rateRow = _tradeDesk.GetFormSelectedRow( FXTradeDesk.OFFERS );
			cmbInstr.SelectedValue = rateRow["OfferID"].ToString();

			this.SetRatesProperty();	// Rate֘ÃvpeBݒ( rateRow gp )
			this.SetRate();

			if( _isBuy )
			{
				rdoBuy.Checked = true;
			}
			else
			{
				rdoSell.Checked = true;
			}

			if( _isMarket )
			{
				this.Text = "Market Order";

				nudRate.ReadOnly = true;

				// }[PbgiXVCxgRt
				rateRow.Table.RowChanged += new DataRowChangeEventHandler( RateChanged );
			}
			else
			{
				this.Text = "Entry Order";
			}

			cmbAmount.Focus();
		}

		/// <summary>
		/// [g{bNX̒lݒ肵܂B
		/// </summary>
		#region SetRate()
		private void SetRate()
		{
			if( _isBuy )
			{
				nudRate.Value = Decimal.Parse( rateRow["Ask"].ToString() );
			}
			else
			{
				nudRate.Value = Decimal.Parse( rateRow["Bid"].ToString() );
			}
		}
		#endregion

		/// <summary>
		/// tH[̃ftHglINIt@Cǂݍ݁Aݒ肵܂B
		/// </summary>
		#region GetFormValues()
		private void GetFormValues()
		{
			cmbAccount.Text = FXIni.GetString( "SellBuyOrder", "Account", "" );
			cmbAmount.Text = FXIni.GetString( "SellBuyOrder", "Amount", "10" );
			nudAtMarket.Value = FXIni.GetDecimal( "SellBuyOrder", "AtMarket", 0m );
			ckbStop.Checked = FXIni.GetBoolean( "SellBuyOrder", "Stop", false );
			ckbLimit.Checked = FXIni.GetBoolean( "SellBuyOrder", "Limit", false );
			ckbTrailing.Checked = FXIni.GetBoolean( "SellBuyOrder", "Trailing", false );
			nudTrailing.Value = FXIni.GetDecimal( "SellBuyOrder", "TrailingNum", 0m );
		}
		#endregion

		/// <summary>
		/// tH[̒lINIt@Cɏ݂܂B
		/// </summary>
		#region SetFormValues()
		private void SetFormValues()
		{
			FXIni.WriteString( "SellBuyOrder", "Account", cmbAccount.Text );
			//			FXIni.WriteString( "SellBuyOrder", "Instrument", cmbInstr.Text );
			//			FXIni.WriteString( "SellBuyOrder", "Buy", rdoBuy.Checked );
			FXIni.WriteString( "SellBuyOrder", "Amount", cmbAmount.Text );
			FXIni.WriteString( "SellBuyOrder", "AtMarket", nudAtMarket.Value );
			FXIni.WriteString( "SellBuyOrder", "Stop", ckbStop.Checked );
			FXIni.WriteString( "SellBuyOrder", "Limit", ckbLimit.Checked );
			FXIni.WriteString( "SellBuyOrder", "Trailing", ckbTrailing.Checked );
			FXIni.WriteString( "SellBuyOrder", "TrailingNum", nudTrailing.Value );
		}
		#endregion

		/// <summary>
		/// [g֘A{bNX̃vpeBݒ肵܂B
		/// </summary>
		#region SetRatesProperty()
		private void SetRatesProperty()
		{
			int digits = Int32.Parse( rateRow["Digits"].ToString() );

			string digitstr = "0.";

			for( int ii = 0; ii < digits; ii++ )
			{
				if( ii < digits - 1 )
					digitstr += "0";
				else
					digitstr += "1";
			}

			decimal increment = Decimal.Parse( digitstr );

			nudRate.DecimalPlaces = digits;
			nudRate.Increment = increment;

			nudStop.DecimalPlaces = digits;
			nudStop.Increment = increment;
			nudStop.Value = -1m;

			nudLimit.DecimalPlaces = digits;
			nudLimit.Increment = increment;
			nudLimit.Value = -1m;
		}
		#endregion

		/// <summary>
		/// AJEgR{{bNXݒ肵܂B
		/// </summary>
		#region SetCmbAccount()
		private void SetCmbAccount()
		{
			DataTable dt = _tradeDesk.TableDataSet.Tables[FXTradeDesk.ACCOUNTS];
			cmbAccount.DataSource = new FXComboItem( dt, "AccountName", "AccountID" ).GetDataSouce();
			cmbAccount.DisplayMember = FXComboItem.DISPLAY;
			cmbAccount.ValueMember = FXComboItem.VALUE;
		}
		#endregion

		/// <summary>
		/// ʉ݃R{{bNXݒ肵܂B
		/// </summary>
		#region SetCmbInstr()
		private void SetCmbInstr()
		{
			DataTable dt = _tradeDesk.TableDataSet.Tables[FXTradeDesk.OFFERS];
			cmbInstr.DataSource = new FXComboItem( dt, "Instrument", "OfferID" ).GetDataSouce();
			cmbInstr.DisplayMember = FXComboItem.DISPLAY;
			cmbInstr.ValueMember = FXComboItem.VALUE;
		}
		#endregion

		/// <summary>
		/// [gɕύXꍇɔA[g{bNXXV܂B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RateChanged( object sender, DataRowChangeEventArgs e )
		{
			if( e.Row == rateRow )
				this.SetRate();
		}

		private void btnOk_Click( object sender, System.EventArgs e )
		{
			object orderID;
			object dealerIntervation;

			double stop = 0d;
			double limit = 0d;
			int trailing = 0;

			if( ckbStop.Checked )
				stop = Double.Parse( nudStop.Value.ToString() );

			if( ckbLimit.Checked )
				limit = Double.Parse( nudLimit.Value.ToString() );

			if( ckbTrailing.Checked )
				trailing = Int32.Parse( nudTrailing.Value.ToString() );

			if( _isMarket )
			{
				_tradeDesk.OpenTrade( cmbAccount.SelectedValue.ToString(), rateRow["Instrument"].ToString()
					, rdoBuy.Checked, Int32.Parse( cmbAmount.Text ), Double.Parse( nudRate.Value.ToString() )
					, rateRow["QuoteID"].ToString(), Int32.Parse( nudAtMarket.Value.ToString() )
					, stop, limit, trailing, out orderID, out dealerIntervation );
			}
			else
			{
				_tradeDesk.CreateEntryOrder( cmbAccount.SelectedValue.ToString(), rateRow["Instrument"].ToString()
					, rdoBuy.Checked, Int32.Parse( cmbAmount.Text ), Double.Parse( nudRate.Value.ToString() )
					, stop, limit, trailing, out orderID, out dealerIntervation );
			}

			this.SetFormValues();
			this.DialogResult = DialogResult.OK;
		}

		private void btnCancel_Click( object sender, System.EventArgs e )
		{
			this.DialogResult = DialogResult.Cancel;
		}

		private void ckbStop_CheckedChanged( object sender, System.EventArgs e )
		{
			nudStop.Enabled = ckbStop.Checked;
			bool b = nudStop.InterceptArrowKeys;
		}

		private void ckbLimit_CheckedChanged( object sender, System.EventArgs e )
		{
			nudLimit.Enabled = ckbLimit.Checked;
		}

		private void ckbTrailing_CheckedChanged( object sender, System.EventArgs e )
		{
			nudTrailing.Enabled = ckbTrailing.Checked;
		}

		/// <summary>
		/// ʉ݃R{{bNXɕύXꍇA[g֘AĐݒ肵܂B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbInstr_SelectionChangeCommitted( object sender, System.EventArgs e )
		{
			rateRow = _tradeDesk.GetDataRow( FXTradeDesk.OFFERS, cmbInstr.SelectedValue );
			this.SetRatesProperty();
			this.SetRate();
		}

		/// <summary>
		/// [gɕύXꍇAŒXgbvAŒ჊~bgݒ肵܂B
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		#region nudRate_ValueChanged(object sender, System.EventArgs e)
		private void nudRate_ValueChanged( object sender, System.EventArgs e )
		{
			decimal minStop = Tool.GetMinStop( rateRow["Ask"], rateRow["Bid"] );
			decimal minLimit = Tool.GetMinLimit( rateRow["Ask"], rateRow["Bid"] );

			lblStopRate.Text = "<=" + minStop.ToString();
			lblLimitRate.Text = ">=" + minLimit.ToString();

			if( nudStop.Value < 0 // ʃI[vォAʉ݃R{{bNXIύX
				|| nudStop.Value > minStop )
				nudStop.Value = minStop;

			if( nudLimit.Value < 0
				|| nudLimit.Value < minLimit )
				nudLimit.Value = minLimit;
		}
		#endregion
	}
}