using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace FXCommon
{
	public class EasyMessageBox
	{
		public static DialogResult MessageError( string message, string title )
		{
			if( Tool.IsNull( title ) )
			{
				title = "Error";
			}

			return MessageBox.Show( message, title, MessageBoxButtons.OK, MessageBoxIcon.Error );
		}

		public static DialogResult MessageQuestion( string message, string title )
		{
			if( Tool.IsNull( title ) )
			{
				title = "Question";
			}

			return MessageBox.Show( message, title, MessageBoxButtons.YesNo, MessageBoxIcon.Question );
		}

		public static DialogResult MessageInformation( string message, string title )
		{
			if( Tool.IsNull( title ) )
			{
				title = "Information";
			}

			return MessageBox.Show( message, title, MessageBoxButtons.OK, MessageBoxIcon.Information );
		}
	}
}
