using System;
using System.Collections.Generic;
using System.Text;

using System.Data;
using System.IO;
using System.Threading;

namespace FXCommon
{
	public class FXAuto
	{
		private FXTradeDesk _tradeDesk;
		private string _accountID;
		private int _onePosition;
		private int _maxPosition;
		private bool _isTwiceReturn;
		private string _signalFolderPath;
		private string _backupFolderPath;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="tradeDesk">g[hfXNIuWFNg</param>
		/// <param name="accountID">AJEgID</param>
		/// <param name="onePosition">1|WV̖</param>
		/// <param name="maxPosition">ő|WV</param>
		/// <param name="isTwiceReturn">ۗL|WVƋt̃VOiA{ԂꍇAtrueBłȂꍇAfalseB</param>
		/// <param name="signalFolderPath">VOit@CutH_̃pX</param>
		/// <param name="backupFolderPath">󂯎VOit@C̃obNAbvutH_̃pX</param>
		public FXAuto( FXTradeDesk tradeDesk, string accountID, int onePosition
			, int maxPosition, bool isTwiceReturn, string signalFolderPath, string backupFolderPath )
		{
			_tradeDesk = tradeDesk;
			_accountID = accountID;
			_onePosition = onePosition * 10; //  * 10000ʉ(10k) ŒᔄPʂ10kȂ
			_maxPosition = maxPosition;
			_isTwiceReturn = isTwiceReturn;
			_signalFolderPath = signalFolderPath;
			_backupFolderPath = backupFolderPath;
		}

		/// <summary>
		/// Jn܂B
		/// </summary>
		public void Start()
		{
			FXSignalReader reader;
			FXSignal signal;

			// ɂVOit@C
			this.InitSignalFile();

			while( true )
			{
				// 5bɃ`FbN
				Thread.Sleep( 5000 );

				// VOit@C擾
				reader = new FXSignalReader( _signalFolderPath, _backupFolderPath );
				signal = reader.Read();

				if( signal == null )
					continue;

				if( signal.Order == OrderType.Buy
					|| signal.Order == OrderType.Sell )
				{
					// ̏ꍇ
					object orderID;
					object dealerIntervation;
					object DI;
					
					bool isBuy = true;
					if( signal.Order == OrderType.Sell )
						isBuy = false;

					// |WVɎĂ邩
					bool isSamePosition = false;

					// {Ԃ̏ꍇ͊̓ʉ݃|WVB
					if( _isTwiceReturn )
					{
						// Tradese[uAJEgIDƒʉ݃yAɊYs擾
						DataRow tradesRow = _tradeDesk.GetTradesRowFromAccountAndInstr( _accountID, signal.CurrencyPair );
						if( tradesRow != null )
						{
							// |WVƃVOit̏ꍇ̂݃N[Y
							if( ( tradesRow["IsBuy"].ToString() == "True" && !isBuy )
								|| ( tradesRow["IsBuy"].ToString() == "False" && isBuy ) )
							{
								this.CloseTrade( signal, tradesRow, out orderID, out DI );
							}
							else
							{
								isSamePosition = true;
							}
						}
					}

					// ݂̃|WVő|WVȏłꍇAȂB
					if( _maxPosition <= _tradeDesk.TableDataSet.Tables[FXTradeDesk.TRADES].Rows.Count )
					{
						continue;
					}

					// |WVĂȂꍇ̂݃|WV
					//MEMO : ǉ|W𗧂Ăꍇ͂悤̃tO쐬B
					if( !isSamePosition )
					{
						// |WV
						this.OpenTrade( signal, isBuy, out orderID, out dealerIntervation );
					}
				}
				else if( signal.Order == OrderType.Close )
				{
					// Tradese[uAJEgIDƒʉ݃yAɊYs擾
					DataRow tradesRow = _tradeDesk.GetTradesRowFromAccountAndInstr( _accountID, signal.CurrencyPair );
					if( tradesRow != null )
					{
						// |WVꍇ
						object orderID;
						object DI;

						// |WV
						this.CloseTrade( signal, tradesRow, out orderID, out DI );
					}
				}
				else
				{
					continue;
				}
			}
		}

		/// <summary>
		/// |WV܂B
		/// </summary>
		/// <param name="signal">VOiIuWFNg</param>
		/// <param name="isBuy">̏ꍇAtrueB̏ꍇAfalseB</param>
		/// <param name="orderID"></param>
		/// <param name="dealerIntervation"></param>
		private void OpenTrade( FXSignal signal, bool isBuy, out object orderID, out object dealerIntervation )
		{
			orderID = null;
			dealerIntervation = null;

			// Offerse[uʉ݃yAɊYs擾
			DataRow offersRow = _tradeDesk.GetOffersRowFromInstr( signal.CurrencyPair );
			if( offersRow == null )
				return;

			double rate = -1;
			if( isBuy )
			{
				rate = Double.Parse( offersRow["Ask"].ToString() );
			}
			else
			{
				rate = Double.Parse( offersRow["Bid"].ToString() );
			}

			_tradeDesk.OpenTrade( _accountID, offersRow["Instrument"].ToString(), isBuy, _onePosition
				, rate, offersRow["QuoteID"].ToString(), signal.AtMarket, signal.Stop
				, signal.Limit, signal.TrailMinMove, out orderID, out dealerIntervation );
		}

		/// <summary>
		/// |WV܂B
		/// </summary>
		/// <param name="signal">VOiIuWFNg</param>
		/// <param name="tradesRow">N[Y|WVs</param>
		/// <param name="orderID"></param>
		/// <param name="DI"></param>
		private void CloseTrade( FXSignal signal, DataRow tradesRow, out object orderID, out object DI )
		{
			orderID = null;
			DI = null;

			//// Tradese[uAJEgIDƒʉ݃yAɊYs擾
			//DataRow tradesRow = _tradeDesk.GetTradesRowFromAccountAndInstr( _accountID, signal.CurrencyPair );
			//if( tradesRow == null )
			//    return;

			double rate = Double.Parse( tradesRow["Close"].ToString() );

			_tradeDesk.CloseTrade( tradesRow["TradeID"].ToString(), _onePosition, rate
				, tradesRow["QuoteID"].ToString(), signal.AtMarket, out orderID, out DI );
		}

		/// <summary>
		/// Oɑ݂ĂVOit@CSăobNAbvtH_ֈړ܂B
		/// ̃t@Cƌ悤Ƀt@C擪'_'t^܂B
		/// </summary>
		private void InitSignalFile()
		{
			// tH_݃`FbN
			if( !Directory.Exists( _signalFolderPath ) )
			{
				throw new ApplicationException( "'" + _signalFolderPath + "'݂͑܂B" );
			}

			// signalt@CS擾
			string[] files = Directory.GetFiles( _signalFolderPath, "*.signal" );

			// t@C݂ȂΏI
			if( files == null || files.Length == 0 )
				return;

			for( int i = 0; i < files.Length; i++ )
			{
				// VOit@CobNAbvtH_ֈړ
				FileInfo fileInfo = new FileInfo( files[i] );
				File.Move( files[i], _backupFolderPath + "\\_" + fileInfo.Name );
			}
		}
	}
}
