using System;
using System.Collections.Generic;
using System.IO;                      // File class
using System.Text;                    // StringBuilder
using System.Windows.Forms;           // MessageBox
using System.Runtime.InteropServices; // DllImport
using System.Drawing;                 // Color
using System.Diagnostics; // Debug

namespace FXCommon
{
	public class FXIni
	{
				private static string FFileName = "";

		public static void Init()
		{
			FFileName = GetIniFilePath();
		}

		private static string GetIniFilePath()
		{
			return Application.StartupPath + "\\profiles.ini";
		}

		// w INI t@C̑ۂ`FbN
		private static void CheckIniFile()
		{
			if (!File.Exists(FFileName))
				throw new ArgumentException("w INI t@C݂͑܂");
		}

		// Color ^ ToString \bhŕϊ񂩂 Color ^擾
		private static Color GetColorFromString(string s)
		{
			int n1 = s.IndexOf("[");
			int n2 = s.IndexOf("]");
			string colorName = s.Substring(n1 + 1 , n2 - n1 - 1);

			return Color.FromName(colorName);
		}
		
		// w̃ZNVׂ̂ẴL[ێ镶z擾
		public static string[] GetKeyNames(string sectionName)
		{
			CheckIniFile();

			byte[] byteArray = new byte[4096];

			int size = NativeMethods.GetPrivateProfileStringByteArray(
				sectionName, null, null, byteArray, byteArray.Length, FFileName);

			// oCgz𕶎̔zɕϊ
			string s = System.Text.Encoding.Default.GetString(byteArray, 0, size - 1);

			// ߂l̕ \0 ŋ؂Ă
			string[] keyNames = s.Split('\0');

			return keyNames;
		}

		// ׂẴZNVێ镶̔z擾
		public static string[] GetSectionNames()
		{
			CheckIniFile();

			byte[] byteArray = new byte[4096];

			int size = NativeMethods.GetPrivateProfileStringByteArray(
				null, null, null, byteArray, byteArray.Length, FFileName);

			// oCgz𕶎̔zɕϊ
			string s = System.Text.Encoding.Default.GetString(byteArray, 0, size - 1);

			// ߂l̕ \0 ŋ؂Ă
			string[] sectionNames = s.Split('\0');

			return sectionNames;
		}

		// w̃ZNV폜iZNVɊ܂܂L[ƒl폜j
		public static void DeleteSection(string sectionName)
		{
			CheckIniFile();

			NativeMethods.WritePrivateProfileString(sectionName, null, null, FFileName);
		}

		// w̃L[폜
		public static void DeleteKey(string sectionName, string keyName)
		{
			CheckIniFile();

			NativeMethods.WritePrivateProfileString(sectionName, keyName, null, FFileName);
		}

		// w̃L[̕Ԃ
		public static string GetString(string sectionName, string keyName, string defValue)
		{
			CheckIniFile();

			const int size = 1024;
			StringBuilder sb = new StringBuilder(size);
			NativeMethods.GetPrivateProfileString(sectionName, keyName, defValue, sb, size, FFileName);
			return sb.ToString();
		}

		// w̃L[ DateTime \̂擾
		public static DateTime GetDateTime(string sectionName, string keyName, DateTime defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return DateTime.Parse(s);
		}

		// w̃L[ KnwonColor enum ^Ɋ܂܂F擾
		public static Color GetColor(string sectionName, string keyName, Color defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return GetColorFromString(s);
		}

		public static bool GetBoolean(string sectionName, string keyName, bool defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToBoolean(s);
		}

		public static byte GetByte(string sectionName, string keyName, byte defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToByte(s);
		}

		public static char GetChar(string sectionName, string keyName, char defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToChar(s);
		}
		
		public static decimal GetDecimal(string sectionName, string keyName, decimal defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToDecimal(s);
		}
		
		public static double GetDouble(string sectionName, string keyName, double defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToDouble(s);
		}
		
		public static float GetSingle(string sectionName, string keyName, float defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToSingle(s);
		}
		
		public static short GetInt16(string sectionName, string keyName, short defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToInt16(s);
		}
		
		public static int GetInt32(string sectionName, string keyName, int defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToInt32(s);
		}
		
		public static long GetInt64(string sectionName, string keyName, long defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToInt64(s);
		}
		
		public static sbyte GetSByte(string sectionName, string keyName, sbyte defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToSByte(s);
		}
		
		public static ushort GetUInt16(string sectionName, string keyName, ushort defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToUInt16(s);
		}
		
		public static uint GetUInt32(string sectionName, string keyName, uint defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToUInt32(s);
		}
		
		public static ulong GetUInt64(string sectionName, string keyName, ulong defValue)
		{
			CheckIniFile();
			string defString = defValue.ToString();
			string s = GetString(sectionName, keyName, defString);
			return Convert.ToUInt64(s);
		}

		// w̃L[̕ݒ肷
		// ȊÕf[^ׂẴ\bhgp
		// f[^ ToString \bhg
		public static void WriteString(string sectionName, string keyName, object Value)
		{
			NativeMethods.WritePrivateProfileString(sectionName, keyName, Value.ToString(), FFileName);
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	internal class NativeMethods
	{
		//yӁzPrivate n̊֐̓t@CƂătpXŎw肵Ȃ΂ȂȂƂɒ
		
		[DllImport("KERNEL32.DLL", CharSet=CharSet.Auto)]
		public static extern int GetPrivateProfileString(
			string appName, string keyName, string defValue, StringBuilder result, int size, string fileName);

		[DllImport("KERNEL32.DLL", EntryPoint="GetPrivateProfileString", CharSet=CharSet.Auto)]
		public static extern int GetPrivateProfileStringByteArray(
			string appName, string keyName, string defValue, byte[] result, int size, string fileName);

		[DllImport("KERNEL32.DLL", CharSet=CharSet.Auto)]
		public static extern int GetPrivateProfileInt(
			string appName, string keyName, int defValue, string fileName );

		[DllImport("KERNEL32.DLL", CharSet=CharSet.Auto)]
		public static extern int WritePrivateProfileString(
			string appName, string keyName, string setValue, string fileName);
	}
}
