using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace FXCommon
{
	/// <summary>
	/// ONXłB
	/// </summary>
	public class FXLog
	{
		private const string ERROR = "[Error] ";

		private static string _logFilePath = null;
		private static StringBuilder logText = new StringBuilder();

		/// <summary>
		/// O݂܂BO̓ɗ߂1000ɏo͂܂B
		/// </summary>
		/// <param name="obj">Oe</param>
		public static void Write( object obj )
		{
			logText.AppendLine( DateTime.Now.ToString( "YYYY/MM/DD h24:mi:ss" ) + " " + obj.ToString() );

			// 1000ɕۑ
			if( 1000 < logText.Length )
				Save();
		}

		/// <summary>
		/// G[O݂܂B
		/// </summary>
		/// <param name="obj"></param>
		public static void WriteError( object obj )
		{
			Write( ERROR + obj.ToString() );
		}

		/// <summary>
		/// Oۑ܂B
		/// </summary>
		public static void Save()
		{
			string fileName = DateTime.Now.ToString( "YYYY_MM_DD" ) + ".log";

			if( _logFilePath == null )
			{
				_logFilePath = FXIni.GetString( "Log", "FilePath", Application.StartupPath + "Log" );
			}

			if( !Directory.Exists( _logFilePath ) )
			{ 
				// OtH_݂ȂꍇA쐬
				Directory.CreateDirectory( _logFilePath );
			}

			string filePath = _logFilePath + fileName;

			StreamWriter writer = new StreamWriter( fileName, true );
			writer.Write( logText.ToString() );
			writer.Flush();
			writer.Close();

			logText = new StringBuilder();
		}
	}
}
