using System;
using System.Collections.Generic;
using System.Text;

using System.IO;

namespace FXCommon
{
	class FXSignalReader
	{
		private const int CURRENCY_PAIR = 0;
		private const int ORDER = 1;
		private const int LOT_NO = 2;
		private const int RATE = 3;
		private const int AT_MARKET = 4;
		private const int STOP = 5;
		private const int LIMIT = 6;
		private const int TRAIL_MIN_MOVE = 7;

		public string FolderPath;
		public string BackupFolderPath;

		/// <summary>
		/// RXgN^łB
		/// </summary>
		/// <param name="folderPath">VOit@C̒utH_̃pX</param>
		/// <param name="backupFolderPath">VOit@C̃obNAbvutH_̃pX</param>
		public FXSignalReader(string folderPath, string backupFolderPath)
		{
			this.FolderPath = folderPath;
			this.BackupFolderPath = backupFolderPath;
		}

		public FXSignal Read()
		{
			// tH_݃`FbN
			if( !Directory.Exists( FolderPath ) )
			{
				throw new ApplicationException( "'" + FolderPath + "'݂͑܂B" );
			}

			// signalt@CS擾
			string[] files = Directory.GetFiles( FolderPath, "*.signal" );

			// t@C݂ȂΏI
			if( files == null || files.Length == 0 )
				return null;

			// ŏɌ擾Ȃ
			string filePath = files[0];

			// t@C1sڂ̂ݎ擾
			StreamReader reader = new StreamReader( filePath );
			string[] line = reader.ReadLine().Split( ',' );

			reader.Close();

			// VOit@CobNAbvtH_ֈړ
			FileInfo fileInfo = new FileInfo( filePath );
			File.Move( filePath, BackupFolderPath + "\\" + fileInfo.Name );

			FXSignal signal = new FXSignal();
			
			signal.FileName = fileInfo.Name;

			signal.CurrencyPair = line[CURRENCY_PAIR];

			if( line[ORDER] == "Buy" )
			{
				signal.Order = OrderType.Buy;
			}
			else if( line[ORDER] == "Sell" )
			{
				signal.Order = OrderType.Sell;
			}
			else if( line[ORDER] == "Close" )
			{
				signal.Order = OrderType.Close;
			}

			if( line[LOT_NO] != null && 0 < line[LOT_NO].Length )
			{
				signal.LotNo = Int32.Parse( line[LOT_NO] );
			}

			if( line[RATE] != null && 0 < line[RATE].Length )
			{
				signal.Rate = Double.Parse( line[RATE] );
			}

			if( line[AT_MARKET] != null && 0 < line[AT_MARKET].Length )
			{
				signal.AtMarket = Int32.Parse( line[AT_MARKET] );
			}

			if( line[STOP] != null && 0 < line[STOP].Length )
			{
				signal.Stop = Double.Parse( line[STOP] );
			}

			if( line[LIMIT] != null && 0 < line[LIMIT].Length )
			{
				signal.Limit = Double.Parse( line[LIMIT] );
			}

			if( line[TRAIL_MIN_MOVE] != null && 0 < line[TRAIL_MIN_MOVE].Length )
			{
				signal.TrailMinMove = Int32.Parse( line[TRAIL_MIN_MOVE] );
			}

			return signal;
		}
	}
}
