using System;
using System.Collections.Generic;
using System.Text;

using System.Collections;
using System.Data;
using System.Reflection;

using FXCore;

namespace FXCommon
{
	public class FXTradeDesk
	{
		#region e[uꗗ
		/// <summary>
		/// offers \萔
		/// </summary>
		public const string OFFERS = "offers";

		/// <summary>
		/// trades \萔
		/// </summary>
		public const string TRADES = "trades";

		/// <summary>
		/// accounts \萔
		/// </summary>
		public const string ACCOUNTS = "accounts";

		/// <summary>
		/// closed trades \萔
		/// </summary>
		public const string CLOSED_TRADES = "closed trades";

		/// <summary>
		/// orders \萔
		/// </summary>
		public const string ORDERS = "orders";

		/// <summary>
		/// summary \萔
		/// </summary>
		public const string SUMMARY = "summary";

		/// <summary>
		/// messages \萔
		/// </summary>
		public const string MESSAGES = "messages";

		/// <summary>
		/// rquotes \萔
		/// </summary>
		public const string RQUOTES = "rquotes";

		/// <summary>
		/// instr \萔
		/// </summary>
		public const string INSTR = "instr";
		#endregion

		public string LoginID;

		private TradeDeskAut _tradeDesk;
		private DataSet _tableDataSet;
		private TradeDeskEventsSinkClass eventSink;
		private int subscriptionID;

		private Hashtable formSelectedRow;


		/// <summary>
		/// ee[ui[f[^ZbgłB
		/// TableDataSet.Tables[FXTradeDesk.e[u]ŔCӂ̃e[u擾邱Ƃo܂B
		///  RQUOTESAy INSTR e[u͎擾ł܂B(擾̍ۃG[ł邽߁B)
		/// </summary>
		public DataSet TableDataSet
		{
			get { return ( this._tableDataSet ); }
			set { this._tableDataSet = value; }
		}

		/// <summary>
		/// 
		/// </summary>
		public TradeDeskEventsSinkClass EventSink
		{
			get { return ( this.eventSink ); }
			set { this.eventSink = value; }
		}

		/// <summary>
		/// 
		/// </summary>
		public int SubscriptionID
		{
			get { return ( this.subscriptionID ); }
			set { this.subscriptionID = value; }
		}

		//--------------------------------------------------------------------------------------------------------

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="tradeDesk"></param>
		public FXTradeDesk( TradeDeskAut tradeDesk )
		{
			_tradeDesk = tradeDesk;

			//			try
			//			{
			//				FXChartComponent.ChartComponentAut ccc = new FXChartComponent.ChartComponentAutClass();
			//				FXChartComponent.PriceConnectionAut pc = (FXChartComponent.PriceConnectionAutClass)ccc.Connection;
			//				pc.LoginDefault();
			//				FXChartComponent.ChartModelAutClass cmac = new ChartModelAutClass();
			//				cmac.CreateIndicatorInNewArea(
			//			}
			//			catch(Exception ex)
			//			{
			//				Console.WriteLine( ex.Message );
			//			}
		}

		public void Login( string sLogin, string sPassw, string sUrl, string sHost )
		{
			_tradeDesk.Login( sLogin, sPassw, sUrl, sHost );
			this.LoginID = sLogin;

			eventSink = new TradeDeskEventsSinkClass();
			subscriptionID = this.Subscribe( eventSink );

			// sǉXV폜CxgRt
			this.eventSink.ITradeDeskEvents_Event_OnRowAdded += new ITradeDeskEvents_OnRowAddedEventHandler( eventSink_ITradeDeskEvents_Event_OnRowAdded );
			this.eventSink.ITradeDeskEvents_Event_OnRowBeforeRemove += new ITradeDeskEvents_OnRowBeforeRemoveEventHandler( eventSink_ITradeDeskEvents_Event_OnRowBeforeRemove );
			this.eventSink.ITradeDeskEvents_Event_OnRowChanged += new ITradeDeskEvents_OnRowChangedEventHandler( eventSink_ITradeDeskEvents_Event_OnRowChanged );

			this.SetTableDataSet();

			formSelectedRow = new Hashtable( _tableDataSet.Tables.Count );
		}

		private void SetTableDataSet()
		{
			_tableDataSet = new DataSet( "FXCM" );

			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( OFFERS ), "OfferID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( TRADES ), "TradeID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( ACCOUNTS ), "AccountID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( CLOSED_TRADES ), "TradeID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( ORDERS ), "OrderID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( SUMMARY ), "OfferID" ) );
			_tableDataSet.Tables.Add( this.SetTable( this.FindMainTable( MESSAGES ), "MsgID" ) );
		}

		#region SetTable()
		private DataTable SetTable( TableAut table, string primarykeyID )
		{
			if( table == null )
				return null;

			DataTable dt = new DataTable( table.Type );

			// ꗗ擾
			ColumnsEnumAut columns = (ColumnsEnumAut)table.Columns;
			string[] columnID = new string[columns.Count];
			int index = 0;
			foreach( ColumnAut column in columns )
			{
				DataColumn dc = dt.Columns.Add( column.Title );
				columnID[index++] = column.ID;
				if( column.ID == primarykeyID )
				{
					dt.PrimaryKey = new DataColumn[1] { dc };
				}
			}

			if( dt.PrimaryKey == null
				|| dt.PrimaryKey.Length < 1 )
			{
				throw new ArgumentException( "not found", "primarykeyID" );
			}

			for( uint i = 0; i < table.RowCount; i++ )
			{
				DataRow drow = dt.NewRow();
				for( int j = 0; j < columnID.Length; j++ )
				{
					drow[j] = table.CellValue( i + 1, columnID[j] );
				}

				dt.Rows.Add( drow );
			}

			return dt;
		}
		#endregion

		/// <summary>
		/// w肵e[u擾܂B
		/// DataTable^Ŏ擾ꍇ́AvpeB TableDataSet 擾ĉB
		/// </summary>
		/// <param name="sTableType"></param>
		/// <returns></returns>
		private TableAut FindMainTable( string sTableType )
		{
			return (TableAut)_tradeDesk.FindMainTable( sTableType );
		}

		/// <summary>
		/// we[ũtH[őIĂs擾܂B
		/// </summary>
		/// <param name="tableType"></param>
		/// <returns></returns>
		public DataRow GetFormSelectedRow( string tableType )
		{
			return (DataRow)formSelectedRow[tableType];
		}

		/// <summary>
		/// we[ũtH[őIĂsݒ肵܂B
		/// </summary>
		/// <param name="row"></param>
		public void SetFormSelectedRow( DataRow row )
		{
			if( formSelectedRow[row.Table.TableName] != row )
				formSelectedRow[row.Table.TableName] = row;
		}

		/// <summary>
		/// tableTypeŎw肵e[u keyValue L[Ƃs擾܂B
		/// </summary>
		/// <param name="tableType"></param>
		/// <param name="keyValue"></param>
		/// <returns></returns>
		public DataRow GetDataRow( string tableType, object keyValue )
		{
			DataTable dt = TableDataSet.Tables[tableType];

			object[] values = new object[1] { keyValue };

			return dt.Rows.Find( values );
		}

		/// <summary>
		/// Offerse[uʉ݃yAL[ɌAs擾܂B
		/// </summary>
		/// <param name="instrument">ʉ݃yA</param>
		/// <returns>Ys</returns>
		public DataRow GetOffersRowFromInstr( string instrument )
		{
			DataRow resultRow = null;
			DataTable dt = TableDataSet.Tables[OFFERS];
			foreach( DataRow row in dt.Rows )
			{
				if( row["Instrument"].ToString() == instrument )
				{
					resultRow = row;
					break;
				}
			}

			return resultRow;
		}

		/// <summary>
		/// Tradese[uAJEgIDƒʉ݃yAL[ɌAs擾܂B
		/// ݂ꍇAŏɌs擾܂B
		/// </summary>
		/// <param name="accountID">AJEgID</param>
		/// <param name="instrument">ʉ݃yA</param>
		/// <returns>Ys</returns>
		public DataRow GetTradesRowFromAccountAndInstr( string accountID, string instrument )
		{
			DataRow resultRow = null;
			DataTable dt = TableDataSet.Tables[TRADES];
			foreach( DataRow row in dt.Rows )
			{
				if( row["AccountID"].ToString() == accountID
					&& row["Instrument"].ToString() == instrument )
				{
					resultRow = row;
					break;
				}
			}

			return resultRow;
		}

		/// <summary>
		/// e[usǉCxg
		/// </summary>
		/// <param name="oTable"></param>
		/// <param name="sRowID"></param>
		#region eventSink_ITradeDeskEvents_Event_OnRowAdded(object oTable, string sRowID)
		private void eventSink_ITradeDeskEvents_Event_OnRowAdded( object oTable, string sRowID )
		{
			TableAut temp = (TableAut)oTable;
			DataTable dt = TableDataSet.Tables[temp.Type];
			DataColumn pkey = dt.PrimaryKey[0];

			RowAut r = (RowAut)temp.FindRow( pkey.Caption, sRowID, 0 );
			DataRow drow = dt.NewRow();
			for( int ii = 0; ii < dt.Columns.Count; ii++ )
			{
				drow[ii] = r.CellValue( ii + 1 );
			}

			dt.Rows.InsertAt( drow, 0 );
			//			dt.AcceptChanges(); // ꂪȂƑ}sFlexGrid1ԉɕ\Ă܂B

			//			this.SetTable( temp, pkey.Caption );
		}
		#endregion

		/// <summary>
		/// e[us폜Cxg
		/// </summary>
		/// <param name="oTable"></param>
		/// <param name="sRowID"></param>
		#region eventSink_ITradeDeskEvents_Event_OnRowBeforeRemove(object oTable, string sRowID)
		private void eventSink_ITradeDeskEvents_Event_OnRowBeforeRemove( object oTable, string sRowID )
		{
			TableAut temp = (TableAut)oTable;
			DataTable dt = TableDataSet.Tables[temp.Type];
			DataColumn pkey = dt.PrimaryKey[0];

			for( int ii = 0; ii < dt.Rows.Count; ii++ )
			{
				if( dt.Rows[ii][pkey.Caption].ToString() == sRowID )
				{
					dt.Rows.RemoveAt( ii );
					break;
				}
			}
		}
		#endregion

		/// <summary>
		/// e[usXVCxg
		/// </summary>
		/// <param name="oTable"></param>
		/// <param name="sRowID"></param>
		#region eventSink_ITradeDeskEvents_Event_OnRowChanged(object oTable, string sRowID)
		private void eventSink_ITradeDeskEvents_Event_OnRowChanged( object oTable, string sRowID )
		{
			TableAut temp = (TableAut)oTable;
			DataTable dt = TableDataSet.Tables[temp.Type];
			DataColumn pkey = dt.PrimaryKey[0];

			RowAut r = (RowAut)temp.FindRow( pkey.Caption, sRowID, 0 );

			for( int ii = 0; ii < dt.Rows.Count; ii++ )
			{
				if( dt.Rows[ii][pkey.Caption].ToString() == sRowID )
				{
					for( int jj = 0; jj < dt.Columns.Count; jj++ )
					{
						dt.Rows[ii][jj] = r.CellValue( jj + 1 );
					}
					break;
				}
			}
		}
		#endregion

		#region ITradeDeskAut o

		public string GetOrderStatus( string sOrderID )
		{
			return _tradeDesk.GetOrderStatus( sOrderID );
		}

		public object AcceptOrder( string wcsOrderID )
		{
			return _tradeDesk.AcceptOrder( wcsOrderID );
		}

		public void CloseTrade( string sTradeID, int iLotsNo, double dRate, string wcsQuoteID, int iAtMarket, out object sOrderID, out object sDI )
		{
			_tradeDesk.CloseTrade( sTradeID, iLotsNo * 1000, dRate, wcsQuoteID, iAtMarket, out sOrderID, out sDI );
		}

		public void OpenTrade( string wcsAccountID, string wcsInstrument, bool bIsBuy, int iLotsNo, double dRate, string wcsQuoteID, int iAtMarket, double dStop, double dLimit, int iTrailMinMove, out object psOrderId, out object psd )
		{
			_tradeDesk.OpenTrade( wcsAccountID, wcsInstrument, bIsBuy, iLotsNo * 1000, dRate, wcsQuoteID, iAtMarket, dStop, dLimit, iTrailMinMove, out psOrderId, out psd );
		}

		public string GetOrderTime( string sOrderID )
		{
			return _tradeDesk.GetOrderTime( sOrderID );
		}

		public string GetOrderType( string sOrderID )
		{
			return _tradeDesk.GetOrderType( sOrderID );
		}

		public object TablesManager
		{
			get
			{
				return _tradeDesk.TablesManager;
			}
		}

		public void AcceptQuote( string wcsRQID, bool bIsBuy )
		{
			_tradeDesk.AcceptQuote( wcsRQID, bIsBuy );
		}

		public void Unsubscribe( int ulCookie )
		{
			_tradeDesk.Unsubscribe( ulCookie );
		}

		public string GetReportURL( string sAccountID, DateTime dDateFrom, DateTime dDateTo, string sFormat, string sLangID, int lAnsiCP )
		{
			return _tradeDesk.GetReportURL( sAccountID, dDateFrom, dDateTo, sFormat, sLangID, lAnsiCP );
		}

		public void ChangeOrderRate( string sOrderID, double dRate, int iTrailMinMove )
		{
			_tradeDesk.ChangeOrderRate( sOrderID, dRate, iTrailMinMove );
		}

		public void DeleteEntryOrderStopLimit( string wcsOrderID, bool bDelStop )
		{
			_tradeDesk.DeleteEntryOrderStopLimit( wcsOrderID, bDelStop );
		}

		public bool IsLoggedIn()
		{
			return _tradeDesk.IsLoggedIn();
		}

		public int EventAdd
		{
			get
			{
				return _tradeDesk.EventAdd;
			}
		}

		public string GetTradeByOrder( string sOrderID )
		{
			return _tradeDesk.GetTradeByOrder( sOrderID );
		}

		public void CreateEntryOrder( string wcsAccountID, string wcsInstr, bool vbBuy, int iLotsNo, double dRate, double dStop, double dLimit, int iTrailMinMove, out object psOrderId, out object psDI )
		{
			_tradeDesk.CreateEntryOrder( wcsAccountID, wcsInstr, vbBuy, iLotsNo * 1000, dRate, dStop, dLimit, iTrailMinMove, out psOrderId, out psDI );
		}

		public int Subscribe( object pDisp )
		{
			return _tradeDesk.Subscribe( pDisp );
		}

		public void ChangeEntryOrderStopLimit( string wcsOrderID, double dRate, bool bIsStop, int iTrailMinMove )
		{
			_tradeDesk.ChangeEntryOrderStopLimit( wcsOrderID, dRate, bIsStop, iTrailMinMove );
		}

		public void Logout()
		{
			_tradeDesk.Logout();
		}

		public int EventChange
		{
			get
			{
				return _tradeDesk.EventChange;
			}
		}

		public string Terminal
		{
			get
			{
				return _tradeDesk.Terminal;
			}
		}

		public double GetOrderAmount( string sOrderID )
		{
			return _tradeDesk.GetOrderAmount( sOrderID );
		}

		public object RequestQuote( string wcsAccountID, string wcsInstrument, int iLotNo )
		{
			return _tradeDesk.RequestQuote( wcsAccountID, wcsInstrument, iLotNo );
		}

		public object GetSystemProperty( string sPropertyName )
		{
			return _tradeDesk.GetSystemProperty( sPropertyName );
		}

		public void ChangeTradeStopLimit( string wcsTradeID, double dRate, bool bIsStop, int iTrailMinMove )
		{
			_tradeDesk.ChangeTradeStopLimit( wcsTradeID, dRate, bIsStop, iTrailMinMove );
		}

		public void DeleteOrder( string wcsOrderID )
		{
			_tradeDesk.DeleteOrder( wcsOrderID );
		}

		public string SessionSubId
		{
			get
			{
				return _tradeDesk.SessionSubId;
			}
		}

		public void DeleteTradeStopLimit( string wcsTradeID, bool bDelStop )
		{
			_tradeDesk.DeleteTradeStopLimit( wcsTradeID, bDelStop );
		}

		public object ServerTime
		{
			get
			{
				return _tradeDesk.ServerTime;
			}
		}

		public double GetOrderSL( string sOrderID, bool bStop )
		{
			return GetOrderSL( sOrderID, bStop );
		}

		public int GetTableRowsNumber( string sTableType )
		{
			return _tradeDesk.GetTableRowsNumber( sTableType );
		}

		public object GetPendingEvents()
		{
			return _tradeDesk.GetPendingEvents();
		}

		public string GetSignalEventName()
		{
			return _tradeDesk.GetSignalEventName();
		}

		public int EventRemove
		{
			get
			{
				return _tradeDesk.EventRemove;
			}
		}

		public void EnablePendingEvents( int eventMask )
		{
			_tradeDesk.EnablePendingEvents( eventMask );
		}

		public void DeleteQuote( string wcsRQID )
		{
			_tradeDesk.DeleteQuote( wcsRQID );
		}

		public void SetOfferSubscription( string wcsOfferInstr, string sStatus )
		{
			_tradeDesk.SetOfferSubscription( wcsOfferInstr, sStatus );
		}

		public object FindRowInTable( string sTableType, object vCol, object vVal )
		{
			return _tradeDesk.FindRowInTable( sTableType, vCol, vVal );
		}

		public string UserKind
		{
			get
			{
				return _tradeDesk.UserKind;
			}
		}

		public double GetQuoteRate( string sRQuoteID, bool bAsk )
		{
			return _tradeDesk.GetQuoteRate( sRQuoteID, bAsk );
		}

		#endregion
	}
}
