using System;
using System.Collections.Generic;
using System.Text;

using System.Data;

namespace FXCommon
{
	public class Tool
	{
		public static bool IsNull( string obj )
		{
			if( obj == null )
				return true;

			obj.Replace( " ", "" );

			if( obj.Length < 1 )
				return true;

			return false;
		}

		public static bool IsNull( object obj )
		{
			return Tool.IsNull( obj.ToString() );
		}

		public static int ParseInt( object obj )
		{
			return Int32.Parse( obj.ToString() );
		}

		public static int GetSpread( object ask, object bid, object digits )
		{
			decimal a = Decimal.Parse( ask.ToString() );
			decimal b = Decimal.Parse( bid.ToString() );

			decimal d = (decimal)Math.Pow( 10, Double.Parse( digits.ToString() ) );

			return (int)( a * d ) - (int)( b * d );
		}

		public static int GetSpread( FXTradeDesk tradeDesk, string offerID )
		{
			DataTable dt = tradeDesk.TableDataSet.Tables[FXTradeDesk.OFFERS];
			DataRow row = dt.Rows.Find( new object[] { offerID } );

			return Tool.GetSpread( row["Ask"], row["Bid"], row["Digits"] );
		}

		public static decimal GetPriceBaseSpread( object ask, object bid )
		{
			decimal a = Decimal.Parse( ask.ToString() );
			decimal b = Decimal.Parse( bid.ToString() );

			return a - b;
		}

		public static decimal GetPriceBaseSpread( FXTradeDesk tradeDesk, string offerID )
		{
			DataTable dt = tradeDesk.TableDataSet.Tables[FXTradeDesk.OFFERS];
			DataRow row = dt.Rows.Find( new object[] { offerID } );

			return Tool.GetPriceBaseSpread( row["Ask"], row["Bid"] );
		}

		public static string GetInstrument( FXTradeDesk tradeDesk, string offerID )
		{
			DataTable dt = tradeDesk.TableDataSet.Tables[FXTradeDesk.OFFERS];
			DataRow row = dt.Rows.Find( new object[] { offerID } );

			return row["Instrument"].ToString();
		}

		public static decimal GetMinStop( object ask, object bid )
		{
			decimal a = Decimal.Parse( ask.ToString() );
			decimal b = Decimal.Parse( bid.ToString() );

			return (decimal)( b - ( a - b ) );
		}

		public static decimal GetMinLimit( object ask, object bid )
		{
			decimal a = Decimal.Parse( ask.ToString() );
			decimal b = Decimal.Parse( bid.ToString() );

			return (decimal)( a + ( a - b ) );
		}
	}


}
