/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.ShutdownListener;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Logger logger = Logger.getLogger(Activator.class.getName());
    public static final String PLUGIN_ID = "com.hisagisoft.eclipse.gadgetholder";
    private static Activator plugin;
    private GadgetManager manager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        logger.fine("GadgetHolder START");
        plugin = this;
        this.manager = GadgetManager.getInstance();
        this.manager.setStateLocation(this.getStateLocation().toOSString());
        this.manager.removeHtmlFile();
        this.manager.loadGadget();
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new ShutdownListener());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("IMG_VIEW_BROWSER", Activator.getImageDescriptor("icons/full/eview16/browser.gif"));
        reg.put("IMG_OBJ_NEW", Activator.getImageDescriptor("icons/full/obj16/new_obj.gif"));
        reg.put("IMG_OBJ_REMOVED", Activator.getImageDescriptor("icons/full/obj16/removed_obj.gif"));
        reg.put("IMG_OBJ_FILE", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        reg.put("IMG_ADD", Activator.getImageDescriptor("icons/full/elcl16/add.gif"));
        reg.put("IMG_REMOVE", Activator.getImageDescriptor("icons/full/elcl16/remove.gif"));
        reg.put("IMG_REMOVE_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/remove.gif"));
        reg.put("IMG_REMOVE_ALL", Activator.getImageDescriptor("icons/full/elcl16/removeall.gif"));
        reg.put("IMG_REMOVE_ALL_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/removeall.gif"));
        reg.put("IMG_ROLLBACK", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
        reg.put("IMG_ROLLBACK_DISABLED", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        reg.put("IMG_SAVE", Activator.getImageDescriptor("icons/full/elcl16/save.gif"));
        reg.put("IMG_SAVE_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/save.gif"));
        reg.put("IMG_EXPORT", Activator.getImageDescriptor("icons/full/elcl16/export.gif"));
        reg.put("IMG_EXPORT_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/export.gif"));
        reg.put("IMG_IMPORT", Activator.getImageDescriptor("icons/full/elcl16/import.gif"));
        reg.put("IMG_REFRESH", Activator.getImageDescriptor("icons/full/elcl16/refresh.gif"));
        reg.put("IMG_REFRESH_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/refresh.gif"));
        reg.put("IMG_FORWARD", Activator.getImageDescriptor("icons/full/elcl16/forward_nav.gif"));
        reg.put("IMG_FORWARD_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/forward_nav.gif"));
        reg.put("IMG_BACKWARD", Activator.getImageDescriptor("icons/full/elcl16/backward_nav.gif"));
        reg.put("IMG_BACKWARD_DISABLED", Activator.getImageDescriptor("icons/full/dlcl16/backward_nav.gif"));
        reg.put("IMG_COPY", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        reg.put("IMG_COPY_DISABLED", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void stop(BundleContext context) throws Exception {
        logger.fine("GadgetHolder STOP");
        this.manager.removeHtmlFile();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IWorkbenchPart getActivePart() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }
}

