/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;

public class FileDropListener
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(FileDropListener.class.getName());
    private GadgetView view;
    private GadgetManager manager;

    public FileDropListener(GadgetView view) {
        this.view = view;
        this.manager = GadgetManager.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 1;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        try {
            FileTransfer transfer = FileTransfer.getInstance();
            if (!transfer.isSupportedType(event.currentDataType)) {
                logger.fine("not supported type");
                return;
            }
            String[] absolutePaths = (String[])event.data;
            GadgetList newGadgets = null;
            String[] stringArray = absolutePaths;
            int n = absolutePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String absolutePath = stringArray[n2];
                logger.fine("drop file = " + absolutePath);
                newGadgets = this.manager.importGadget(new File(absolutePath));
                for (Gadget g : newGadgets) {
                    this.view.addBrowser(g);
                }
                ++n2;
            }
            this.view.setEnabledActions();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

