/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Messages;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;

public class ResizeListener
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static Logger logger = Logger.getLogger(ResizeListener.class.getName());
    private Point mouseDownPoint;
    private Point initSize;
    private Point initLocation;
    private Point newLocation;
    private Control target;
    private ToolTip toolTip;

    public ResizeListener() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.toolTip = new ToolTip(shell, 4096);
        this.toolTip.setMessage(Messages.getString("tooltip.palette.message"));
        this.toolTip.setAutoHide(true);
    }

    public void mouseDoubleClick(MouseEvent e) {
        Control control;
        Composite composite;
        Control[] controlArray;
        if (e.widget instanceof Control && (controlArray = (composite = (Composite)e.widget).getChildren()).length != 0 && (control = controlArray[0]) instanceof Browser) {
            logger.fine("refresh browser");
            ((Browser)control).refresh();
        }
    }

    public void mouseDown(MouseEvent e) {
        try {
            if (e.widget instanceof Control) {
                this.mouseDownPoint = new Point(e.x, e.y);
                this.target = (Control)e.widget;
                this.target.setCursor(new Cursor(null, 21));
                this.initSize = this.target.getSize();
                this.initLocation = this.target.getLocation();
                this.newLocation = this.target.getLocation();
                this.target.moveAbove(null);
            }
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
    }

    public void mouseUp(MouseEvent e) {
        try {
            if (this.initLocation == null || this.newLocation == null) {
                return;
            }
            if (!this.initLocation.equals((Object)this.newLocation)) {
                this.target.setLocation(this.newLocation);
                Composite base = this.target.getParent();
                ScrolledComposite scrollComposite = (ScrolledComposite)base.getParent();
                scrollComposite.setMinSize(base.computeSize(-1, -1));
            }
            this.target.setCursor(null);
            this.mouseDownPoint = null;
            this.target = null;
            this.initSize = null;
            this.initLocation = null;
            this.newLocation = null;
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (e.widget != this.target) {
            return;
        }
        int distX = this.mouseDownPoint.x - e.x;
        int distY = this.mouseDownPoint.y - e.y;
        if (e.stateMask == 0x200000) {
            this.target.setSize(new Point(this.initSize.x - distX, this.initSize.y - distY));
        } else if (e.stateMask == 524288) {
            this.newLocation.x = this.initLocation.x - distX;
            this.newLocation.y = this.initLocation.y - distY;
        }
    }

    public void mouseEnter(MouseEvent e) {
        if (e.widget instanceof Control) {
            ((Control)e.widget).setCursor(new Cursor(null, 21));
        }
    }

    public void mouseExit(MouseEvent e) {
        ((Control)e.widget).setCursor(null);
    }

    public void mouseHover(MouseEvent e) {
        this.toolTip.setVisible(true);
    }
}

