/*
 * Decompiled with CFR 0.152.
 */
package jp.getset.gae.bigtable;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.getset.gae.GaeUnsupportedException;
import jp.getset.gae.bigtable.PreparedOption;
import jp.getset.gae.bigtable.PreparedOptionBuffer;
import jp.getset.gae.bigtable.ResultSet;
import jp.getset.gae.bigtable.option.Preparable;
import jp.getset.gae.bigtable.option.PreparedCondition;
import jp.getset.gae.bigtable.option.PreparedLimit;
import jp.getset.gae.bigtable.option.PreparedProperty;

public abstract class Statement
implements PreparedStatement,
Serializable {
    private static final long serialVersionUID = -857745662683609160L;
    protected String kind = null;
    protected Mode mode = null;
    private DatastoreService datastoreService = null;
    private PreparedOption preparedOption = new PreparedOption();
    private Transaction transaction = null;

    public Statement() {
    }

    public Statement(Mode mode) {
        this.mode = mode;
    }

    public Statement(Mode mode, String kind) {
        this.mode = mode;
        this.kind = kind;
    }

    private void clear() {
        this.kind = null;
        this.mode = null;
        this.datastoreService = null;
        this.preparedOption = new PreparedOption();
    }

    public void appendLimit(int i) {
        this.preparedOption.add(new PreparedLimit(i));
    }

    public void setPreparedOptionValue(int i, Object obj) {
        try {
            ((Preparable)this.preparedOption.get(i - 1)).setValue(obj);
        }
        catch (IndexOutOfBoundsException e) {
            throw new GaeUnsupportedException("\u4e0d\u660e\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u8a2d\u5b9a\u3067\u3059\u3002");
        }
    }

    private ResultSet executeSelectForBigTable() throws SQLException {
        Query query = new Query(this.kind);
        List<PreparedCondition> preparedConditions = this.preparedOption.getPreparedConditions();
        for (PreparedCondition preparedCondition : preparedConditions) {
            Object val = preparedCondition.getValue();
            Query.FilterOperator operator = preparedCondition.getOperator();
            if (operator.equals((Object)Query.FilterOperator.IN)) {
                List list = (List)val;
                if (list.size() > 0) {
                    query.addFilter(preparedCondition.getName(), operator, (Object)list);
                    continue;
                }
                return new ResultSet();
            }
            query.addFilter(preparedCondition.getName(), operator, (Object)val.toString());
        }
        return new ResultSet(this.getDatastoreService().prepare(query).asIterable(), this.preparedOption, this.kind);
    }

    public int executeUpdateForBigTable() throws SQLException {
        int res = 0;
        ResultSet gaeResultSet = this.executeSelectForBigTable();
        try {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            List<PreparedProperty> preparedProperties = this.preparedOption.getPreparedProperties();
            while (gaeResultSet.next()) {
                Entity entity = gaeResultSet.getEntity();
                for (PreparedProperty preparedProperty : preparedProperties) {
                    entity.setProperty(preparedProperty.getName(), (Object)preparedProperty.getValue().toString());
                }
                entities.add(entity);
                ++res;
            }
            if (this.transaction == null) {
                this.getDatastoreService().put(entities);
            } else {
                this.getDatastoreService().put(this.transaction, entities);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public int executeDeleteForBigTable() throws SQLException {
        int res = 0;
        ResultSet gaeResultSet = this.executeSelectForBigTable();
        try {
            ArrayList<Key> keys = new ArrayList<Key>();
            while (gaeResultSet.next()) {
                Entity entity = gaeResultSet.getEntity();
                keys.add(entity.getKey());
                ++res;
            }
            if (this.transaction == null) {
                this.getDatastoreService().delete(keys);
            } else {
                this.getDatastoreService().delete(this.transaction, keys);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public int executeInsertForBigTable() throws SQLException {
        Entity entity = new Entity(this.kind);
        List<PreparedProperty> preparedProperties = this.preparedOption.getPreparedProperties();
        for (PreparedProperty preparedProperty : preparedProperties) {
            entity.setProperty(preparedProperty.getName(), (Object)preparedProperty.getValue().toString());
        }
        if (this.transaction == null) {
            this.getDatastoreService().put(entity);
        } else {
            this.getDatastoreService().put(this.transaction, entity);
        }
        return 1;
    }

    private DatastoreService getDatastoreService() {
        if (this.datastoreService == null) {
            this.datastoreService = DatastoreServiceFactory.getDatastoreService();
        }
        return this.datastoreService;
    }

    public void setPreparedOptionBuffer(PreparedOptionBuffer pob) {
        this.preparedOption = pob.getOption();
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean execute() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet res = null;
        switch (this.mode) {
            case SELECT: {
                res = this.executeSelectForBigTable();
                break;
            }
            default: {
                throw new GaeUnsupportedException();
            }
        }
        return res;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int res = 0;
        switch (this.mode) {
            case INSERT: {
                res = this.executeInsertForBigTable();
                break;
            }
            case UPDATE: {
                res = this.executeUpdateForBigTable();
                break;
            }
            case DELETE: {
                res = this.executeDeleteForBigTable();
                break;
            }
            default: {
                throw new GaeUnsupportedException();
            }
        }
        return res;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setArray(int i, Array array) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBlob(int i, InputStream inputstream) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBlob(int i, InputStream inputstream, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBoolean(int i, boolean flag) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setByte(int i, byte byte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setBytes(int i, byte[] abyte0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setCharacterStream(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setClob(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        this.setPreparedOptionValue(i, date);
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        this.setPreparedOptionValue(i, d);
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        this.setPreparedOptionValue(i, Float.valueOf(f));
    }

    @Override
    public void setInt(int i, int j) throws SQLException {
        this.setPreparedOptionValue(i, j);
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNCharacterStream(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNClob(int i, NClob nclob) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNClob(int i, Reader reader) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNClob(int i, Reader reader, long l) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNString(int i, String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNull(int i, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setNull(int i, int j, String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setObject(int i, Object obj) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setObject(int i, Object obj, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setObject(int i, Object obj, int j, int k) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setRowId(int i, RowId rowid) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setShort(int i, short word0) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        this.setPreparedOptionValue(i, s);
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.setPreparedOptionValue(i, timestamp);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setUnicodeStream(int i, InputStream inputstream, int j) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void addBatch(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void close() throws SQLException {
        this.clear();
    }

    @Override
    public boolean execute(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean execute(String s, int[] ai) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean execute(String s, String[] as) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int executeUpdate(String s, int[] ai) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int executeUpdate(String s, String[] as) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean flag) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setPoolable(boolean flag) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new GaeUnsupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new GaeUnsupportedException();
    }

    public static enum Mode {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

