/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.TableStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleStyle
extends ODNode {
    private static final Map<String, Class<? extends StyleStyle>> family2Class = new HashMap<String, Class<? extends StyleStyle>>();
    private static final Map<Class<? extends StyleStyle>, String> class2Family = new HashMap<Class<? extends StyleStyle>, String>();
    private final String name = this.getElement().getAttributeValue("name", this.getSTYLE());
    private final String family = this.getElement().getAttributeValue("family", this.getSTYLE());
    private final NS ns;

    private static void register(Class<? extends StyleStyle> clazz) {
        String string;
        try {
            clazz.getDeclaredConstructor(Element.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("no Element ctor for " + clazz);
        }
        try {
            string = (String)clazz.getDeclaredField("STYLE_FAMILY").get(null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("cannot access the family", exception);
        }
        family2Class.put(string, clazz);
        class2Family.put(clazz, string);
    }

    public static String getFamily(Class<?> clazz) {
        if (class2Family.containsKey(clazz)) {
            return class2Family.get(clazz);
        }
        throw new IllegalArgumentException("unregistered " + clazz);
    }

    public static StyleStyle warp(Element element) {
        StyleStyle styleStyle = new StyleStyle(element);
        if (family2Class.containsKey(styleStyle.getFamily())) {
            Class<? extends StyleStyle> clazz = family2Class.get(styleStyle.getFamily());
            return StyleStyle.create(clazz, element);
        }
        return styleStyle;
    }

    private static <S extends StyleStyle> S create(Class<S> clazz, Element element) {
        try {
            return (S)((StyleStyle)clazz.getDeclaredConstructor(Element.class).newInstance(element));
        }
        catch (Exception exception) {
            throw new IllegalStateException("unable to create " + clazz, exception);
        }
    }

    public static <S extends StyleStyle> S create(ODDocument oDDocument, Class<S> clazz, String string) {
        Namespace namespace = oDDocument.getNS().getSTYLE();
        Element element = new Element("style", namespace);
        String string2 = StyleStyle.getFamily(clazz);
        element.setAttribute("family", string2, oDDocument.getNS().getSTYLE());
        element.setAttribute("name", oDDocument.getPackage().getContent().findUnusedName(string2, string), oDDocument.getNS().getSTYLE());
        return StyleStyle.create(clazz, element);
    }

    public static <S extends StyleStyle> S findStyle(ODPackage oDPackage, Class<S> clazz, String string) {
        Element element = oDPackage.getStyle(StyleStyle.getFamily(clazz), string);
        return element == null ? null : (S)StyleStyle.create(clazz, element);
    }

    public StyleStyle(Element element) {
        super(element);
        String string = class2Family.get(this.getClass());
        if (string != null && !string.equals(this.getFamily())) {
            throw new IllegalArgumentException("expected " + string + " but got " + this.getFamily() + " for " + element);
        }
        this.ns = NS.getParent(this.getSTYLE());
    }

    protected final Namespace getSTYLE() {
        return this.getElement().getNamespace("style");
    }

    public final String getName() {
        return this.name;
    }

    public final String getFamily() {
        return this.family;
    }

    public final Element getFormattingProperties() {
        String string = this.ns.getVersion().equals("OpenDocument") ? this.getFamily() + "-properties" : "properties";
        Element element = this.getElement().getChild(string, this.getSTYLE());
        if (element == null) {
            element = new Element(string, this.getSTYLE());
            this.getElement().addContent(element);
        }
        return element;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StyleStyle)) {
            return false;
        }
        StyleStyle styleStyle = (StyleStyle)object;
        return this.getName().equals(styleStyle.getName()) && this.getFamily().equals(styleStyle.getFamily());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getFamily().hashCode();
    }

    static {
        StyleStyle.register(CellStyle.class);
        StyleStyle.register(RowStyle.class);
        StyleStyle.register(ColumnStyle.class);
        StyleStyle.register(TableStyle.class);
    }
}

