/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.vo.MosPMenuVo;

/**
 * @author yoshida
 *
 */
public class MosPMenuAction extends MosPAction {
	
	// R}h萔
	private static final String	CMD_SHOW	= MospConst.CMD_MENU;
	

	/**
	 * RXgN^
	 */
	public MosPMenuAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new MosPMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
	}
	
	@Override
	protected void show() throws Exception {
		MosPMenuVo vo = (MosPMenuVo)getVo();
		String component = "";
		String title = "";
		// R}h̏
		if (cmd.equals(CMD_SHOW) || cmd.equals(vo.CMD_MENU_INPUT)) {
			component = part().menu().getEmployeeComponent();
			title = CommonConst.TTL_MENU_INPUT;
		} else if (cmd.equals(vo.CMD_MENU_MAMAGE)) {
			component = part().menu().getManagerComponent();
			title = CommonConst.TTL_MENU_MANAGE;
		} else if (cmd.equals(vo.CMD_MENU_PAYROLL)) {
			component = part().menu().getPayrollComponent();
			title = CommonConst.TTL_MENU_PAYROLL;
		} else if (cmd.equals(vo.CMD_MENU_HUMAN)) {
			component = part().menu().getHumanComponent();
			title = CommonConst.TTL_MENU_HUMAN;
		} else if (cmd.equals(vo.CMD_MENU_SYSTEM2)) {
			component = MosPMenuPart.convAryToComponent(MosPMenuConst.getCmdSystemArray());
			// CSS̐ݒ
			vo.setCommonCss(CommonConst.CSS_ADMIN);
			vo.setMode(MosPMenuVo.MODE_ADMIN);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		if (StringUtil.isNotNull(title)) {
			vo.setTitle(title);
		}
		user.setCommonCss(vo.getCommonCss());
		vo.setFields(component, StringUtil.combineArray(MosPMenuPart.getAllCmdArrayList()));
	}
	
}
