/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * ÕtH[}bg`B<br><br>
 * MosPt[[NW̃OtH[}bg`B<br>
 * Zp[^ύX邱ƂłB<br>
 */
public final class LogFormatClass extends Formatter {
	
	private String separator;
	
	/**
	 * RXgN^B<br>
	 * Ő؂蕶ݒ肷B
	 * @param separator OZp[^
	 */
	public LogFormatClass(String separator) {
		this.separator = separator != null ? separator : "|";
	}
	
	/**
	 * ÕtH[}bg`B<br>
	 * tAxAbZ[WZp[^ŋ؂B<br>
	 */
	@Override
	public String format(LogRecord rec) {
		SimpleDateFormat sdf = new SimpleDateFormat(
				MospConst.TIME_FORMAT + separator +
				MospConst.DATE_FORMAT + separator + MospConst.DAY_FORMAT
		);
		StringBuffer sb = new StringBuffer();
		sb.append(sdf.format(new Date()));
		sb.append(separator);
		sb.append(rec.getLevel());
		sb.append(separator);
		sb.append(formatMessage(rec));
		sb.append(MospConst.LINE_SEPARATOR);
		return sb.toString();
	}
	
	/**
	 * tH[}bgꂽR[h̃Zbg̃wb_ԂB<br>
	 */
	@Override
	public String getHead(Handler h) {
		return "";
	}
	
	/**
	 * tH[}bgꂽR[hZbg̖̕ԂB<br>
	 */
	@Override
	public String getTail(Handler h) {
		return "";
	}

}
