/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

/**
 * MosPt[[Nŗp萔錾B<br><br>
 */
public final class MospConst {
	
	// mosp.jaro[W
	/**
	 *  mosp.jar̃o[WB<br>
	 */
	public static final String MOSP_JAR_VERSION = "1.3.0";
	
	// p[^[(request.getParameter)
	/**
	 *  Action𔻒fB<br>
	 */
	public static final String PRM_CMD           = "cmd";
	
	/**
	 *  UInL[1B<br>
	 */
	public static final String PRM_KEY1          = "key1";
	
	/**
	 *  UInL[2B<br>
	 */
	public static final String PRM_KEY2          = "key2";
	
	/**
	 *  UInL[ځB<br>
	 */
	public static final String PRM_KEY           = "key";
	
	/**
	 *  UInL[ځB<br>
	 */
	public static final String PRM_PROC_SEQ      = "procSeq";
	
	/**
	 *  X|X^CvB<br>
	 */
	public static final String PRM_RESPONSE_TYPE = "resType";
	
	// p[^[(request or session.getAttribute)
	/**
	 *  MosP(V[PX)B<br>
	 */
	static final String ATT_PROC_SEQ = "procSeq";
	
	/**
	 *  MosP(T[ubgReLXg)B<br>
	 */
	static final String ATT_CTX      = "ctx";
	
	/**
	 *  MosP(controller.properties)B<br>
	 */
	static final String ATT_CTL      = "ctl";
	
	/**
	 *  MosP(mosp.properties)B<br>
	 */
	static final String ATT_CFG      = "cfg";
	
	/**
	 *  MosP(naming.properties)B<br>
	 */
	static final String ATT_NAM      = "nam";
	
	/**
	 *  MosP(message.properties)B<br>
	 */
	static final String ATT_MSG      = "msg";

	/**
	 *  MosP(R}h)B<br>
	 */
	public static final String ATT_CMD            = "cmd";

	/**
	 *  MosP(̃R}h)B<br>
	 */
	public static final String ATT_NEXTCMD        = "nextCmd";

	/**
	 *  MosP(tH[h)B<br>
	 */
	public static final String ATT_FORWARD        = "forward";

	/**
	 *  MosP(URL)B<br>
	 */
	public static final String ATT_URL            = "url";

	/**
	 *  MosP(ASP[U[)B<br>
	 */
	public static final String ATT_ASPUSER        = "aspUser";
	
	/**
	 *  MosP([U[)B<br>
	 */
	public static final String ATT_USER           = "user";

	/**
	 *  MosP(VO)B<br>
	 */
	public static final String ATT_VO             = "vo";

	/**
	 *  MosP(bZ[W)B<br>
	 */
	public static final String ATT_MESSAGE        = "message";

	/**
	 *  MosP(G[bZ[W)B<br>
	 */
	public static final String ATT_ERR_MESSAGE    = "errMessage";

	/**
	 *  MosP(VO)B<br>
	 */
	public static final String ATT_FORMER_VO      = "formerVo";

	/**
	 *  MosP(ێVO)B<br>
	 */
	public static final String ATT_STORE_VO       = "storeVo";
	
	/**
	 *  MosP(DTO)B<br>
	 */
	public static final String ATT_DTO            = "dto";
	
	/**
	 *  MosP(Xg)B<br>
	 */
	public static final String ATT_LIST           = "list";

	/**
	 *  MosP(X|X^Cv)B<br>
	 */
	public static final String ATT_RESPONSE_TYPE = "resType";

	/**
	 *  MosP(X|X^Cv)B<br>
	 */
	@Deprecated
	public static final String ATT_RESPONASE_TYPE = "resType";
	
	/**
	 *  MosP(t@CIuWFNg)B<br>
	 */
	public static final String ATT_FILE_OBJECT    = "fileObject";

	/**
	 *  MosP(t@C)B<br>
	 */
	public static final String ATT_FILE_NAME      = "fileName";

	/**
	 *  MosP(}`p[gf[^̃Xg)B<br>
	 */
	public static final String ATT_MULTIPART_LIST = "multipartList";
	
	/**
	 *  MosP(MosP@胆[eBeB[o[W)B<br>
	 */
	public static final String ATT_LEGAL_VER      = "legalVer";
	
	/**
	 *  MosP(MosPSE[eBeB[o[W)B<br>
	 */
	public static final String ATT_SE_VER         = "seVer";
	
	/**
	 *  MosP(MosPvZ[eBeB[o[W)B<br>
	 */
	public static final String ATT_EXPRESS_VER    = "expressVer";
	
	/**
	 *  MosP(PoiCu[L)B<br>
	 */
	public static final String ATT_POI_EXIST      = "poiExist";
	
	/**
	 *  MosP(jOpenDocumentCu[L)B<br>
	 */
	public static final String ATT_JOD_EXIST      = "jodExist";
	
	/**
	 *  MosP(JasperReportCu[L)B<br>
	 */
	public static final String ATT_JASPER_EXIST   = "jasperExist";
	
	/**
	 *  MosP(FileUploadCu[L)B<br>
	 */
	public static final String ATT_UPLOAD_EXIST   = "uploadExist";
	
	// ݒt@CpX
	/**
	 *  ݒt@C[g̃pXB<br>
	 */
	public static final String PATH_INF = "/WEB-INF/";

	/**
	 *  ݒt@CB<br>
	 */
	public static final String FILE_HOT = "hot.properties";
	
	/**
	 *  MospvpeBt@CB<br>
	 */
	public static final String FILE_CFG = "mosp.properties";
	
	/**
	 *  MospǉvpeBt@CB<br>
	 */
	public static final String FILE_EXT = "extra.properties";
	
	/**
	 *  Rg[[t@CB<br>
	 */
	public static final String FILE_CTL = "controller.properties";
	
	/**
	 *  t@CB<br>
	 */
	public static final String FILE_NAM = "naming.properties";
	
	/**
	 *  bZ[Wݒt@CB<br>
	 */
	public static final String FILE_MSG = "message.properties";
	
	// CSSyJSt@C
	/**
	 *  ʃt@C̃pX(CSS)B<br>
	 */
	public static final String CSS_DEFAULT = "/pub/common/css/mosp.css";

	/**
	 *  ʃt@C̃pX(javascript)B<br>
	 */
	public static final String JS_COMMON   = "/pub/common/js/mosp.js";

	/**
	 *  ʃt@C̃pX(message\pjavascript)B<br>
	 */
	public static final String JS_MESSAGE  = "/pub/common/js/message.js";
	
	// vpeB(public)
	/**
	 *  ݒt@C̃vpeB(AvP[V[g̐΃pX)B<br>
	 */
	public static final String PPT_APP_DOCBASE   = "app.docbase";

	/**
	 *  ݒt@C̃vpeB(ASPtO)B<br>
	 */
	public static final String PPT_ASP_FLAG      = "asp.flag";

	/**
	 *  ݒt@C̃vpeB(ASP[U[ID)B<br>
	 */
	public static final String PPT_ASP_ASPUSER   = "asp.aspuser";

	/**
	 *  ݒt@C̃vpeB(ASP[U[)B<br>
	 */
	public static final String PPT_ASP_ASPNAME   = "asp.aspname";

	/**
	 *  ݒt@C̃vpeB(DBhCo)B<br>
	 */
	public static final String PPT_ASP_DBDRIVER  = "asp.dbdriver";

	/**
	 *  ݒt@C̃vpeB(DBURL)B<br>
	 */
	public static final String PPT_ASP_DBURL     = "asp.dburl";

	/**
	 *  ݒt@C̃vpeB(DB[U[)B<br>
	 */
	public static final String PPT_ASP_DBUSER    = "asp.dbuser";
	
	/**
	 *  ݒt@C̃vpeB(DBpX)B<br>
	 */
	public static final String PPT_ASP_DBPASS    = "asp.dbpass";

	/**
	 *  ݒt@C̃vpeB(DataSource)B<br>
	 */
	public static final String PPT_ASP_DSOURCE   = "asp.dsource";
	
	/**
	 *  ݒt@C̃vpeB(p\pbP[W)B<br>
	 */
	public static final String PPT_APP_AVAILABLE = "app.available";

	/**
	 *  ݒt@C̃vpeB(pX[hL)B<br>
	 */
	public static final String PPT_ACC_VALIDITY  = "acc.validity";

	/**
	 *  ݒt@C̃vpeB(OCső)B<br>
	 */
	public static final String PPT_ACC_ATTEMPT   = "acc.attempt";

	/**
	 *  ݒt@C̃vpeB(AJEgbN(b))B<br>
	 */
	public static final String PPT_ACC_INTERVAL  = "acc.interval";

	/**
	 *  ݒt@C̃vpeB(Xg\)B<br>
	 */
	public static final String PPT_APP_LIST      = "app.list";

	/**
	 *  ݒt@C̃vpeB(ZbVێ(b))B<br>
	 */
	public static final String PPT_APP_INTERVAL  = "app.interval";
	
	/**
	 *  ݒt@C̃vpeB(St@CpX)B<br>
	 */
	public static final String PPT_APP_LOGO      = "app.logo";

	
	// vpeB(jp.mosp.common)

	/**
	 *  ݒt@C̃vpeB(vpeBt@CǍݒ(0FANZXA1:T[ubgN))B<br>
	 */
	static final String PPT_APP_HOT       = "app.hot";

	/**
	 *  ݒt@C̃vpeB(AvP[V^Cg)B<br>
	 */
	static final String PPT_APP_TITLE     = "app.title";
	
	/**
	 *  ݒt@C̃vpeB(AvP[Vo[W)B<br>
	 */
	static final String PPT_APP_VERSION   = "app.version";
	
	/**
	 *  ݒt@C̃vpeB(AvP[V쌠)B<br>
	 */
	static final String PPT_APP_COPY      = "app.copy";

	/**
	 *  ݒt@C̃vpeB(Ot@Cp^[)B<br>
	 */
	static final String PPT_LOG_PATTERN   = "log.pattern";

	/**
	 *  ݒt@C̃vpeB(Ot@C[e[V)B<br>
	 */
	static final String PPT_LOG_COUNT     = "log.count";

	/**
	 *  ݒt@C̃vpeB(Ot@CTCY)B<br>
	 */
	static final String PPT_LOG_SIZE      = "log.size";

	/**
	 *  ݒt@C̃vpeB(Oo̓x)B<br>
	 */
	static final String PPT_LOG_LEVEL     = "log.level";

	/**
	 *  ݒt@C̃vpeB(O)B<br>
	 */
	static final String PPT_LOG_NAME      = "log.name";

	/**
	 *  ݒt@C̃vpeB(Oؕ)B<br>
	 */
	static final String PPT_LOG_SEPARATOR = "log.separator";
	

	// AvP[V
	/**
	 *  ASPp\AvP[Vݒ蕶(ʕ)B<br>
	 */
	public static final String APP_COMMON  = "common";

	/**
	 *  ASPp\AvP[Vݒ蕶(l^)B<br>
	 */
	public static final String APP_PAYROLL = "payroll";

	/**
	 *  ASPp\AvP[Vݒ蕶(oZ)B<br>
	 */
	public static final String APP_EXPENSE = "expense";

	/**
	 *  ASPp\AvP[Vݒ蕶(̔Ǘ)B<br>
	 */
	public static final String APP_SALES   = "sales";

	/**
	 *  ASPp\AvP[Vݒ蕶(\1)B<br>
	 */
	public static final String APP_EXT1    = "lease";

	/**
	 *  ASPp\AvP[Vݒ蕶(\2)B<br>
	 */
	public static final String APP_EXT2    = "ext2";

	/**
	 *  ASPp\AvP[Vݒ蕶(\3)B<br>
	 */
	public static final String APP_EXT3    = "ext3";

	/**
	 *  ASPp\AvP[Vݒ蕶(\4)B<br>
	 */
	public static final String APP_EXT4    = "ext4";

	/**
	 *  ASPp\AvP[Vݒ蕶(\5)B<br>
	 */
	public static final String APP_EXT5    = "ext5";
	
	// URL
	/**
	 *  indexʂ̃pXB<br>
	 */
	public static final String URL_INDEX = "/pub/common/index.html";
	
	/**
	 *  G[ʂ̃pXB<br>
	 */
	public static final String URL_ERROR = "/pub/common/error.html";

	/**
	 * xmlo͗pjsp̃pXB<br>
	 */
	public static final String URL_XML   = "/jsp/common/xml.jsp";

	/**
	 * OCʂ̃pXB<br>
	 */
	public static final String URL_LOGIN = "/jsp/common/login.jsp";

	/**
	 *  j[ʂ̃pXB<br>
	 */
	public static final String URL_MENU  = "/jsp/common/menu.jsp";

	/**
	 *  T[ubg̃pXB<br>
	 */
	public static final String URL_SRV   = "/srv/";
	
	/**
	 *  JfBNg̃pXB<br>
	 */
	public static final String URL_PUB   = "../pub/";
	
	// O^Cv
	/**
	 *  O^Cv(ANZX)B<br>
	 */
	public static final String LOG_ACCESS  = "ANZX";

	/**
	 *  O^Cv(ANVs)B<br>
	 */
	public static final String LOG_ACTION  = "ANV";

	/**
	 *  O^Cv(XVNGs)B<br>
	 */
	public static final String LOG_EXECUTE = "XVNG[s";

	/**
	 *  O^Cv(͒lG[)B<br>
	 */
	public static final String LOG_VALID   = "͒lG[";

	/**
	 *  O^Cv(MosPInfo)B<br>
	 */
	public static final String LOG_MOSPINF = "MosP";

	/**
	 *  O^Cv(ZLeBx)B<br>
	 */
	public static final String LOG_SECURE  = "ZLeBx";

	/**
	 *  O^Cv(t[[NG[)B<br>
	 */
	public static final String LOG_MOSPERR = "MosPG[";

	/**
	 *  O^Cv(sG[)B<br>
	 */
	public static final String LOG_ERROR   = "sG[";
	
	// MosPOR[h
	/**
	 *  p[^s̗OR[hB<br>
	 */
	public static final int EX_PARAMS_INVALID  = 1001;

	/**
	 *  Fؕs̗OR[hB<br>
	 */
	public static final int EX_AUTH_FAILED     = 1002;

	/**
	 *  AJEgbN̗OR[hB<br>
	 */
	public static final int EX_ACCOUNT_LOCK    = 1003;

	/**
	 *  F؍폜̗OR[hB<br>
	 */
	public static final int EX_AUTH_DELETED    = 1004;

	/**
	 *  F؏񂪑݂Ȃꍇ̗OR[hB<br>
	 */
	public static final int EX_AUTH_NOT_EXIST  = 1005;

	/**
	 *  R[h񂪑݂Ȃꍇ̗OR[hB<br>
	 */
	public static final int EX_NO_CODE         = 1006;

	/**
	 *  ZbV^CAEg̗OR[hB<br>
	 */
	public static final int EX_SESSION_TIMEOUT = 1011;

	/**
	 *  ZbVs̗OR[hB<br>
	 */
	public static final int EX_SESSION_INVALID = 1012;
	
	/**
	 * V[PXs̗OR[hB<br>
	 */
	public static final int EX_PROCSEQ_INVALID = 1013;

	/**
	 *  tB[hs̗OR[hB<br>
	 */
	public static final int EX_INSERT_FAILED   = 1021;

	/**
	 *  XVs̗OR[hB<br>
	 */
	public static final int EX_UPDATE_FAILED   = 1022;

	/**
	 *  d̗OR[hB<br>
	 */
	public static final int EX_DUPLICATE       = 1023;

	/**
	 *  r䎞̗OR[hB<br>
	 */
	public static final int EX_EXCLUSIVE       = 1024;

	/**
	 *  tB[h폜̗OR[hB<br>
	 */
	public static final int EX_DELETE_FAILED   = 1025;
	
	/**
	 * V[gs̗OR[hB
	 */
	public static final int EX_NO_SHEET        = 1040;

	/**
	 *  NGXg^Cvs̗OR[hB<br>
	 */
	public static final int EX_REQUEST_TYPE    = 3001;

	/**
	 * RDBMSs̗OR[hB<br>
	 */
	public static final int EX_UNKNOWN_RDBMS   = 3003;
	
	/**
	 * NGXgRecs̗OR[hB<br>
	 */
	public static final int EX_CONTENT_LENGTH  = 4001;

	/**
	 * R}hNull̗OR[hB<br>
	 */
	public static final int EX_CMD_NULL        = 4002;

	/**
	 * R}h̃tH[}bgs̗OR[hB<br>
	 */
	public static final int EX_CMD_FORMAT      = 4003;

	/**
	 * V[PXNull̗OR[hB<br>
	 */
	public static final int EX_PROCSEQ_NULL    = 4004;

	/**
	 * F؏s̗OR[hB<br>
	 */
	public static final int EX_AUTHORITY       = 4006;

	/**
	 * 񂪑݂Ȃ̗OR[hB<br>
	 */
	public static final int EX_NO_DATA         = 4007;

	/**
	 * \[gL[s̗OR[hB<br>
	 */
	public static final int EX_SORTKEY_INVALID = 4008;

	/**
	 * X|X^CvNull̗OR[hB<br>
	 */
	public static final int EX_RESTYPE_NULL    = 4009;

	/**
	 * X|X^Cvs̗OR[hB<br>
	 */
	public static final int EX_RESTYPE_INVALID = 4010;

	/**
	 * R}hs̗OR[hB<br>
	 */
	public static final int EX_CMD_INVALID     = 5001;

	/**
	 * Rg[s̗OR[hB<br>
	 */
	public static final int EX_CTL_INVALID     = 5002;

	/**
	 * ASPݒs̗OR[hB<br>
	 */
	public static final int EX_ASP_PROPERTIES  = 5003;

	/**
	 * APPݒs̗OR[hB<br>
	 */
	public static final int EX_APP_PROPERTIES  = 5004;

	/**
	 * \bZ[W݂Ȃꍇ̗OR[hB<br>
	 */
	public static final int EX_NO_MESSAGE      = 5005;

	/**
	 * tH[hJEhs̗OR[hB<br>
	 */
	public static final int EX_COUNT_FORWARD   = 5006;

	/**
	 * [U[s̗OR[hB<br>
	 */
	public static final int EX_CM_USER_ILLEGAL = 5007;

	/**
	 * y[Ws̗OR[hB<br>
	 */
	public static final int EX_PAGE_FAILED     = 5008;

	/**
	 * ts̗OR[hB<br>
	 */
	public static final int EX_DATE_INVALID    = 5009;

	/**
	 * ^CG[̗OR[hB<br>
	 */
	public static final int EX_RUNTIME_ERR     = 9001;
	
	/**
	 * CX^XmFG[̗OR[hB<br>
	 */
	public static final int EX_WRONG_INSTANCE  = 9002;
	
	// OpbZ[W
	/**
	 * OC̃bZ[WB<br>
	 */
	public static final String LOG_MSG_LOGIN  = "OC";

	/**
	 * OAEg̃bZ[WB<br>
	 */
	public static final String LOG_MSG_LOGOUT = "OAEg";

	/**
	 * MosPt[[No[W\B<br>
	 */
	public static final String LOG_MSG_MOSP_VERSION = "MosPt[[No[W-";
	
	/**
	 * MosP@胆[eBeB[o[W\B<br>
	 */
	public static final String LOG_MSG_LEGAL_VERSION = "MosP@胆[eBeB[o[W-";
	
	/**
	 * MosPSE[eBeB[o[W\B<br>
	 */
	public static final String LOG_MSG_SE_VERSION    = "MosPSE[eBeB[o[W-";
	
	/**
	 * MosPvZ[eBeB[o[W\B<br>
	 */
	public static final String LOG_MSG_EXPRESS_VERSION = "MosPvZ[eBeB[o[W-";
	
	/**
	 * tH[h斢ݒ胁bZ[WB<br>
	 */
	public static final String LOG_MSG_NO_URL = "tH[h悪ݒ肳Ă܂B";

	/**
	 * ObZ[W擾G[bZ[WB<br>
	 */
	public static final String LOG_MSG_MESSAGE_ERROR = "ObZ[W擾ł܂łB";

	/**
	 * ZbVbZ[WB<br>
	 */
	public static final String LOG_MSG_EXCLUDE = "ZbV𖳌ɂ܂B";

	/**
	 * ̓p[^sbZ[WB<br>
	 */
	public static final String LOG_MSG_1001 = "̓p[^słB";

	/**
	 * pX[hsbZ[WB<br>
	 */
	public static final String LOG_MSG_1002 = "pX[hɌ肪܂B";

	/**
	 * AJEgbNbZ[WB<br>
	 */
	public static final String LOG_MSG_1003 = "bNĂAJEgł̃OCv󂯂܂B";

	/**
	 * AJEg폜bZ[WB<br>
	 */
	public static final String LOG_MSG_1004 = "폜Ă郆[U[ɂ郍OCv󂯂܂B";

	/**
	 * AJEg݂Ȃꍇ̃G[bZ[WB<br>
	 */
	public static final String LOG_MSG_1005 = "݂Ȃ[U[ɂ郍OCv󂯂܂B";

	/**
	 * XV̑݊mFG[bZ[WB<br>
	 */
	public static final String LOG_MSG_1006 = "݂ȂR[hɂo^v󂯂܂B";

	/**
	 * ZbVؒf̃bZ[WB<br>
	 */
	public static final String LOG_MSG_1011 = "ZbVؒf܂B";

	/**
	 * ZbVs̃bZ[WB<br>
	 */
	public static final String LOG_MSG_1012 = "ZbVɕKvȏ񂪊܂܂Ă܂B";

	/**
	 * V[PXsNGXg擾bZ[WB<br>
	 */
	public static final String LOG_MSG_1013 = "V[PXsȃNGXg󂯎܂B";
	
	/**
	 * f[^}sG[bZ[WB<br>
	 */
	public static final String LOG_MSG_1021 = "f[^}Ɏs܂B";

	/**
	 * f[^XVsG[bZ[WB<br>
	 */
	public static final String LOG_MSG_1022 = "f[^XVɎs܂B";

	/**
	 * do^G[bZ[WB<br>
	 */
	public static final String LOG_MSG_1023 = "ɑ݂f[^ɑ΂ĐVKo^݂܂B";

	/**
	 * XVɂrG[bZ[WB<br>
	 */
	public static final String LOG_MSG_1024 = "XVɂrɊ|܂B";

	/**
	 * f[^폜sbZ[WB<br>
	 */
	public static final String LOG_MSG_1025 = "f[^폜Ɏs܂B";
	
	/**
	 * V[gsbZ[WB
	 */
	public static final String LOG_MSG_1040 = "݂ȂV[gɑ΂鑀݂܂B";

	/**
	 * NGXg^CvsbZ[WB<br>
	 */
	public static final String LOG_MSG_3001 = "NGXg^CvGet͖łB";

	/**
	 * RDBMSsbZ[WB<br>
	 */
	public static final String LOG_MSG_3003 = "RDBMSsȂRDBMSˑNG[sł܂B";

	/**
	 * {fB[߃NGXg擾bZ[WB<br>
	 */
	public static final String LOG_MSG_4001 = "{fB[郊NGXg󂯎܂B";

	/**
	 * R}h擾G[bZ[WB<br>
	 */
	public static final String LOG_MSG_4002 = "R}h̖NGXg󂯎܂B";

	/**
	 * R}htH[}bgsNGXgbZ[WB<br>
	 */
	public static final String LOG_MSG_4003 = "R}htH[}bgsȃNGXg󂯎܂B";

	/**
	 * V[PXȂꍇ̃NGXg擾bZ[WB<br>
	 */
	public static final String LOG_MSG_4004 = "V[PX̖NGXg󂯎܂B";

	/**
	 * s̋@\gpsbZ[WB<br>
	 */
	public static final String LOG_MSG_4006 = "Ȃ@\̎s݂܂B";

	/**
	 * ݂Ȃf[^ɑ΂鑀쎞bZ[WB<br>
	 */
	public static final String LOG_MSG_4007 = "݂Ȃf[^ɑ΂鑀݂܂B";

	/**
	 * ݂ȂL[\[g쎞̃bZ[WB<br>
	 */
	public static final String LOG_MSG_4008 = "݂ȂL[ɂ\[g݂܂B";

	/**
	 * X|X^Cvs̃bZ[WB<br>
	 */
	public static final String LOG_MSG_4009 = "X|X^Cv̖NGXg󂯎܂B";

	/**
	 * NGXg^Cvs̃bZ[WB<br>
	 */
	public static final String LOG_MSG_4010 = "NGXg^CvsȃNGXg󂯎܂B";

	/**
	 * o^R}h擾̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5001 = "R}ho^Ă܂Bcontroll.propertiesĂB";

	/**
	 * ݂ȂݒNX擾̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5002 = "ݒ肳ĂNX܂Bcontroll.propertiesĂB";

	/**
	 * ASPݒ~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5003 = "ASPݒɌ肪܂Bmosp.propertiesĂB";

	/**
	 * AvP[Vݒ~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5004 = "AvP[VݒɌ肪܂Bmosp.propertiesĂB";

	/**
	 * bZ[W擾~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5005 = "bZ[W̎擾Ɏs܂Bmessage.propertiesĂB";

	/**
	 * tH[[h񐔉ߑ̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5006 = "tH[h񐔂܂Bcontroll.propertiesĂB";

	/**
	 * CM_USERe[uݒ~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5007 = "e[uCM_USERɌ肪܂B";

	/**
	 * ő~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5008 = "őŃNX̎擾ł܂łB";

	/**
	 * t~X̃bZ[WB<br>
	 */
	public static final String LOG_MSG_5009 = "tɎs܂B";
	
	/**
	 * CX^XmFG[̃bZ[WB<br>
	 */
	public static final String LOG_MSG_9002 = "CX^X̌^zOł邽ߏł܂łB";

	
	/**
	 * V[PXG[̃bZ[WB<br>
	 */
	public static final String LOG_MSG_PROC_SEQ = "MV[PXF%1%  ێV[PXF%2% قȂ܂B";
	
	// NCAgbZ[WR[h
	/**
	 * }bZ[WR[hB<br>
	 */
	public static final String MSG_INSERT          = "IC0001";

	/**
	 * XVbZ[WR[hB<br>
	 */
	public static final String MSG_UPDATE          = "IC0002";

	/**
	 * 폜bZ[WR[hB<br>
	 */
	public static final String MSG_DELETE          = "IC0004";

	/**
	 * f[^񂪑݂Ȃۂ̃bZ[WR[hB<br>
	 */
	public static final String MSG_NO_DATA         = "IC0011";

	/**
	 * OAEg̃bZ[WR[hB<br>
	 */
	public static final String MSG_LOGOUT          = "IC0102";

	/**
	 * Fؕs̃bZ[WR[hB<br>
	 */
	public static final String MSG_AUTH_FAILED     = "WC1002";

	/**
	 * AJEgbÑbZ[WR[hB<br>
	 */
	public static final String MSG_ACCOUNT_LOCK    = "WC1003";

	/**
	 * R[h݂Ȃۂ̃bZ[WR[hB<br>
	 */
	public static final String MSG_NO_CODE         = "WC1006";

	/**
	 * ZbV^CAEg̃bZ[WR[hB<br>
	 */
	public static final String MSG_SESSION_TIMEOUT = "WC1011";

	/**
	 * dG[̃bZ[WR[hB<br>
	 */
	public static final String MSG_DUPLICATE       = "WC1023";

	/**
	 * r䎞̃bZ[WR[hB<br>
	 */
	public static final String MSG_EXCLUSIVE       = "WC1024";
	
	// j[R}h
	/**
	 * IndexActionďoR}hB<br>
	 */
	public static final String CMD_INDEX        = "C1011";

	/**
	 * MenuActionďoR}hB<br>
	 */
	public static final String CMD_MENU         = "C1010";

	/**
	 * MenuActionďoR}hB<br>
	 */
	public static final String CMD_ADMIN_MENU   = "C1015";
	
	/**
	 * l^ďoR}hB<br>
	 */
	public static final String CMD_PAYROLL_MENU = "P1010";

	/**
	 * oZďoR}hB<br>
	 */
	public static final String CMD_EXPENSE_MENU = "E1010";

	/**
	 * ̔ǗďoR}hB<br>
	 */
	public static final String CMD_SALES_MENU   = "S1010";

	/**
	 * LogoutActionďoR}hB<br>
	 */
	public static final String CMD_LOGOUT       = "C1030";
	
	/**
	 * pX[hύXR}hB<br>
	 */
	public static final String CMD_PASS_FORCE   = "C1052";
	
	// XgR}h
	/**
	 * ꗗ\pR}hB<br>
	 */
	public static final String CMD_LIST_SHOW   = "C1040";

	/**
	 * OŎ擾pR}hB<br>
	 */
	public static final String CMD_LIST_FORMER = "C1041";

	/**
	 * Ŏ擾pR}hB<br>
	 */
	public static final String CMD_LIST_NEXT   = "C1042";
	
	// 폜tO
	/**
	 * 폜tOOFFp萔B<br>
	 */	
	public static final int      DELETE_FLAG_OFF       = 0;

	/**
	 * 폜tOONp萔B<br>
	 */	
	public static final int      DELETE_FLAG_ON        = 1;

	/**
	 * 폜tOOFFʕ\p̒萔B<br>
	 */	
	public static final String   DELETE_FLAG_OFF_NAME  = "L";

	/**
	 * 폜tOONʕ\p̒萔B<br>
	 */	
	public static final String   DELETE_FLAG_ON_NAME   = "";

	/**
	 * 폜tOgppzB<br>
	 */	
	static final String[] DELETE_FLAG_VALUE     = {String.valueOf(MospConst.DELETE_FLAG_OFF), String.valueOf(MospConst.DELETE_FLAG_ON)};

	/**
	 * 폜tO̎gppzB<br>
	 */	
	static final String[] DELETE_FLAG_TITLE     = {MospConst.DELETE_FLAG_OFF_NAME, MospConst.DELETE_FLAG_ON_NAME};
	
	// 
	/**
	 * MosPR[h(ʃ[U[)B<br>
	 */	
	public static final String   AUTH_MOSP_USER       = "10";

	/**
	 * MosPR[h(Ǘ)B<br>
	 */	
	public static final String   AUTH_MOSP_ADMIN      = "90";

	/**
	 * MosP[U[̕\p萔(ʃ[U[)B<br>
	 */	
	public static final String   AUTH_MOSP_USER_NAME  = "ʃ[U[";

	/**
	 * MosP[U[̕\p萔(Ǘ҃[U[)B<br>
	 */	
	public static final String   AUTH_MOSP_ADMIN_NAME = "Ǘ";

	/**
	 * MosP[U[gppz(Value)B<br>
	 */	
	static final String[] AUTH_MOSP_VALUE = {MospConst.AUTH_MOSP_USER, MospConst.AUTH_MOSP_ADMIN};

	/**
	 * MosP[U[gppz(Title)B<br>
	 */	
	static final String[] AUTH_MOSP_TITLE = {MospConst.AUTH_MOSP_USER_NAME, MospConst.AUTH_MOSP_ADMIN_NAME};

	// X|XReg^Cv 
	/**
	 * X|X̃Reg^Cv(HTML)B<br>
	 */	
	public static final String RESPONSE_CONT_TYPE_HTML  = "text/html; charset=Windows-31J";

	/**
	 * X|X̃Reg^Cv(FILE)B<br>
	 */	
	public static final String RESPONSE_CONT_TYPE_FILE  = "application/octet-stream; charset=Windows-31J";
	
	/**
	 * X|X̃Reg^Cv(XML)B<br>
	 */	
	public static final String RESPONSE_CONT_TYPE_XML   = "text/xml; charset=Windows-31J";

	/**
	 * X|X̃Reg^Cv(IMAGE)B<br>
	 */	
	public static final String RESPONSE_CONT_TYPE_IMAGE = "image/jpeg";
	
	// X|Xwb_[
	/**
	 * X|X̃wb_[1(FILE)B<br>
	 */	
	protected static final String RESPONSE_HEADER_FILE       = "Content-Disposition";

	/**
	 * X|X̃wb_[2(FILE)B<br>
	 */	
	protected static final String RESPONSE_HEADER_VALUE_FILE = "attachment; filename=";
	
	// X|X^Cv
	/**
	 * X|X^Cv̒萔(HTML)B<br>
	 */	
	public static final String RESPONSE_TYPE_HTML  = "html";

	/**
	 * X|X^Cv̒萔(FILE)B<br>
	 */	
	public static final String RESPONSE_TYPE_FILE  = "file";

	/**
	 * X|X^Cv̒萔(IMAGE)B<br>
	 */	
	public static final String RESPONSE_TYPE_IMAGE = "image";

	/**
	 * X|X^Cv̒萔(XML)B<br>
	 */	
	public static final String RESPONSE_TYPE_XML   = "xml";
	
	// GR[h
	/**
	 * GR[hݒp萔(Windows-31J)B<br>
	 */		
	static final String REQUEST_CHAR_ENC     = "Windows-31J";

	/**
	 * GR[hݒp萔(SHIFT_JIS)B<br>
	 */		
	static final String XML_CHAR_ENC         = "SHIFT_JIS";
	
	// NGXg{fBoCg
	//static final int    CONTENT_MAX_LEN = 65535;
	/**
	 * NGXg{fBoCgB<br>
	 */		
	static final int    CONTENT_MAX_LEN = 17000000;
	
	// 
	/**
	 * (R}h)B
	 */
	static final int LEN_COMMAND = 6;
	
	/**
	 * ([U[ID)B<br>
	 */		
	public static final int LEN_USER_ID      = 10;
	
	/**
	 * (pX[h)B<br>
	 */		
	public static final int LEN_PASSWORD     = 32;
	
	/**
	 * (pX[hŏ)B<br>
	 */		
	public static final int LEN_MIN_PASSWORD = 4;
	
	// ͐
	/**
	 * ͐p萔(dbԍ)B<br>
	 */		
	public static final String REG_PHONE       = "[0-9-]*";

	/**
	 * ͐p萔(l1)B<br>
	 */		
	public static final String REG_DECIMAL_PRE = "^(([1-9]\\d{0,";

	/**
	 * ͐p萔(l2)B<br>
	 */		
	public static final String REG_DECIMAL_MID = "})|0)(\\.\\d{1,";

	/**
	 * ͐p萔(l3)B<br>
	 */		
	public static final String REG_DECIMAL_AFT = "})?$";
	
	// ̑
	/**
	 * CZp[gp̒萔B<br>
	 */		
	public static final String LINE_SEPARATOR = System.getProperty("line.separator");

	/**
	 * ttH[}bgݒp萔B<br>
	 */		
	static final String DATE_FORMAT    = "yyyy/MM/dd";

	/**
	 * ԃtH[}bgݒp萔B<br>
	 */		
	static final String TIME_FORMAT    = "HH:mm:ss";

	/**
	 * ɂtH[}bgݒp萔B<br>
	 */		
	static final String DAY_FORMAT     = "E";
	
	/**
	 * JnO\p萔B<br>
	 */		
	static final String ACTION_START   = "Jn";

	/**
	 * IO\p萔B<br>
	 */		
	static final String ACTION_END     = "I";
	
	/**
	 * Fؗp萔B<br>
	 */
	public static final String AUTH_NO_AUTH = "00";
	
	/**
	 * f[^Zp[gpB<br>
	 */		
	public static final String DATA_SEPARATOR = ",";
	
	/**
	 * javascriptpB<br>
	 */		
	public static final String JS_MESSAGE_NAME = "msg";
	
	/**
	 * xmlo͗p^[R[hB<br>
	 */		
	public static final String XML_RETCODE_OK      = "0";

	/**
	 * xmlo͗p[gm[h^OB<br>
	 */		
	public static final String XML_ROOT_NODE       = "MospData";

	/**
	 * xmlo͗ptB[h^OB<br>
	 */		
	public static final String XML_FIELD_NODE      = "Fields";

	/**
	 * xmlo͗pXg^OB<br>
	 */		
	public static final String XML_LIST_NODE       = "List";

	/**
	 * xmlo͗p^[R[h^OB<br>
	 */		
	public static final String XML_RETCODE_NODE    = "XmlRetCode";

	/**
	 * xmlo͗pV[PX^OB<br>
	 */		
	public static final String XML_PROC_SEQ        = "ProcSeq";

	/**
	 * xmlo͗pJEg^OB<br>
	 */		
	public static final String XML_COUNT_NODE      = "Count";

	/**
	 * xmlo͗pbZ[W^OB<br>
	 */		
	public static final String XML_MESSAGE_NODE    = "Message";

	/**
	 * xmlo͗pG[bZ[W^OB<br>
	 */		
	public static final String XML_ERR_MSG_NODE    = "ErrorMessage";

	/**
	 * xmlo͗pG[tB[h^OB<br>
	 */		
	public static final String XML_ERR_FIELD_NODE  = "ErrorFields";

	/**
	 * xmlo͗pG[ڍ׃^OB<br>
	 */		
	public static final String XML_ERR_DETAIL_NODE = "ErrorDetails";

	/**
	 * xmlo͗psNo^OB<br>
	 */		
	public static final String XML_ATT_ROW_NO      = "rowNo";

	/**
	 * f[^݂Ȃꍇ̒萔B<br>
	 */		
	public static final String DATA_IS_NOT_EXIST = "0";

	/**
	 * f[^݂ꍇ̒萔B<br>
	 */		
	public static final String DATA_IS_EXIST     = "1";
	
	
	/**
	 * RDBMS(MySQL)B<br>
	 */		
	static final int RDBMS_MYSQL = 1;
	
	/**
	 * RDBMS(PostgreSQL)B<br>
	 */		
	static final int RDBMS_PGSQL = 2;

	/**
	 * ꗗŌJ{^B<br>
	 */		
	static final int COUNT_PAGE_BUTTON = 10;
	
}
