/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.dao.CmAuthorityDao;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;

/**
 * ɊւPartNX
 * @author yoshida
 *	@version	0.0.3
 */
public class AuthorityPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public AuthorityPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public AuthorityPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * CmAuthorityDaoCX^X
	 */
	private CmAuthorityDao	authorityDao;
	

	/**
	 * CM_AUTHORITYe[upDAO擾
	 * @return	ςCmAuthorityDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public CmAuthorityDao getCmAuthorityDao() throws Exception {
		if (VariousUtil.isNull(authorityDao)) {
			authorityDao = (CmAuthorityDao)getPreparedDao(CmAuthorityDao.class.getCanonicalName());
		}
		return authorityDao;
	}
	
	/**
	 * ̎擾
	 * @param userAuth	ΏیR[h
	 * @return			
	 * @throws Exception Oꍇ
	 */
	public CmAuthorityDto findForKey(String userAuth) throws Exception {
		return getCmAuthorityDao().findForKey(userAuth);
	}
	
	/**
	 * R[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getArrangeAuthArray() throws Exception {
		// f[^̎擾
		List<CmAuthorityDto> list = getCmAuthorityDao().findForAvailable();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < array.length; i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}
	
	/**
	 * SR[hXg擾(CM_AUTHORITY)
	 * @return R[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getArrangeAuthArrayAll() throws Exception {
		// f[^̎擾
		List<CmAuthorityDto> list = getCmAuthorityDao().findAll();
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < array.length; i++) {
			CmAuthorityDto dto = list.get(i);
			array[i][0] = dto.getAuthCode();
			array[i][1] = dto.getAuthName();
		}
		return array;
	}
	
	/**
	 * MANAGERmF
	 * @return MANAGERL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	public boolean hasManagerAuth() throws Exception {
		// MANAGERmF
		String authority = user.getAuthority();
		CmAuthorityDto dto = findForKey(authority);
		String managerAuth = "";
		if (VariousUtil.isNotNull(dto)) {
			managerAuth = dto.getManager();
		} else if (isManagerAuth(authority) || isSeniorAuth(authority)) {
			// ftHgR[h̐ݒ
			managerAuth = CommonConst.CONF_ID_MANAGER;
		}
		if (StringUtil.isNotNull(managerAuth)) {
			return true;
		}
		return false;
	}
	
	/**
	 * PAYROLLmF
	 * @return PAYROLLL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	public boolean hasPayrollAuth() throws Exception {
		// PAYROLLmF
		String authority = user.getAuthority();
		String payrollAuth = "";
		CmAuthorityDto dto = findForKey(authority);
		if (VariousUtil.isNotNull(dto)) {
			payrollAuth = dto.getPayroll();
		} else if (isPayrollAuth(authority) || isSeniorAuth(authority) || isCalculateAuth(authority)) {
			// ftHgR[h̐ݒ
			payrollAuth = CommonConst.CONF_ID_PAYROLL;
		}
		if (StringUtil.isNotNull(payrollAuth)) {
			return true;
		}
		return false;
	}
	
	/**
	 * HUMANmF
	 * @return HUMANL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	public boolean hasHumanAuth() throws Exception {
		// HUMANmF
		String userAuth = user.getAuthority();
		String humanAuth = "";
		CmAuthorityDto dto = findForKey(userAuth);
		if (VariousUtil.isNotNull(dto)) {
			humanAuth = dto.getHuman();
		} else if (isHumanAuth(userAuth) || isSeniorAuth(userAuth)) {
			// ftHgR[h̐ݒ
			humanAuth = CommonConst.CONF_ID_HUMAN;
		}
		if (StringUtil.isNotNull(humanAuth)) {
			return true;
		}
		return false;
	}
	
	/**
	 * CALCULATEmF
	 * @return CALCULATEL(trueFLAfalseF)
	 * @throws Exception Oꍇ
	 */
	public boolean hasCalculateAuth() throws Exception {
		// CALCULATEmF
		String userAuth = user.getAuthority();
		CmComponentDto componentDto = null;
		CmAuthorityDto authorityDto = findForKey(userAuth);
		if (VariousUtil.isNotNull(authorityDto)) {
			componentDto = part().component().findForDto(authorityDto.getPayroll(), CommonConst.CONF_ID_PAYROLL);
		}
		if (isCalculateAuth(userAuth)) {
			// ftHgR[h̐ݒ
			if (VariousUtil.isNull(authorityDto)) {
				componentDto = part().component()
					.findForDto(CommonConst.CONF_ID_CALCULATE, CommonConst.CONF_ID_PAYROLL);
			}
			// ftHgR[h̐ݒ
			if (VariousUtil.isNull(componentDto)) {
				componentDto = new CmComponentDto();
				componentDto.setComponent(MosPMenuConst.getMenuAttendanceCalculateStart()[0]);
			}
		}
		if (VariousUtil.isNotNull(componentDto)) {
			String[] aryCmd = StringUtil.divideByComma(componentDto.getComponent());
			for (String element : aryCmd) {
				if (element.equals(MosPMenuConst.getMenuAttendanceCalculateStart()[0])
						|| element.equals(MosPMenuConst.getMenuAttendanceCalculateEnd()[0])
						|| element.equals(MosPMenuConst.getMenuKeisanInformation()[0])
						|| element.equals(MosPMenuConst.getMenuExport()[0])) {
					return true;
				}
			}
		}
		return false;
	}
	
	/**
	 * SYSTEMmF
	 * @return SYSTEML(trueFLAfalseF)
	 */
	public boolean hasSystemAuth() {
		// ADMINmF
		return isSystemAuth(user.getAuthority());
	}
	
	/**
	 * DTO擾
	 * @since	0.0.2
	 * @return DTO
	 * @throws Exception Oꍇ
	 */
	public CmAuthorityDto getUserAuthDto() throws Exception {
		return getCmAuthorityDao().findForAuth(user.getAuthority());
	}
	
	/**
	 * MANAGERmF
	 * @since	0.0.3
	 * @param authority	ΏۃvOpR[h
	 * @return	MANAGEȐꍇtrueAłȂꍇfalse
	 */
	public static boolean isManagerAuth(String authority) {
		return CommonConst.AUTHORITY_MANAGER.equals(authority);
	}
	
	/**
	 * ^mF
	 * @since	0.0.3
	 * @param authority	ΏۃvOpR[h
	 * @return	^̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isPayrollAuth(String authority) {
		return CommonConst.AUTHORITY_PAYROLL.equals(authority);
	}
	
	/**
	 * HUMANmF
	 * @since	0.0.3
	 * @param authority	ΏۃvOpR[h
	 * @return	HUMAN̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isHumanAuth(String authority) {
		return CommonConst.AUTHORITY_HUMAN.equals(authority);
	}
	
	/**
	 * l^mF
	 * @since	0.0.3
	 * @param authority	ΏۃvOpR[h
	 * @return	l^̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isSeniorAuth(String authority) {
		return CommonConst.AUTHORITY_SENIORS.equals(authority);
	}
	
	/**
	 * vZf
	 * @since	0.0.3
	 * @param authority	ΏۃvOpR[h
	 * @return	vZ̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isCalculateAuth(String authority) {
		return CommonConst.AUTHORITY_CALCULATE.equals(authority);
	}
	
	/**
	 * SYSTEMf
	 * @since	0.0.3
	 * @param authority		ΏۃvOpR[h
	 * @return SYSTEM̏ꍇtrueAłȂꍇfalse
	 */
	public static boolean isSystemAuth(String authority) {
		// ADMINmF
		return CommonConst.AUTH_SYSTEM.equals(authority);
	}
	
}
