/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.common.part;

import java.util.HashMap;
import java.util.Map;

import jp.mosp.common.common.MospException;

/**
 * Partێ{NX
 * @author yoshida
 *	@version 0.0.1
 */
public abstract class BaseStore {
	
	/**
	 * PartInfoCX^X
	 */
	private PartInfo				partInfo;
	
	/**
	 * PartێMap
	 */
	private Map<String, BasePart>	partMap;
	

	/**
	 * RXgN^
	 */
	public BaseStore() {
		partMap = new HashMap<String, BasePart>();
	}
	
	/**
	 * ΏPartCX^X擾
	 * @param partClassName 	ΏPartNX
	 * @return ΏPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public BasePart get(String partClassName) throws MospException {
		if (!partMap.containsKey(partClassName)) {
			add(partClassName);
		}
		return partMap.get(partClassName);
	}
	
	/**
	 * ΏPartCX^X擾
	 * @param cls 	ΏPartNX
	 * @return ΏPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public BasePart get(Class<?> cls) throws MospException {
		return get(cls.getCanonicalName());
	}
	
	/**
	 * ΏPartCX^Xǉ
	 * @param partClassName	 	ΏPartNX
	 * @throws MospException MosPOꍇ
	 */
	private void add(String partClassName) throws MospException {
		partMap.put(partClassName, PartManager.getPreparedPart(partClassName, partInfo));
	}
	
	/**
	 * ێCX^XS
	 */
	public void clear() {
		partMap.clear();
	}
	
	/**
	 * @param partInfo Zbg partInfo
	 */
	public void setPartInfo(PartInfo partInfo) {
		this.partInfo = partInfo;
	}
	
}
