/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.JapanHolidayUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;

/**
 * jՓɊւPartNX
 * @author yoshida
 *	@version	0.0.3
 */
public class JPHolidayPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public JPHolidayPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public JPHolidayPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * NL[Ƃj}bv
	 */
	private Map<Integer, Map<Date, String>>	holidayMap;
	

	/**
	 * j̎擾
	 * <p>	2009/02/25	m.yoshida	j\bhC </p>
	 * @param targetDate		Ώ۔N
	 * @return	Ώ۔Nj
	 * @throws Exception	Oꍇ
	 */
	public String getPublicHolidayName(Date targetDate) throws Exception {
		// Ώۓj̎擾
		String targetName = searchMap(targetDate, true, true).get(targetDate);
		if (StringUtil.isNotNull(targetName)) {
			return targetName;
		}
		return "";
	}
	
	/**
	 * x̎擾
	 * @param targetDate		Ώ۔N
	 * @param addJPholiday  	̏jtO(Jg)
	 * @param addHolidayMaster xɃ}X^tO(Jg)
	 * @return	Ώ۔Nx
	 * @throws Exception	Oꍇ
	 */
	public String getStandardHolidayName(Date targetDate, boolean addJPholiday, boolean addHolidayMaster)
			throws Exception {
		// Ώۓj̎擾
		String targetName = searchMap(targetDate, addJPholiday, addHolidayMaster).get(targetDate);
		if (StringUtil.isNotNull(targetName)) {
			return targetName;
		}
		return "";
	}
	
	/**
	 * jՓ
	 * @since	0.0.3
	 * @param targetDate		Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NjՓȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	public boolean isPublicHoliday(Date targetDate) throws Exception {
		if (searchMap(targetDate, true, true).containsKey(targetDate)) {
			return true;
		}
		return isStandardHoliday(targetDate, true, true);
	}
	
	/**
	 * x
	 * @param targetDate 	Ώ۔N
	 * @param addJPholiday ̏jtO(Jg)
	 * @param addHolidayMaster xɃ}X^tO(Jg)
	 * @return
	 * <p>
	 * Ώ۔NxȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public boolean isStandardHoliday(Date targetDate, boolean addJPholiday, boolean addHolidayMaster) throws Exception {
		// ̏jtO(Jg)Ή
		// xɃ}X^tO(Jg)Ή
		if (searchMap(targetDate, addJPholiday, addHolidayMaster).containsKey(targetDate)) {
			return true;
		}
		return false;
	}
	
	/**
	 * j}bv
	 * @since	0.0.3
	 * @param targetDate 	Ώ۔N
	 * @param addJPholiday ̏jtO(Jg)
	 * @param addHolidayMaster xɃ}X^tO(Jg)
	 * @return	Ώ۔Nj}bv
	 * @throws Exception 	Oꍇ
	 */
	private Map<Date, String> searchMap(Date targetDate, boolean addJPholiday, boolean addHolidayMaster)
			throws Exception {
		int year = MospUtility.getYear(targetDate);
		if (VariousUtil.isNull(holidayMap)) {
			holidayMap = new TreeMap<Integer, Map<Date, String>>();
		}
		if (!holidayMap.containsKey(year)) {
			holidayMap.put(year, createHolidayMap(year, addHolidayMaster, addJPholiday));
		}
		return holidayMap.get(year);
	}
	
	/**
	 * j̃}bv
	 * @param year			Ώ۔N
	 * @param addHolidayMaster jՓ}X^̗p
	 * @param addJPholiday j@̓Kp
	 * @return 	jՓ}bv
	 * @throws Exception 	Oꍇ
	 */
	private Map<Date, String> createHolidayMap(int year, boolean addHolidayMaster, boolean addJPholiday)
			throws Exception {
		Map<Date, String> map = new TreeMap<Date, String>();
		// jՓ}X^
		if (addHolidayMaster) {
			String[][] aryCodeHoliday = part().mospcode().getMosPCodeArray(CommonConst.TID_HOLIDAY);
			Date holiday = null;
			for (String[] element : aryCodeHoliday) {
				// MM/DDn܂xւ̑Ή
				if (element[0].startsWith("0") || element[0].startsWith("1")) {
					StringBuffer date = new StringBuffer();
					date.append(String.valueOf(year));
					date.append(CommonConst.SEPARATOR_DATE);
					date.append(element[0]);
					holiday = MospUtility.getDate(date.toString());
				} else {
					holiday = MospUtility.getDate(element[0]);
				}
				map.put(holiday, element[1]);
			}
		}
		// ̏j
		if (addJPholiday) {
			/*						
			 *  	2009/10/29	m.yoshida	j@Ή
			 */
			Map<Date, String> jpHolidayMap = getJapanHolidayMap(year);
			map.putAll(jpHolidayMap);
		}
		return map;
	}
	
	/**
	 * PNjՓ}bv擾
	 * @param year	Ώ۔N
	 * @return	jՓ}bv
	 */
	private Map<Date, String> getJapanHolidayMap(int year) {
		return new JapanHolidayUtil(year).getHolidayMap();
	}
	
}
