/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dao.MCodeDao;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;

/**
 * MosP̃R[hɊւPartNX
 * @author yoshida
 *	@version	0.0.5
 */
public class MosPCodePart extends BasePart {
	
	/**
	 * M_CODE
	 */
	public static final String	TABLE	= MCodeDao.TABLE;
	

	/**
	 * RXgN^
	 */
	public MosPCodePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	 Part𗘗pۂɕKvȏ
	 */
	public MosPCodePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	/**
	 * MCodeDaoCX^X
	 */
	private MCodeDao	codeDao;
	

	/**
	 * MCodeDao擾
	 * @return			MCodeDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	public MCodeDao getMCodeDao() throws Exception {
		if (VariousUtil.isNull(codeDao)) {
			codeDao = (MCodeDao)getPreparedDao(MCodeDao.class.getCanonicalName());
		}
		return codeDao;
	}
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	public MCodeDto findForKey(String tid, String tcode) throws Exception {
		return getMCodeDao().findForKey(tid, tcode);
	}
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	public MCodeDto findForDto(String tid) throws Exception {
		return getMCodeDao().findForDto(tid);
	}
	
	/**
	 * L[ɂ񃊃Xg擾
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MCodeDto> findForCondition(String tid, String tcode) throws Exception {
		return getMCodeDao().findForCondition(tid, tcode);
	}
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return	R[hϊ
	 * @throws Exception	Oꍇ
	 */
	public String findTchange(String tid, String tcode) throws Exception {
		MCodeDto dto = findForKey(tid, tcode);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getTChange();
		}
		return "";
	}
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @return	R[hϊ
	 * @throws Exception	Oꍇ
	 */
	public String findTchange(String tid) throws Exception {
		MCodeDto dto = findForDto(tid);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getTChange();
		}
		return "";
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[h敪Xg
	 * @throws Exception	Oꍇ
	 */
	public String[][] getMosPCodeArray() throws Exception {
		// R[h敪̎擾(distinctf[^)
		List<MCodeDto> list = getMCodeDao().findAllTId();
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = tId;
		}
		return aryCode;
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception	Oꍇ
	 */
	public String[][] getMosPCodeArray(String tid) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = findForCondition(tid);
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @throws Exception	Oꍇ
	 */
	public String[][] getMosPCodeArray(String tid, String tcode) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = findForCondition(tid, tcode);
		String[][] aryCode = new String[list.size()][3];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			aryCode[i] = convArray(list.get(i));
		}
		return aryCode;
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @throws Exception	Oꍇ
	 */
	public String[] getMosPCode(String tid, String tcode) throws Exception {
		// R[h̎擾
		return convArray(findForKey(tid, tcode));
	}
	
	/**
	 * R敪擾(M_CODE)
	 * @param tid R[hID
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * @throws Exception	Oꍇ
	 */
	public String[][] getReasonCodeArray(String tid) throws Exception {
		// R[h̎擾
		List<MCodeDto> list = getMCodeDao().findForReason(tid);
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < aryCode.length; i++) {
			aryCode[i][0] = list.get(i).getTCode();
			aryCode[i][1] = list.get(i).getTName();
		}
		return aryCode;
	}
	
	/**
	 * R[h敪擾(M_CODE)
	 * @return R[hz[][]<br>
	 * 			[0]tcode<br>
	 * 			[1]tname<br>
	 * 			[2]tchange
	 * @param tid R[hID
	 * @throws Exception	Oꍇ
	 */
	public String[] getMosPCode(String tid) throws Exception {
		// R[h̎擾
		return convArray(findForDto(tid));
	}
	
	/**
	 * LxɎx
	 * @return [0]cΑNA[1]cx
	 * @throws Exception	Oꍇ
	 */
	public String[][] getPaidHolidayArray() throws Exception {
		List<MCodeDto> listCode = getPaidHolidayList();
		String[][] aryPaidHolidayDays = new String[listCode.size()][2];
		for (int i = 0; i < aryPaidHolidayDays.length; i++) {
			aryPaidHolidayDays[i][0] = listCode.get(i).getTCode();
			aryPaidHolidayDays[i][1] = listCode.get(i).getTChange();
		}
		return aryPaidHolidayDays;
	}
	
	/**
	 * LxɎx񃊃Xg擾
	 * @return LxɎx񃊃Xg
	 * @throws Exception	Oꍇ
	 */
	public List<MCodeDto> getPaidHolidayList() throws Exception {
		return getMCodeDao().findForHoliday(CommonConst.TID_PAID_HOLIDAY_SUPPLY);
	}
	
	/**
	 * ΑӏF@\󋵎擾(M_CODE)
	 * @return	boolean 	ΑӏF@\̗L
	 * @throws Exception	Oꍇ
	 */
	public boolean isAttendanceApprovalFunction() throws Exception {
		return StringUtil.isFlagOff(getTName(CommonConst.TID_APPROVAL_FUNCTION, CommonConst.TCD_ATTENDANCE_APPROVAL));
	}
	
	/**
	 * pX[hL
	 * @return	int		pX[hL
	 * @throws Exception	Oꍇ
	 */
	public int getPasswordTerm() throws Exception {
		int days = 0;
		// R[h̎擾
		MCodeDto dto = findForDto(CommonConst.TID_PASSWORD_TERM);
		if (VariousUtil.isNotNull(dto)) {
			days = Integer.parseInt(dto.getTChange());
		}
		return days;
	}
	
	/**
	 * LJz
	 * @return	String[]	LJz
	 * <p>
	 * [0]...JzA
	 * [1]...JzA
	 * [2]...Jz敪
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public String[] getPaidHolidayInfo() throws Exception {
		return new String[]{
		// Jz
			String.valueOf(getCarriedForwardMonth()),
			// Jz
			String.valueOf(getCarriedForwardDays()),
			// Jz敪
			getCarriedForwardType(), };
	}
	
	/**
	 * Jz
	 * @return	Jz
	 * @throws Exception	Oꍇ
	 */
	public int getCarriedForwardMonth() throws Exception {
		return NumberUtil.getIntParam(findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_CARRIED_FORWARD_MONTH));
	}
	
	/**
	 * Jz
	 * @return	Jz
	 * @throws Exception	Oꍇ
	 */
	public int getCarriedForwardDays() throws Exception {
		return NumberUtil.getIntParam(findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_CARRIED_FORWARD_DAYS));
	}
	
	/**
	 * Jz敪
	 * @return	Jz敪
	 * @throws Exception	Oꍇ
	 */
	public String getCarriedForwardType() throws Exception {
		return findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_CARRIED_FORWARD_TYPE);
	}
	
	/**
	 * xɗRz擾
	 * @since	0.0.2
	 * @return	xɗRz
	 * @throws Exception	Oꍇ
	 */
	public String[][] getHolidayReasonArray() throws Exception {
		String[][] aryHolidayReason = getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
		// 60Ԃ𒴉߂ꍇ̑֋x
		if (useSubstituteHolidayFunction()) {
			aryHolidayReason = StringUtil.addArrayLastRowValue(aryHolidayReason, CommonConst.CODE_SUB_HOLIDAY_REQUEST,
					CommonConst.NAM_SUB_HOLIDAY);
		}
		return aryHolidayReason;
	}
	
	/**
	 * xxɗRz擾
	 * @return xxɗRz(ԊOxL̏ꍇǉ)
	 * @throws Exception	Oꍇ
	 */
	public String[][] getHalfHolidayArray() throws Exception {
		String[][] aryHalfHoliday = getMosPCodeArray(CommonConst.TID_HALF_HOLIDAY_TYPE);
		if (part().mospcode().useSubstituteHolidayFunction()) {
			aryHalfHoliday = StringUtil.addArrayLastRowValue(aryHalfHoliday, CommonConst.CODE_SUB_HOLIDAY_HALF_FLAG,
					CommonConst.NAM_SUB_HOLIDAY_HALF);
		}
		return aryHalfHoliday;
	}
	
	/**
	 * ΏیR[hXg擾
	 * @param tId			ΏیR[h
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MCodeDto> findForCondition(String tId) throws Exception {
		return getMCodeDao().findForCondition(tId);
	}
	
	/**
	 * ꎟz֕ϊ
	 * @since	0.0.3
	 * @param dto	ΏDTO
	 * @return	ꎟz<br>
	 * [0]ctCode
	 * [1]ctName
	 * [2]ctChange
	 */
	public static String[] convArray(MCodeDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return new String[]{ dto.getTCode(), dto.getTName(), dto.getTChange(), };
		}
		return new String[3];
	}
	
	/**
	 * L[ɂ̎擾
	 * @since	0.0.4
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return	R[h̕
	 * @throws Exception	Oꍇ
	 */
	public String getTName(String tid, String tcode) throws Exception {
		MCodeDto dto = findForKey(tid, tcode);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getTName();
		}
		return tcode;
	}
	
	/**
	 * xɖ̎擾
	 * @since	0.0.4
	 * @param tcode		ΏۋxɗRR[h
	 * @return	xɗR
	 * @throws Exception	Oꍇ
	 */
	public String getHolidayName(String tcode) throws Exception {
		// 60ԎԊOɂx
		if (CommonConst.CODE_SUB_HOLIDAY_REQUEST.equals(tcode)) {
			return CommonConst.NAM_SUB_HOLIDAY;
		}
		return getTName(CommonConst.TID_LEAVE_REASON, tcode);
	}
	
	/**
	 * pX[hL`FbN
	 * @param updateDate	XV
	 * @return
	 * <p>
	 * L𒴉߂trueAłȂꍇfalse
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public boolean isExpirePassWord(Date updateDate) throws Exception {
		int passTerm = getPasswordTerm();
		if (passTerm > 0 && DateUtil.getSystemDate().compareTo(DateUtil.addDay(updateDate, passTerm)) > 0) {
			return true;
		}
		return false;
	}
	
	/**
	 * xԔz擾
	 * @since 	0.0.5
	 * @return xԔz
	 * @throws Exception  	Oꍇ
	 */
	public String[][] getLimitStandardTermArray() throws Exception {
		return getMosPCodeArray(CommonConst.TID_LIMIT_STANDARD_TERM);
	}
	
	/**
	 * ޔz擾
	 * @since 	0.0.5
	 * @return ޔz
	 * @throws Exception   	Oꍇ
	 */
	public String[][] getAgreementTypeArray() throws Exception {
		return getMosPCodeArray(CommonConst.TID_AGREEMENT_TYPE);
	}
	
	/**
	 * ۂߏR[h擾
	 * @since 	0.0.5
	 * @return ۂߏR[h
	 * @throws Exception 	Oꍇ
	 */
	public String getRoundNumberProcess() throws Exception {
		return findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_ROUND_NUMBER);
	}
	
	/**
	 * 60ԎԊOԋ@\pf
	 * @since 	0.0.5
	 * @return
	 * <p>
	 * 60ԎԊOԋ@\𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public boolean useOverTime60HourFunction() throws Exception {
		return StringUtil.isFlagOff(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_OVER_TIME_60_HOUR));
	}
	
	/**
	 * x@\pf
	 * @since 	0.0.5
	 * @return 
	 * <p>
	 * x@\𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	public boolean useSubstituteHolidayFunction() throws Exception {
		return useOverTime60HourFunction()
				&& StringUtil.isFlagOff(findTchange(CommonConst.TID_WORK_SYSTEM, CommonConst.TCD_SUBSTITUTE_HOLIDAY));
	}
	
	/**
	 * ԒPʔNx@\pf
	 * @since 	0.0.5
	 * @return 
	 * <p>
	 * ԒPʔNx𗘗pꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception  	Oꍇ
	 */
	public boolean useHourPaidHolidayFunction() throws Exception {
		return StringUtil.isFlagOff(findTchange(CommonConst.TID_PAID_HOLIDAY,
				CommonConst.TCD_HOUR_PAID_HOLIDAY_FUNCTION));
	}
	
	/**
	 * NxPʎԎ擾
	 * @since 	0.0.5
	 * @return NxPʎ
	 * @throws Exception  	Oꍇ
	 */
	public int getHourPaidHolidayUnit() throws Exception {
		if (useHourPaidHolidayFunction()) {
			return NumberUtil.getIntParam(findTchange(CommonConst.TID_PAID_HOLIDAY,
					CommonConst.TCD_HOUR_PAID_HOLIDAY_UNIT));
		}
		return 0;
	}
	
	/**
	 * LxɓЌxtOB
	 * @return
	 * <p>
	 * LxɂЌɎxꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception  	Oꍇ
	 */
	public boolean useProvideEmployMonth() throws Exception {
		return StringUtil.isFlagOn(findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_SUPPLY_MODEL));
	}
	
	/**
	 * J@{sf
	 * @param targetDate Ώ۔N
	 * @return
	 * <p>
	 * 22N41ȍ~̏ꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean afterLegalReformDate(Date targetDate) {
		return DateUtil.getLegalReformDate().compareTo(targetDate) <= 0;
	}
	
}
