/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.List;

import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.utils.VariousUtil;

/**
 * ݒe[uɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class MosPConfPart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public MosPConfPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public MosPConfPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MosPConfDao	confDao;
	

	/**
	 * CM_CONFe[upDAO擾
	 * @return	ςMosPConfDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	private MosPConfDao getMosPConfDao() throws Exception {
		if (VariousUtil.isNull(confDao)) {
			confDao = (MosPConfDao)getPreparedDao(MosPConfDao.class.getCanonicalName());
		}
		return confDao;
	}
	
	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception	Oꍇ
	 */
	public String[][] getConfArray(String confId) throws Exception {
		// f[^̎擾
		List<MosPConfDto> list = getMosPConfDao().findForCondition(confId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			MosPConfDto dto = list.get(i);
			array[i][0] = dto.getConfCode();
			array[i][1] = dto.getConfValue();
		}
		return array;
	}
	
	/**
	 * ݒl擾(MOSP_CONF)
	 * @param confId   ݒ敪
	 * @param confCode ݒR[h
	 * @return ݒl
	 * @throws Exception	Oꍇ
	 */
	public String getConfValue(String confId, String confCode) throws Exception {
		// f[^̎擾
		MosPConfDto dto = getMosPConfDao().findForKey(confId, confCode);
		if (dto == null) {
			return "";
		}
		return dto.getConfValue();
	}
	
	/**
	 * ݒ胊Xg擾(MOSP_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws Exception 	Oꍇ
	 */
	public List<MosPConfDto> getConfList(String confId) throws Exception {
		// f[^̎擾
		return getMosPConfDao().findForCondition(confId);
	}
	
}
