/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.text.NumberFormat;

import jp.mosp.common.common.ValidateUtility;

/**
 * ɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class NumberUtil {
	
	/**
	 * 
	 */
	private NumberUtil() {
		// NXɂCX^Xh~
	}
	

	/**
	 * 
	 */
	public static final String	NAM_ZERO			= "";
	/**
	 * 
	 */
	public static final String	NAM_ONE				= "";
	/**
	 * 
	 */
	public static final String	NAM_TWO				= "";
	/**
	 * O
	 */
	public static final String	NAM_THREE			= "O";
	/**
	 * l
	 */
	public static final String	NAM_FOUR			= "l";
	/**
	 * 
	 */
	public static final String	NAM_FIVE			= "";
	/**
	 * Z
	 */
	public static final String	NAM_SIX				= "Z";
	/**
	 * 
	 */
	public static final String	NAM_SEVEN			= "";
	/**
	 * 
	 */
	public static final String	NAM_EIGHT			= "";
	/**
	 * 
	 */
	public static final String	NAM_NINE			= "";
	/**
	 * \
	 */
	public static final String	NAM_TEN				= "\";
	/**
	 * S
	 */
	public static final String	NAM_HUNDRED			= "S";
	/**
	 * 
	 */
	public static final String	NAM_THOUSAND		= "";
	/**
	 * 
	 */
	public static final String	NAM_TEN_THOUSAND	= "";
	/**
	 * 
	 */
	public static final String	NAM_HUNDRED_MILLION	= "";
	/**
	 * 
	 */
	public static final String	NAM_TRILLION		= "";
	

	/**
	 * @return ̂̔z
	 */
	public static final String[] getKanjiNumberArray() {
		return new String[]{ NAM_ZERO, NAM_ONE, NAM_TWO, NAM_THREE, NAM_FOUR, NAM_FIVE, NAM_SIX, NAM_SEVEN, NAM_EIGHT,
			NAM_NINE, NAM_TEN, NAM_HUNDRED, NAM_THOUSAND, NAM_TEN_THOUSAND, NAM_HUNDRED_MILLION, NAM_TRILLION };
	}
	
	/**
	 * tH[}bg
	 * @param number 
	 * @param integer ő包
	 * @param fraction _ȉő包
	 * @return ()
	 */
	public static String getNumberString(double number, int integer, int fraction) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumIntegerDigits(integer);
		nf.setMaximumFractionDigits(fraction);
		return nf.format(number);
	}
	
	/**
	 * ϊ
	 * @param input		ϊO
	 * @return	ϊ㐮
	 */
	public static int getIntParam(String input) {
		int num = 0;
		if (StringUtil.isNotNull(input)) {
			if (ValidateUtility.chkRegex("^-?\\d+", input)) {
				try {
					num = Integer.parseInt(input);
				} catch (NumberFormatException e) {
					num = 0;
				}
			}
		}
		return num;
	}
	
	/**
	 * _ϊ
	 * @param input		ϊO
	 * @return	ϊ㕂_
	 */
	public static double getDoubleParam(String input) {
		double dnum = 0;
		if (StringUtil.isNotNull(input)) {
			try {
				dnum = Double.parseDouble(input);
			} catch (NumberFormatException e) {
				dnum = 0;
			}
		}
		return dnum;
	}
	
	/**
	 * ۂߏ
	 * @param input ͒l
	 * @param unit P
	 * @return ۂߏ㐮
	 */
	public static int roundIntegerNumber(int input, int unit) {
		int output = input;
		int round = output % unit;
		if (round > 0) {
			output += unit;
		}
		output -= round;
		return output;
	}
	
}
