/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.KanaConvertUtility;
import jp.mosp.common.common.MospUtility;

/**
 * StringɊւPartNX
 * @author yoshida
 * 	@version	0.0.2
 */
public class StringUtil {
	
	/**
	 * 
	 */
	private StringUtil() {
		// NXɂCX^Xh~
	}
	
	/*		z֘A		*/

	/**
	 * 񎟌zꎟz֕ϊ
	 * @param ary Ώۓ񎟌z
	 * @param d INo.
	 * @return Iꎟz
	 */
	public static String[] separateArrayList(String[][] ary, int d) {
		String[] aryName = new String[ary.length];
		for (int i = 0; i < ary.length; i++) {
			aryName[i] = ary[i][d];
		}
		return aryName;
	}
	
	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public static String[][] combineArray(String[][] frontarray, String[][] behindarray) {
		String[][] result = new String[frontarray.length + behindarray.length][2];
		System.arraycopy(frontarray, 0, result, 0, frontarray.length);
		System.arraycopy(behindarray, 0, result, frontarray.length, behindarray.length);
		return result;
	}
	
	/**
	 * z񓯎m̌
	 * @param frontarray Ons2
	 * @param centerarray ns2
	 * @param behindarray ns2
	 * @return	String[][]	z
	 */
	public static String[][] combineArray(String[][] frontarray, String[][] centerarray, String[][] behindarray) {
		String[][] result = combineArray(combineArray(frontarray, centerarray), behindarray);
		return result;
	}
	
	/**
	 * z񓯎m̌
	 * @param list	񎟌z̃Xg
	 * @return	Xgzɕϊ
	 */
	public static String[][] combineArray(List<String[][]> list) {
		String[][] result = new String[0][2];
		for (String[][] array : list) {
			result = combineArray(result, array);
		}
		return result.clone();
	}
	
	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public static String[][] getExistenceArray() {
		return getFlagArray(CommonConst.NAM_COMMON_NASI, CommonConst.NAM_COMMON_ARI);
	}
	
	/**
	 * L^Xg
	 * @return [0]cA[1]cL
	 */
	public static String[][] getExistenceShortArray() {
		return getFlagArray(CommonConst.NAM_MISSING_INPUT_OFF_OPT, CommonConst.NAM_MISSING_INPUT_ON);
	}
	
	/**
	 * z`FbN
	 * @param ary1		Ώ۔zP
	 * @param ary2		Ώ۔zQ
	 * @return
	 * <p>
	 * z񂪈ꏏłtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean checkArraysEquals(String[] ary1, String[] ary2) {
		if (Arrays.equals(ary1, ary2)) {
			return true;
		}
		return false;
	}
	
	/**
	 * ꎟzList
	 * @param array		ꎟz
	 * @return	List
	 */
	public static List<String> arrayToList(String[] array) {
		List<String> list = new ArrayList<String>();
		for (String element : array) {
			list.add(element);
		}
		return list;
	}
	
	/**
	 * Listꎟz
	 * @param list	̃Xg
	 * @return	ꎟz
	 */
	public static String[] listToArray(List<String> list) {
		return list.toArray(new String[list.size()]);
	}
	
	/**
	 * z񁨃J}؂̕
	 * @param array		Ώۈꎟz
	 * @return	J}؂̕
	 */
	public static String convArrayToFormattedByComma(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i != array.length - 1) {
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
			}
		}
		return sb.toString();
	}
	
	/**
	 * z񎟌ϊ
	 * @param ary1D		ϊꎟz
	 * @return	ϊ񎟌z
	 */
	public static String[][] convArrayDimension(String[] ary1D) {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		if (ary1D != null) {
			array[0][0] = ary1D[0];
			array[0][1] = ary1D[1];
		}
		return array;
	}
	
	/**
	 * z񎟌ϊ
	 * @param ary2D		ϊ񎟌z
	 * @return	ϊꎟz
	 */
	public static String[] convArrayDimension(String[][] ary2D) {
		String[] array = new String[2];
		array[0] = "";
		array[1] = "";
		if (ary2D != null) {
			array[0] = ary2D[0][0];
			array[1] = ary2D[0][1];
		}
		return array;
	}
	
	/**
	 * ꎟz񐶐
	 * @param str1		ΏۗvfP
	 * @param str2		ΏۗvfQ
	 * @return@z
	 */
	public static String[] createArray(String str1, String str2) {
		return new String[]{ str1, str2 };
	}
	
	/**
	 * 󔒃v_E擾
	 * @return  󔒃v_Epz
	 */
	public static String[][] getBlankArray() {
		String[][] array = new String[1][2];
		array[0][0] = "";
		array[0][1] = "";
		return array;
	}
	
	/**
	 * 󔒔z񐶐
	 * @param arraySize		z
	 * @return	󔒔z
	 */
	public static String[][] getBlankArray(int arraySize) {
		String[][] array = new String[arraySize][2];
		for (int i = 0; i < array.length; i++) {
			array[i][0] = "";
			array[i][1] = "";
		}
		return array;
	}
	
	/**
	 * 󔒔z񐶐iꎟj
	 * @param arraySize	z
	 * @return	󔒔ziꎟj
	 */
	public static String[] getBlankArrayOneDimension(int arraySize) {
		String[] array = new String[arraySize];
		for (int i = 0; i < array.length; i++) {
			array[i] = "";
		}
		return array;
	}
	
	/**
	 * 󔒔z񐶐i񎟌j
	 * @param arraySize		ez
	 * @param childSize 	qz
	 * @return	󔒔zi񎟌j
	 */
	public static String[][] getBlankArray(int arraySize, int childSize) {
		String[][] array = new String[arraySize][childSize];
		for (String[] child : array) {
			for (int i = 0; i < child.length; i++) {
				child[i] = "";
			}
		}
		return array;
	}
	
	/**
	 * ݐE/ސEXg擾
	 * @return ݐE/ސEXg
	 */
	public static String[][] getRetirementFlagArrayAll() {
		// z̍쐬
		return addArrayFirstRowSpace(getRetirementFlagArray());
	}
	
	/**
	 * ݐE/ސEXg擾i󗓖j
	 * @return ݐE/ސEXg
	 */
	public static String[][] getRetirementFlagArray() {
		// z̍쐬
		String[][] aryRetirementFlag = new String[3][2];
		aryRetirementFlag[0][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_OFF);
		aryRetirementFlag[0][1] = CommonConst.NAM_RETIREMENT_OFF;
		aryRetirementFlag[1][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE);
		aryRetirementFlag[1][1] = CommonConst.NAM_RETIREMENT_LEAVE;
		aryRetirementFlag[2][0] = String.valueOf(CommonConst.RETIREMENT_FLAG_ON);
		aryRetirementFlag[2][1] = CommonConst.NAM_RETIREMENT_ON;
		return aryRetirementFlag;
	}
	
	/**
	 * ̎擾
	 * @param code  擾ΏۃR[h
	 * @param array R[hƃR[ĥ܂񂾔z
	 * @return R[h
	 */
	public static String getCodeName(String code, String[][] array) {
		String codeName = code;
		if (array == null) {
			return codeName;
		}
		for (String[] element : array) {
			if (code.equals(element[0])) {
				codeName = element[1];
				break;
			}
		}
		return codeName;
	}
	
	/**
	 * R[h擾
	 * @param name  擾ΏۃR[h
	 * @param array  擾Ώ۔z
	 * @return R[h
	 */
	public static String getCodeValue(String name, String[][] array) {
		String codeValue = name;
		if (array == null) {
			return codeValue;
		}
		for (String[] element : array) {
			if (name.equals(element[1])) {
				codeValue = element[0];
				break;
			}
		}
		return codeValue;
	}
	
	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	public static String[][] getYearArray(int year) {
		String[][] aryYear = new String[3][2];
		aryYear[0][0] = String.valueOf(year - 1);
		aryYear[0][1] = String.valueOf(year - 1);
		aryYear[1][0] = String.valueOf(year);
		aryYear[1][1] = String.valueOf(year);
		aryYear[2][0] = String.valueOf(year + 1);
		aryYear[2][1] = String.valueOf(year + 1);
		return aryYear;
	}
	
	/**
	 * Nv_E擾
	 * @param year N
	 * @param former ߋ
	 * @param further 
	 * @return Nv_Epz
	 */
	public static String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}
	
	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public static String[][] getMonthArray() {
		String[][] aryMonth = new String[12][2];
		for (int i = 0; i < 12; i++) {
			aryMonth[i][0] = String.valueOf(i + 1);
			aryMonth[i][1] = String.valueOf(i + 1);
		}
		return aryMonth;
	}
	
	/**
	 * v_E擾
	 * @return v_Epz
	 */
	public static String[][] getDayArray() {
		final int days = 31;
		String[][] aryDay = new String[days][2];
		for (int i = 0; i < days; i++) {
			aryDay[i][0] = String.valueOf(i + 1);
			aryDay[i][1] = String.valueOf(i + 1);
		}
		return aryDay;
	}
	
	/**
	 * ԃv_E擾
	 * @param hour          Jn
	 * @param minute        Jn
	 * @param count         f[^
	 * @param interval      f[^Ԋu()
	 * @param isValueMinute ݒtO(trueFvalue͕PʁAfalseFvalue͎ԕ)
	 * @return ԃv_Epz
	 */
	public static String[][] getTimeArray(int hour, int minute, int count, int interval, boolean isValueMinute) {
		String[][] aryTime = new String[count][2];
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, hour);
		cal.set(Calendar.MINUTE, minute);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		for (int i = 0; i < count; i++) {
			if (isValueMinute) {
				aryTime[i][0] = String.valueOf(cal.get(Calendar.HOUR_OF_DAY) * 60 + cal.get(Calendar.MINUTE));
			} else {
				aryTime[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			}
			aryTime[i][1] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_TIME_SHORT);
			cal.add(Calendar.MINUTE, interval);
		}
		return aryTime;
	}
	
	/**
	 * lv_E擾
	 * @param start		Jnl
	 * @param end		Il
	 * @param interval	Ԋu
	 * @return lv_Epz
	 */
	public static String[][] getCountArray(int start, int end, int interval) {
		int count = (end - start) / interval + 1;
		int value = start;
		String[][] aryCount = new String[count][2];
		for (int i = 0; i < count; i++) {
			aryCount[i][0] = String.valueOf(value);
			aryCount[i][1] = String.valueOf(value);
			value += interval;
		}
		return aryCount;
	}
	
	/**
	 * v_Es
	 * @param target Ώۃv_Ez
	 * @param value Ώۍsl
	 * @return v_E
	 */
	public static String[][] removeArrayRow(String[][] target, String value) {
		int count = target.length;
		for (String[] element : target) {
			if (element[0].equals(value)) {
				--count;
			}
		}
		String[][] aryNew = new String[count][2];
		count = 0;
		for (String[] element : target) {
			if (element[0].equals(value)) {
				continue;
			}
			aryNew[count][0] = element[0];
			aryNew[count][1] = element[1];
			++count;
		}
		return aryNew;
	}
	
	/**
	 * v_E̐擪sɋ󔒂ǉ
	 * @param target Ώۃv_Ez
	 * @return ǉv_E
	 */
	public static String[][] addArrayFirstRowSpace(String[][] target) {
		return addArrayFirstRowValue(target, "", "");
	}
	
	/**
	 * v_E̐擪sɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public static String[][] addArrayFirstRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == 0) {
				aryNew[0][0] = code;
				aryNew[0][1] = value;
			} else {
				aryNew[i][0] = target[i - 1][0];
				aryNew[i][1] = target[i - 1][1];
			}
		}
		return aryNew;
	}
	
	/**
	 * v_E̍ŏIsɔCӂ̒lǉ
	 * @param target Ώۃv_Ez
	 * @param code ΏۍsR[h
	 * @param value Ώۍs\l
	 * @return aryNew	z
	 */
	public static String[][] addArrayLastRowValue(String[][] target, String code, String value) {
		String[][] aryNew = new String[target.length + 1][2];
		for (int i = 0; i < aryNew.length; i++) {
			if (i == aryNew.length - 1) {
				aryNew[i][0] = code;
				aryNew[i][1] = value;
			} else {
				aryNew[i][0] = target[i][0];
				aryNew[i][1] = target[i][1];
			}
		}
		return aryNew;
	}
	
	/*		֘A	*/

	/**
	 * StringNullA`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0̏ꍇtrueAłȂꍇfalse</p>
	 */
	public static boolean isNull(String str) {
		try {
			if (str == null || str.length() == 0) {
				return true;
			}
		} catch (NullPointerException e) {
			return true;
		}
		return false;
	}
	
	/**
	 * StringNotNull`FbN
	 * @param str		ΏString
	 * @return
	 * <p>Null͒0ȊȌꍇtrueAłȂꍇfalse</p>
	 */
	public static boolean isNotNull(String str) {
		return !isNull(str);
	}
	
	/**
	 * s\
	 * @param aStr sΏە
	 * @return s㕶
	 */
	public static String brHTML(String aStr) {
		char c;
		String strTarget = aStr != null ? aStr : "";
		StringBuffer returnStr = new StringBuffer();
		int length = strTarget.length();
		for (int i = 0; i < length; i++) {
			c = strTarget.charAt(i);
			if (c == '\n') {
				returnStr = returnStr.append("<br>");
			} else if (c == '<') {
				returnStr = returnStr.append("&lt;");
			} else if (c == '>') {
				returnStr = returnStr.append("&gt;");
			} else if (c == '&') {
				returnStr = returnStr.append("&amp;");
			} else if (c == '"') {
				returnStr = returnStr.append("&quot;");
			} else if (c == '\'') {
				returnStr = returnStr.append("&#39;");
			} else {
				returnStr = returnStr.append(c);
			}
		}
		return new String(returnStr);
	}
	
	/**
	 * [t̐琮֕ϊ
	 * @param number [t
	 * @return 
	 */
	public static String removeZero(String number) {
		return String.valueOf(Integer.parseInt(number));
	}
	
	/**
	 * [t̐֕ϊ
	 * @param number	
	 * @return String	i0~9ji00~09j
	 */
	public static String addZero(int number) {
		StringBuffer sb = new StringBuffer();
		if (number < 10) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}
	
	/**
	 * [t̐֕ϊ
	 * @param number	
	 * @return String	i0~9ji00~09j
	 */
	public static String addZero(String number) {
		StringBuffer sb = new StringBuffer();
		if (number.length() < 2) {
			sb.append(CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		}
		sb.append(number);
		return sb.toString();
	}
	
	/**
	 * X֔ԍ
	 * @param	code X֔ԍ
	 * @return O3
	 */
	public static String divideYubinCodeForward(String code) {
		return getIndexValue(code, CommonConst.STR_SEPARATOR, 0);
	}
	
	/**
	 * X֔ԍ
	 * @param	code X֔ԍ
	 * @return 4
	 */
	public static String divideYubinCodeBackward(String code) {
		return getIndexValue(code, CommonConst.STR_SEPARATOR, 1);
	}
	
	/**
	 * w蕶
	 * @param code Ώە
	 * @param sep 
	 * @return 	z
	 */
	public static String[] divide(String code, String sep) {
		String[] base = code.split(sep);
		String[] array = getBlankArrayOneDimension(base.length);
		int i = 0;
		for (String string : base) {
			array[i] = string;
			i++;
		}
		return array;
	}
	
	/**
	 * w蕶
	 * @param code Ώە
	 * @param sep 
	 * @param count 
	 * @return 	z
	 */
	public static String[] divide(String code, String sep, int count) {
		String[] base = code.split(sep);
		String[] array = getBlankArrayOneDimension(count + 1);
		int i = 0;
		for (String string : base) {
			array[i] = string;
			i++;
		}
		return array;
	}
	
	/**
	 * w蕶
	 * @param array		Ώ۔z
	 * @param sep 
	 * @return	string	
	 */
	public static String combine(String[] array, String sep) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			sb.append(array[i]);
			if (i < array.length - 1) {
				sb.append(sep);
			}
		}
		return sb.toString();
	}
	
	/**
	 * w蕶
	 * @param front O
	 * @param behind 
	 * @param sep 
	 * @return 
	 */
	public static String combine(Object front, Object behind, String sep) {
		return String.valueOf(front) + sep + String.valueOf(behind);
	}
	
	/**
	 * nCt
	 * @param code Ώۃf[^
	 * @param hyphen nCt
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public static String[] divideByHyphen(String code, int hyphen) {
		return divide(code, CommonConst.STR_SEPARATOR, hyphen);
	}
	
	/**
	 * nCt
	 * @param code Ώۃf[^
	 * @return z<br>
	 * nCtƃnCt̊ԂɉꍇA
	 * zɁu""vB<br>
	 * nCtŕ񂪏IꍇAnCt̑O̕܂łA
	 * zɂB
	 */
	public static String[] divideByHyphen(String code) {
		return divide(code, CommonConst.STR_SEPARATOR);
	}
	
	/**
	 * nCt
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	public static String combineByHyphen(String[] array) {
		return combine(array, CommonConst.STR_SEPARATOR);
	}
	
	/**
	 * nCt
	 * @param front O
	 * @param behind 
	 * @return 
	 */
	public static String combineByHyphen(Object front, Object behind) {
		return combine(front, behind, CommonConst.STR_SEPARATOR);
	}
	
	/**
	 * J}
	 * @param code Ώۃf[^
	 * @param comma J}
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 * 
	 */
	public static String[] divideByComma(String code, int comma) {
		return divide(code, CommonConst.STR_UNDER_SEPARATOR, comma);
	}
	
	/**
	 * J}
	 * @param code Ώۃf[^
	 * @return z<br>
	 * J}ƃJ}̊ԂɉꍇA
	 * zɁu""vB
	 */
	public static String[] divideByComma(String code) {
		return divide(code, CommonConst.STR_UNDER_SEPARATOR);
	}
	
	/**
	 * J}
	 * @param array		Ώ۔z
	 * @return	string	
	 */
	public static String combineByComma(String[] array) {
		return combine(array, CommonConst.STR_UNDER_SEPARATOR);
	}
	
	/**
	 * J}
	 * @param front O
	 * @param behind 
	 * @return 
	 */
	public static String combineByComma(Object front, Object behind) {
		return combine(front, behind, CommonConst.STR_UNDER_SEPARATOR);
	}
	
	/**
	 * XbV
	 * @param code		ΏۃR[h
	 * @return@z
	 */
	public static String[] divideBySlash(String code) {
		return divide(code, CommonConst.STR_SLASH_SEPARATOR);
	}
	
	/**
	 * XbV
	 * @param code		ΏۃR[h
	 * @param slash		XbV
	 * @return@z
	 */
	public static String[] divideBySlash(String code, int slash) {
		return divide(code, CommonConst.STR_SLASH_SEPARATOR, slash);
	}
	
	/**
	 * XbV
	 * @param front O
	 * @param behind 
	 * @return 
	 */
	public static String combineBySlash(Object front, Object behind) {
		return combine(front, behind, CommonConst.STR_SLASH_SEPARATOR);
	}
	
	/**
	 * R[hwӏ̕擾
	 * @param code Ώە
	 * @param sep 
	 * @param index CfbNX
	 * @return 擾Ώە
	 */
	public static String getIndexValue(String code, String sep, int index) {
		String[] array = divide(code, sep);
		int i = 0;
		for (String string : array) {
			if (i == index) {
				return string;
			}
			i++;
		}
		return "";
	}
	
	/**
	 * nullɏlZbg
	 * @param obj	ΏObject
	 * @param init	l
	 * @return	string ϊ
	 */
	public static String convNullToInitialValue(Object obj, String init) {
		if (obj == null) {
			return init;
		}
		return (String)obj;
	}
	
	/**
	 * 𕪊
	 * @param sspl1		Ώە
	 * @param sspl2		܂܂镶
	 * @param sspl3		OtO
	 * @return	sspl30̏ꍇAOȊȌꍇo
	 */
	public static String splitStrings(String sspl1, String sspl2, int sspl3) {
		if (sspl1.length() > 0) {
			if (sspl1.indexOf(sspl2) != -1) {
				// oӏ
				int i = sspl1.indexOf(sspl2);
				if (sspl3 == 0) {
					return sspl1.substring(0, i);
				} else {
					return sspl1.substring(i + 1, sspl1.length());
				}
			} else {
				return sspl1;
			}
		} else {
			return "";
		}
	}
	
	/**
	 * 𔼊pJi֓
	 * @param input		Ώۉ
	 * @return	pJiϊ㕶
	 */
	public static String toHankakuKana(String input) {
		return KanaConvertUtility.convZenkakuToHankaku(KanaConvertUtility.convHiraGanaToHankaku(input));
	}
	
	/**
	 * SpXy[X𔼊pXy[X֕ϊ
	 * @param input		SpXy[X܂܂镶
	 * @return	SpXy[X𔼊pXy[X֕ϊ̕
	 */
	public static String to1byteSpace(String input) {
		StringBuffer sb = new StringBuffer();
		String[] aryInput = input.split("@");
		for (int i = 0; i < aryInput.length; i++) {
			sb.append(aryInput[i]);
			if (i != aryInput.length - 1) {
				sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
		}
		return sb.toString();
	}
	
	/*	tOϊ	*/

	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @param falseflag falseԂ
	 * @return  ǂłȂꍇfalse
	 */
	public static boolean convFlagToBoolean(String target, String trueflag, String falseflag) {
		if (target.equals(trueflag)) {
			return true;
		} else if (target.equals(falseflag)) {
			return false;
		}
		return false;
	}
	
	/**
	 * tOϊiStringbooleanj
	 * @param target ΏString
	 * @param trueflag trueԂ
	 * @return 
	 */
	public static boolean convFlagToBoolean(String target, String trueflag) {
		if (target.equals(trueflag)) {
			return true;
		}
		return false;
	}
	
	/**
	 * tOϊiintbooleanj
	 * @param target Ώint
	 * @param trueflag trueԂ
	 * @return 
	 */
	public static boolean convFlagToBoolean(int target, int trueflag) {
		if (target == trueflag) {
			return true;
		}
		return false;
	}
	
	/**
	 * tOϊibooleanStringj
	 * @param isTrue 	truȅꍇString
	 * @param isFalse	falsȅꍇString
	 * @param flag 		true or false
	 * @return	String 	ʖ
	 */
	public static String convFlagToString(String isTrue, String isFalse, boolean flag) {
		if (flag) {
			return isTrue;
		}
		return isFalse;
	}
	
	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truec{@link CommonConst#NAM_COMMON_FLAG_OFF}Afalsec{@link CommonConst#NAM_COMMON_FLAG_ON}
	 */
	public static String convTrueIsOff(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_OFF;
		}
		return CommonConst.NAM_COMMON_FLAG_ON;
	}
	
	/**
	 * tOϊibooleanStringj
	 * @param flag 	true or false
	 * @return truec{@link CommonConst#NAM_COMMON_FLAG_ON}Afalsec{@link CommonConst#NAM_COMMON_FLAG_OFF}
	 */
	public static String convTrueIsOn(boolean flag) {
		if (flag) {
			return CommonConst.NAM_COMMON_FLAG_ON;
		}
		return CommonConst.NAM_COMMON_FLAG_OFF;
	}
	
	/**
	 * Lŕ͂
	 * @since	0.0.2
	 * @param value		Ώە
	 * @param leftMark	̋L
	 * @param rightMark	E̋L
	 * @return	ϊ㕶
	 */
	public static String surroundMarks(String value, String leftMark, String rightMark) {
		StringBuffer sb = new StringBuffer();
		sb.append(leftMark);
		sb.append(value);
		sb.append(rightMark);
		return sb.toString();
	}
	
	/**
	 * ʂŕ͂
	 * @since	0.0.2
	 * @param value	Ώە
	 * @return	(value)
	 */
	public static String surroundRoundBracket(String value) {
		return surroundMarks(value, CommonConst.NAM_ROUND_BRACKETS_LEFT, CommonConst.NAM_ROUND_BRACKETS_RIGHT);
	}
	
	/**
	 * ʂŕ͂
	 * @since	0.0.2
	 * @param value	Ώە
	 * @return	yvaluez
	 */
	public static String surroundBracket(String value) {
		return surroundMarks(value, CommonConst.BRACKET_LEFT, CommonConst.BRACKET_RIGHT);
	}
	
	/**
	 * w蕶񒷂̏I_O_[_֕ϊ
	 * @param input ͕
	 * @param outputLength o͕
	 * @return o͕񒷂܂ł̕{c
	 */
	public static String changeTerminal(String input, int outputLength) {
		int size = input.length();
		StringBuffer sb = new StringBuffer();
		if (size > outputLength) {
			sb.append(input.substring(0, outputLength - 1));
			sb.append(CommonConst.STR_ELLIPSIS);
		} else {
			sb.append(input);
		}
		return sb.toString();
	}
	
	/**
	 * @param code ΏۃR[h
	 * @return
	 * <p>
	 * ΏۃR[h{@link CommonConst#NAM_COMMON_FLAG_ON}̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isFlagOn(String code) {
		return CommonConst.NAM_COMMON_FLAG_ON.equals(code);
	}
	
	/**
	 * @param code ΏۃR[h
	 * @return
	 * <p>
	 * ΏۃR[h{@link CommonConst#NAM_COMMON_FLAG_OFF}̏ꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isFlagOff(String code) {
		return CommonConst.NAM_COMMON_FLAG_OFF.equals(code);
	}
	
	/**
	 * tOpz̐
	 * @param flagOffName {@link CommonConst#NAM_COMMON_FLAG_OFF}̖
	 * @param flagOnName {@link CommonConst#NAM_COMMON_FLAG_ON}̖
	 * @return
	 * <p>
	 * [0]c{@link CommonConst#NAM_COMMON_FLAG_OFF}A<br>
	 * [1]c{@link CommonConst#NAM_COMMON_FLAG_ON}A
	 * </p>
	 */
	public static String[][] getFlagArray(String flagOffName, String flagOnName) {
		String[][] aryFlag = getBlankArray(2);
		aryFlag[0][0] = CommonConst.NAM_COMMON_FLAG_OFF;
		aryFlag[0][1] = convNullToInitialValue(flagOffName, "");
		aryFlag[1][0] = CommonConst.NAM_COMMON_FLAG_ON;
		aryFlag[1][1] = convNullToInitialValue(flagOnName, "");
		return aryFlag;
	}
	
}
