/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Date;
import java.util.Map;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.dto.MYukyuDto;
import jp.mosp.kintai.vo.PaidHolidayCardVo;

/**
 * @author yoshida
 *
 */
public class PaidHolidayCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_YUKYU_PERSONAL_SHOW	= "K1300";	// \
																	
	
	/**
	 * RXgN^
	 */
	public PaidHolidayCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_YUKYU_PERSONAL_SHOW)) {
			// \
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new PaidHolidayCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U[擾  ЈR[hێ
		getInfo(user.getUserId());
	}
	
	@Override
	protected void show() throws Exception {
		PaidHolidayCardVo vo = (PaidHolidayCardVo)getVo();
		vo.setDefaultValues();
		// Ώ۔N擾
		Date calcPayment = getCalcPayment();
		// Ώ۔N̏FEF쐬
		double[] number = makeApprovalYukyuNumber(calcPayment);
		// Ώ۔N̒ǉEp\쐬
		makeAddAndDispose(calcPayment, number[0]);
		// VOɏݒ
		vo.setLblApproved(String.valueOf(number[0]));
		vo.setLblRemainApproved(String.valueOf(number[1]));
		// VOɏݒ
		vo.setLblAttendanceCalcY(String.valueOf(MospUtility.getYear(calcPayment)));
		vo.setLblAttendanceCalcM(String.valueOf(MospUtility.getMonth(calcPayment)));
	}
	
	/**
	 * LxFEF쐬
	 * @param targetDate	Ώ۔N
	 * @return [0]cFς݌A[1]cF
	 * @throws Exception 	Oꍇ
	 */
	private double[] makeApprovalYukyuNumber(Date targetDate) throws Exception {
		// ΑӏWvΏی̏oΕ̎擾
		getAttendanceList(userBasis.getKCode(), getCalcMonth());
		// z񏉊
		double[] number = { 0.0, 0.0 };
		// oΕWvf[^
		for (MSyukkinboDto dto : attendanceList) {
			// Lxx
			if (KintaiCommonPart.isAllHoliday(dto)) {
				// FAF
				if (KintaiApprovalPart.is2ndApproved(dto)) {
					number[0]++;
				} else {
					number[1]++;
				}
			} else if (KintaiCommonPart.isHalfHoliday(dto)) {
				// x
				final double halfDays = 0.5;
				// FAF
				if (KintaiApprovalPart.is2ndApproved(dto)) {
					number[0] += halfDays;
				} else {
					number[1] += halfDays;
				}
			}
		}
		return number;
	}
	
	/**
	 * LxǉEp쐬
	 * @param calcPayment	^x
	 * @param useDays Ώ۔N̏F쐬
	 * @throws Exception	Oꍇ
	 */
	private void makeAddAndDispose(Date calcPayment, double useDays) throws Exception {
		PaidHolidayCardVo vo = (PaidHolidayCardVo)getVo();
		// O̗L񌟍
		MYukyuDto formerDto = part().paidHoliday().getYukyuInfo(userBasis.getKCode(),
				DateUtil.addMonth(calcPayment, -1));
		if (!chkExistDto(formerDto)) {
			formerDto = new MYukyuDto();
		}
		// JztO
		boolean isCarryForward = part().mospcode().getCarriedForwardMonth() == MospUtility.getMonth(calcPayment);
		// x
		int payment = 0;
		if (isCarryForward) {
			payment = part().paidHoliday().getCarryForwardSupplyDays(userBasis.getKCode());
		}
		// OciONxj
		double lastRemainDays = formerDto.getTZanZ();
		// OciNxj
		double remainDays = formerDto.getTZanT();
		// Jzʎ擾
		Map<String, Double> map = part().paidHoliday().getOldCarryForwardInfo(lastRemainDays, remainDays, useDays,
				payment, isCarryForward);
		// j
		double waste = PaidHolidayPart.getMapWasteDays(map);
		// Lx\萔iNxj
		double remainThisThis = PaidHolidayPart.getMapRemainDays(map);
		// Lx\萔iONxj
		double remainThisPrev = PaidHolidayPart.getMapLastRemainDays(map);
		// VOɏݒ
		vo.setLblThisMGet(String.valueOf(payment));
		vo.setLblThisMDispose(String.valueOf(waste));
		vo.setLblThisMRestLY(String.valueOf(remainThisPrev));
		vo.setLblThisMRestTY(String.valueOf(remainThisThis));
		vo.setLblPaidHolidayLY(String.valueOf(lastRemainDays));
		vo.setLblPaidHolidayTY(String.valueOf(remainDays));
	}
	
}
