/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.LaborAgreementPart;
import jp.mosp.kintai.vo.ScheduleInputCardVo;

/**
 * @author yoshida
 *
 */
public class ScheduleInputCardAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_INPUT_CARD_SHOW		= "K1220";
	private static final String	CMD_INPUT_CARD_SELECT	= "K1221";
	private static final String	CMD_INPUT_CARD_REGIST	= "K1223";
	

	/**
	 * RXgN^
	 */
	public ScheduleInputCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_INPUT_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_INPUT_CARD_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_INPUT_CARD_REGIST)) {
			// o^
			regist();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ScheduleInputCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		ScheduleInputCardVo vo = (ScheduleInputCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_ẼZbg
		// JnÑv_E
		vo.aryPltScheduleYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 0, 1);
		vo.aryPltScheduleMonth = StringUtil.getMonthArray();
		vo.aryPltScheduleDay = StringUtil.getDayArray();
		// v_E̔z
		vo.aryPltDays = StringUtil.getDayArray();
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// Ζ`
		vo.aryPltWorkType = part().worktype().getWorkTypeInfoArray();
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.aryPltWorkType.length == 0) {
			vo.setMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		// j[{^ݒ
		setScheduleMenuButton();
	}
	
	@Override
	protected void show() throws Exception {
		ScheduleInputCardVo vo = (ScheduleInputCardVo)getVo();
		// Ώ۔N擾
		Date todayDate = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltScheduleDay(String.valueOf(MospUtility.getDay(todayDate)));
		// Ώۓݒ
		vo.setPltRotationDays("1");
		/*						
		 *  	2008/11/14	m.yoshida	I\
		 */
		// ΏێЈݒ
		vo.setSelectKCode(userBasis.getKCode());
		// I̐ݒ
		setLabelBasisInfo(userBasis);
		// Ζp^[v_E
		vo.aryPltRotation = part().rotation().getRotationArray(vo.getSelectKCode());
	}
	
	@Override
	protected void select() throws Exception {
		ScheduleInputCardVo vo = (ScheduleInputCardVo)getVo();
		vo.setParams(request);
		// Ώ۔N擾
		Date todayDate = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltScheduleDay(String.valueOf(MospUtility.getDay(todayDate)));
		// Ώۓݒ
		vo.setPltRotationDays("1");
		/*						
		 *  	2008/11/14	m.yoshida	I\
		 */
		// I̐ݒ
		setLabelBasisInfo(part().human().getBasisInfo(vo.getSelectKCode()));
		// Ζp^[v_E
		vo.aryPltRotation = part().rotation().getRotationArray(vo.getSelectKCode());
	}
	
	/**
	 * o^
	 * @throws Exception	Oꍇ
	 */
	private void regist() throws Exception {
		ScheduleInputCardVo vo = (ScheduleInputCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// JnEI
		Date startDate;
		Date endDate;
		// ʏTxo^tO
		boolean isWeekHoliday = false;
		// JnEIݒ
		if (StringUtil.isFlagOff(vo.getCkbSelectPeriod())) {
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			Date targetDate = DateUtil.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
			startDate = getStartDateForList(targetDate);
			endDate = getEndDateForList(targetDate);
			isWeekHoliday = true;
		} else {
			startDate = DateUtil.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltScheduleDay());
			endDate = DateUtil.addDay(startDate, NumberUtil.getIntParam(vo.getPltRotationDays()) - 1);
		}
		// ֔Ԕf
		boolean isRotation = false;
		if (StringUtil.isFlagOn(vo.getCkbSelectWorkType())) {
			isRotation = true;
		}
		// Αӏݒ
		setCalcParam();
		// XVEo^
		int number = registSchedule(vo.getSelectKCode(), makeScheduleMap(vo.getSelectKCode(), startDate, endDate, vo
			.getPltWorkTypeCode(), isRotation, vo.getPltRotationCode(), isWeekHoliday));
		// R~bg
		commit();
		// \mF֑J
		setNextCmd(ScheduleConfirmListAction.CMD_CONFIRM_LIST_SEARCH);
		// bZ[Wݒ
		setMessage(getMessage(CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(number)));
	}
	
	/**
	 * XPW[Map
	 * @param kCode 			ΏێЈR[h
	 * @param startDate			JnN
	 * @param endDate			IN
	 * @param pltWorkTypeCode	ΏۋΖ`ԃR[h
	 * @param isRotation		֔Ԕf
	 * @param pltRotationCode	Ώۗ֔ԃp^[R[h
	 * @param isWeekHoliday		Txf
	 * @return o^pXPW[Map
	 * @throws Exception	Oꍇ
	 */
	private Map<Date, String> makeScheduleMap(String kCode, Date startDate, Date endDate, String pltWorkTypeCode,
			boolean isRotation, String pltRotationCode, boolean isWeekHoliday) throws Exception {
		Map<Date, String> scheduleMap = new HashMap<Date, String>();
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(startDate);
		// ̐ݒ
		int count = 0;
		while (endDate.compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// Ζp^[̋Ζ`ԂƏjՓtO擾
		boolean isPublicHoliday = true;
		String[] aryRotation = new String[]{ pltWorkTypeCode };
		if (isRotation) {
			isPublicHoliday = part().rotation().getPublicHolidayFlag(pltRotationCode);
			aryRotation = part().rotation().getRotationInfoArray(kCode, pltRotationCode);
		}
		int irotate = 0;
		int max = aryRotation.length - 1;
		// tݒ
		cal.setTime(startDate);
		// Jg擾
		setLaborAgreementInfo(kCode, startDate);
		for (int i = 0; i < count; i++) {
			if (irotate > max) {
				irotate = 0;
			}
			// Ζp^[̃[e[V
			while (StringUtil.isNull(aryRotation[irotate])) {
				irotate++;
				if (irotate > max) {
					irotate = 0;
				}
			}
			// Ζ`ԃR[h
			String workTypeCode = aryRotation[irotate];
			// ֔Ԃ̏ꍇ
			if (isRotation) {
				// jՓtO
				if (isPublicHoliday && part().jpholiday().isPublicHoliday(cal.getTime())) {
					workTypeCode = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
				}
			} else {
				// x
				if (part().laborAgreement().isStandardHoliday(cal.getTime(), agreement)) {
					workTypeCode = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
				}
				// @x
				if (LaborAgreementPart.isOfficialHoliday(cal.getTime(), agreement)) {
					workTypeCode = CommonConst.ATTENDANCE_TYPE_OFFICIAL_HOLIDAY;
				}
			}
			scheduleMap.put(cal.getTime(), workTypeCode);
			irotate++;
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return scheduleMap;
	}
	
}
