/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import java.util.Date;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.CtWorkflowCommentDao;
import jp.mosp.kintai.common.dao.CtWorkflowDao;
import jp.mosp.kintai.common.dto.CtWorkflowCommentDto;
import jp.mosp.kintai.common.dto.CtWorkflowDto;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.common.part.HolidayRequestPart;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.common.part.LaborAgreementPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.common.part.SubstituteHolidayPart;
import jp.mosp.kintai.common.part.WorkflowPart;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;
import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.payroll.dao.KdSubstituteHolidayDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;
import jp.mosp.workflow.dao.AmRouteDao;
import jp.mosp.workflow.dao.AmUnitDao;
import jp.mosp.workflow.dao.AttendanceRouteDao;
import jp.mosp.workflow.dao.CtOvertimeRequestDao;
import jp.mosp.workflow.dao.KtHolidayRequestDao;
import jp.mosp.workflow.dao.PmAttendanceDao;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.dto.KtHolidayRequestDto;

/**
 * @author yoshida
 *
 */
public abstract class MosPWorkflowAction extends AttendanceTotalAction {
	
	/**
	 * FpjbgDAO擾
	 * @return	ςAmUnitDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected AmUnitDao unitDao() throws Exception {
		return part().approval().getAmUnitDao();
	}
	
	/**
	 * Fp[gDAO̎擾
	 * @return	ςAmRouteDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected AmRouteDao routeDao() throws Exception {
		return part().approval().getAmRouteDao();
	}
	
	/**
	 * ΑӏFp[gDAO̎擾
	 * @return	ςAttendanceRouteDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected AttendanceRouteDao atRouteDao() throws Exception {
		return part().kintaiApproval().getAttendanceRouteDao();
	}
	
	/**
	 * ΑӏFp[g}X^DAO̎擾
	 * @return	ςPmAttendanceDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected PmAttendanceDao pmAttendDao() throws Exception {
		return part().kintaiApproval().getPmAttendanceDao();
	}
	
	/**
	 * cƐ\e[uDAO̎擾
	 * @return	ςCtOvertimeRequestDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected CtOvertimeRequestDao overTimeDao() throws Exception {
		return part().overtime().getCtOvertimeRequestDao();
	}
	
	/**
	 * xɐ\e[uDAO̎擾
	 * @return	ςKtHolidayRequestDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected KtHolidayRequestDao holidayDao() throws Exception {
		return part().holidayRequest().getKtHolidayRequestDao();
	}
	
	/**
	 * [Nt[e[uDAO̎擾
	 * @return	ςCtWorkflowDaoCX^X
	 * @throws Exception	Oꍇ
	 */
	protected CtWorkflowDao workflowDao() throws Exception {
		return part().workflow().getCtWorkflowDao();
	}
	
	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception	Oꍇ
	 */
	protected String[][] getCurrentUnitArray() throws Exception {
		return part().approval().getCurrentUnitArray();
	}
	
	/**
	 * p\ΑӏF[gꗗ
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return 󏊑FjbgR[hXg
	 * <p>
	 * [0]cꎟF[gR[h
	 * [1]c񎟏F[gR[h
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected String[] getTargetRouteInfo(String kCode, Date targetDate) throws Exception {
		return part().kintaiApproval().getTargetRouteInfo(kCode, user.getKCode(), targetDate);
	}
	
	/**
	 * ΑӏF
	 * @param kcode			Ώێ
	 * @param targetDate	Ώ۔N(yyyy/MM/dd)
	 * @param reason		FR
	 * @param comment		FRg
	 * @param approver		F
	 * @throws Exception	Oꍇ
	 */
	protected void runDayApprovalProcess(String kcode, String targetDate, String reason, String comment, String approver)
			throws Exception {
		// ̎擾
		MSyukkinboDto dto = kintai().getSyukkinboInfo(kcode, targetDate, true);
		// rmF
		chkExist(dto);
		// Fݒ
		dto.setNinsyo(approver);
		dto.setSnRiyuu(reason);
		dto.setSnComent(comment);
		dto.setSnTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		dto.setUpdtTimes(DateUtil.getDateTime(DateUtil.getNowDate()));
		// F
		syukkinboDao().update(dto);
		// DTO̍Ď擾
		chkUpdate(kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), false));
	}
	
	@Override
	protected void prepareTableLock() throws Exception {
		super.prepareTableLock();
		// Ώۃe[uǉ
		addTargetTable(workflowDao(), true);
		addTargetTable(AmRouteDao.TABLE, false);
	}
	
	/**
	 * [Nt[擾
	 * @param workflow		[Nt[ԍ
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	protected CtWorkflowDto getWorkflowDto(long workflow) throws Exception {
		return workflowDao().findForKey(workflow);
	}
	
	/**
	 * [Nt[擾
	 * @param workflow	Ώۃ[Nt[ԍ
	 * @return (DTO)
	 * @throws Exception	Oꍇ
	 */
	protected CtWorkflowDto getWorkflowDto(String workflow) throws Exception {
		return getWorkflowDto(Long.parseLong(workflow));
	}
	
	/**
	 * F󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵂̐
	 * @throws Exception	Oꍇ
	 */
	protected boolean isStatusRequest(long workflow) throws Exception {
		return part().workflow().isStatusRequest(workflow);
	}
	
	/**
	 * Fςݏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Fςݏ󋵂̐
	 * @throws Exception	Oꍇ
	 */
	protected boolean isStatusApproved(long workflow) throws Exception {
		return part().workflow().isStatusApproved(workflow);
	}
	
	/**
	 * ߏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	ߏ󋵂̐
	 * @throws Exception	Oꍇ
	 */
	protected boolean isStatusReturned(long workflow) throws Exception {
		return part().workflow().isStatusReturned(workflow);
	}
	
	/**
	 * 󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	󋵂̐
	 * @throws Exception	Oꍇ
	 */
	protected boolean isStatusDraft(long workflow) throws Exception {
		return part().workflow().isStatusDraft(workflow);
	}
	
	/**
	 * FΏێ҈ꗗ擾
	 * @param targetDate	Ώ۔N
	 * @return	FΏێ҈ꗗXg
	 * @throws Exception	Oꍇ
	 */
	protected List<MKihonDto> getApprovalEmployeeList(Date targetDate) throws Exception {
		return part().kintaiApproval().getApprovalEmployeeList(userBasis.getKCode(), targetDate);
	}
	
	/**
	 * \o^
	 * <p>
	 * K{@link #unLockTables()}s邱ƁB
	 * </p>
	 * @param kCode		ΏێЈR[h
	 * @param isDraft tO
	 * @return workflow		[Nt[ԍ
	 * @throws Exception	Oꍇ
	 */
	protected long requestRegist(String kCode, boolean isDraft) throws Exception {
		CtWorkflowDto dto = new CtWorkflowDto();
		// ݒ
		if (isDraft) {
			// 
			dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[4]);
		} else {
			// \
			dto.setCurrentStatus(WorkflowPart.getStatusCodeArray()[0]);
		}
		// FKwݒ
		dto.setLayerNumber(0);
		String targetRouteCode = part().kintaiApproval().getRequestRouteCode(kCode);
		dto.setRtCode(targetRouteCode);
		long workflow = 0;
		// e[ubN
		lockTables();
		// [gR[hݒ
		if (StringUtil.isNotNull(targetRouteCode)) {
			String maxNo = workflowDao().findForMax();
			if (StringUtil.isNull(maxNo)) {
				maxNo = "-1";
			}
			// őlZbg
			dto.setWorkflow(Long.parseLong(maxNo) + 1);
			workflowDao().insert(dto);
			workflow = dto.getWorkflow();
		}
		return workflow;
	}
	
	/**
	 * [Nt[XV
	 * @param dto			Ώۃ[Nt[DTO
	 * @return XVłꍇtrueAłȂꍇfalse
	 * @throws Exception	Oꍇ
	 */
	protected boolean workflowUpdate(CtWorkflowDto dto) throws Exception {
		// [gR[hmF
		if (VariousUtil.chkExistDto(routeDao().findForKey(dto.getRtCode()))) {
			chkExclusive(workflowDao().findForUpdate(dto.getWorkflow()), dto);
			workflowDao().update(dto);
			chkUpdate(getWorkflowDto(dto.getWorkflow()));
			return true;
		}
		// G[bZ[W
		addErrMessage(getMessage(CommonConst.MSG_TARGET_NOT_EXIST, CommonConst.NAM_APPROVAL_ROUTE));
		return false;
	}
	
	/**
	 * ߃Rgꗗ
	 * @param target		ΏێЈR[h
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @throws Exception	Oꍇ
	 */
	protected void setReturnedComment(String target, long workflow) throws Exception {
		MosPWorkFlowVo vo = (MosPWorkFlowVo)getVo();
		vo.setCommentFields(part().workflow().getWorkflowCommentArray(target, workflow));
	}
	
	/**
	 * [Nt[Rgo^
	 * @param workflow			[Nt[ԍ
	 * @param kcode				ЈR[h
	 * @param targetKCode		Ώێ
	 * @param comment			Rg
	 * @throws Exception	Oꍇ
	 */
	protected void registComment(long workflow, String kcode, String targetKCode, String comment) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		dto.setWorkflow(workflow);
		dto.setKCode(kcode);
		dto.setTarget(targetKCode);
		dto.setAuthorComment(comment);
		// [Nt[RgpDAO
		CtWorkflowCommentDao dao = part().workflow().getCtWorkflowCommentDao();
		String maxCommentId = dao.findForMax();
		if (StringUtil.isNull(maxCommentId)) {
			maxCommentId = "-1";
		} else {
			dao.findForUpdate(Long.parseLong(maxCommentId));
		}
		// őlZbg
		dto.setCommentId(Long.parseLong(maxCommentId) + 1);
		dao.insert(dto);
		chkInsert(dao.findForKey(dto.getCommentId()));
	}
	
	/**
	 * ŐVΏێЈRg擾
	 * @param kCode			ΏێЈR[h
	 * @param workflow		Ώۃ[Nt[
	 * @return	Rg
	 * @throws MospException	MosPOꍇ
	 * @throws Exception	Oꍇ
	 */
	protected String getCurrentWorkflowComment(String kCode, long workflow) throws Exception {
		CtWorkflowCommentDto dto = part().workflow().getWorkflowCommentForTarget(kCode, workflow);
		if (chkExistDto(dto)) {
			return dto.getAuthorComment();
		}
		return "";
	}
	
	/**
	 * ΑӏFXe[^XR[h擾 
	 * @param workflow			Ώۃ[Nt[ԍ
	 * @return	ΑӏFXe[^XR[h
	 * @throws Exception	Oꍇ
	 */
	protected String toKintaiApprovalStatus(long workflow) throws Exception {
		return part().workflow().toKintaiApprovalStatus(workflow);
	}
	
	/**
	 * ΑӏF󋵖̎擾
	 * @param snRiyuu			ΑӏF󋵃R[h
	 * @return	ΑӏF󋵖
	 * @throws Exception	Oꍇ
	 */
	protected String getApprovalName(String snRiyuu) throws Exception {
		return part().kintaiApproval().getApprovalName(snRiyuu);
	}
	
	/**
	 * Ώ۔NΏۃjbgR[hFҔf
	 * @param unitcode		ΏۃjbgR[h
	 * @param targetDate	Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NFjbgDTOꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean isApprover(String unitcode, Date targetDate) throws Exception {
		return part().approval().isApprover(unitcode, user.getKCode(), targetDate);
	}
	
	/**
	 * cƐ\擾
	 * @param voucher		Ώۓ`[ԍ
	 * @return	cƐ\DTO
	 * @throws Exception	Oꍇ
	 */
	protected CtOvertimeRequestDto getOverTimeRequest(int voucher) throws Exception {
		return overTimeDao().findForKey(voucher);
	}
	
	/**
	 * Ώ۔NcƐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	cƐ\DTO
	 * @throws Exception	Oꍇ
	 */
	protected CtOvertimeRequestDto getOverTimeRequest(String kCode, Date targetDate) throws Exception {
		return part().overtime().getOverTimeRequest(kCode, targetDate);
	}
	
	/**
	 * Ώ۔Nxɐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	xɐ\DTO
	 * @throws Exception	Oꍇ
	 */
	protected KtHolidayRequestDto getHolidayRequest(String kCode, Date targetDate) throws Exception {
		return part().holidayRequest().getHolidayRequest(kCode, targetDate);
	}
	
	/**
	 * \ޔz擾
	 * @return	\ޔz
	 */
	protected String[][] getApplicationArray() {
		return new String[][]{
		// Α
			{ CommonConst.CODE_DAILY_APPROVAL, CommonConst.NAM_DAILY_APPROVAL },
			// cƐ\
			{ CommonConst.CODE_OVER_TIME_REQUEST, CommonConst.NAM_OVER_TIME_REQUEST },
			// xɐ\
			{ CommonConst.CODE_HOLIDAY_REQUEST, CommonConst.NAM_HOLIDAY_REQUEST }, };
	}
	
	/**
	 * cƐ\F
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * cƐ\FłꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runOverTimeRequestApproved(CtOvertimeRequestDto dto) throws Exception {
		return runWorkflowApprovalProcess(dto.getKCode(), dto.getWorkDate(), dto.getWorkflow(),
				CommonConst.NAM_OVER_TIME_REQUEST);
	}
	
	/**
	 * xɐ\F
	 * @param dto		ΏDTO
	 * @return
	 * <p>
	 * xɐ\FłꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runHolidayRequestApproved(KtHolidayRequestDto dto) throws Exception {
		// FꂽꍇAoΕA\̏ύX
		if (VariousUtil.isNotNull(dto)
				&& checkHolidayRequest(dto)
				&& runWorkflowApprovalProcess(dto.getKCode(), dto.getHolidayDate(), dto.getWorkflow(),
						CommonConst.NAM_HOLIDAY_REQUEST)) {
			// xɎԐ\Ɨ\̃}[W
			MScheduleDto scheduleDto = kintai().getScheduleInfo(dto.getKCode(), dto.getHolidayDate());
			margeHolidayRequest(scheduleDto);
			// xɎԐ\ƏoΕ̃}[W
			MSyukkinboDto syukkinboDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHolidayDate());
			margeHolidayRequest(syukkinboDto);
			// o^
			registSchedule(scheduleDto);
			registSyukkinbo(syukkinboDto);
			// ԊOx̏ꍇ
			if (HolidayRequestPart.isSubHoliday(dto) && part().mospcode().useSubstituteHolidayFunction()
					&& WorkflowPart.isLastLayer(workflowDao().findForKey(dto.getWorkflow()))) {
				// p󋵁Ac̏XVB
				registSubstituteInfo(dto);
			}
			return true;
		}
		return false;
	}
	
	/**
	 * \F
	 * @param kCode			ЈR[h
	 * @param targetDate	Ώ۔N
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @param requestName	Ώې\
	 * @return
	 * <p>
	 * \FłꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runWorkflowApprovalProcess(String kCode, Date targetDate, long workflow, String requestName)
			throws Exception {
		return runWorkflowProcess(kCode, targetDate, workflow, requestName, "", true);
	}
	
	/**
	 * \ߏ
	 * @param kCode			ЈR[h
	 * @param targetDate	Ώ۔N
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @param requestName	Ώې\
	 * @param inputComment	߂Rg
	 * @return
	 * <p>
	 * \߂łꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runWorkflowReturnProcess(String kCode, Date targetDate, long workflow, String requestName,
			String inputComment) throws Exception {
		return runWorkflowProcess(kCode, targetDate, workflow, requestName, inputComment, false);
	}
	
	/**
	 * [Nt[
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @param requestName	Ώې\
	 * @param inputComment	̓Rg
	 * @param isApproval	FEߔf
	 * @return
	 * <p>
	 * \łꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runWorkflowProcess(String kCode, Date targetDate, long workflow, String requestName,
			String inputComment, boolean isApproval) throws Exception {
		// [Nt[擾
		CtWorkflowDto dto = workflowDao().findForUpdate(workflow);
		// F[g擾
		String[] aryRouteInfo = getTargetRouteInfo(kCode, targetDate);
		// F
		String status = dto.getCurrentStatus();
		// tO
		boolean canProcess = false;
		if (WorkflowPart.isRequestLayer(dto)) {
			// ꎟ
			if (isApprover(aryRouteInfo[0], targetDate) && WorkflowPart.isRequest(status)) {
				if (isApproval) {
					WorkflowPart.shiftApproved(dto);
				} else {
					WorkflowPart.shiftReturned(dto);
				}
				canProcess = true;
			} else {
				// G[bZ[W
				addDenyApprovalMessage(kCode, targetDate, requestName);
			}
		} else if (WorkflowPart.is1stLayer(dto)) {
			// 
			if (isApprover(aryRouteInfo[1], targetDate) && WorkflowPart.isApproved(status)) {
				if (isApproval) {
					WorkflowPart.shiftLastApproved(dto);
				} else {
					WorkflowPart.shiftLastReturned(dto);
				}
				canProcess = true;
			} else {
				// G[bZ[W
				addDenyApprovalMessage(kCode, targetDate, requestName);
			}
		}
		// ߂̏ꍇ
		if (WorkflowPart.isReturned(status)) {
			// G[bZ[W
			addAlreadyReturnedMessage(kCode, targetDate, requestName);
		}
		// [Nt[
		if (canProcess) {
			if (isApproval) {
				// [Nt[̓o^
				return workflowUpdate(dto);
			} else {
				// [Nt[̍XV
				workflowDao().update(dto);
				chkUpdate(workflowDao().findForKey(dto.getWorkflow()));
				// ߂Rg̓o^
				registComment(dto.getWorkflow(), userBasis.getKCode(), kCode, inputComment);
				return true;
			}
		}
		return false;
	}
	
	/**
	 * ΑӏF
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param comment		FRg
	 * @param isApproval	FtO
	 * @return
	 * <p>
	 * ΑӏFtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception	Oꍇ
	 */
	protected boolean runDailyApprovalProcess(String kCode, Date targetDate, String comment, boolean isApproval)
			throws Exception {
		MSyukkinboDto dto = kintai().getSyukkinboInfo(kCode, targetDate);
		String reason = "";
		// \̏ꍇ
		if (KintaiApprovalPart.isRequest(dto)) {
			reason = CommonConst.NUM_ATTENDANCE_1ST_RETURNED;
			if (isApproval) {
				reason = CommonConst.NUM_ATTENDANCE_1ST_APPROVED;
			}
		} else if (KintaiApprovalPart.is1stApproved(dto)) {
			// ꎟFς݂̏ꍇ
			reason = CommonConst.NUM_ATTENDANCE_2ND_RETURNED;
			if (isApproval) {
				reason = CommonConst.NUM_ATTENDANCE_2ND_APPROVED;
			}
		} else if (KintaiApprovalPart.is1stReturned(dto) || KintaiApprovalPart.is2ndReturned(dto)) {
			// ߂
			// G[bZ[W
			addAlreadyReturnedMessage(kCode, targetDate, CommonConst.NAM_DAILY_APPROVAL);
		} else if (KintaiApprovalPart.is2ndApproved(dto)) {
			// 񎟏Fς
			// G[bZ[W
			addAlreadyApprovedMessage(kCode, targetDate, CommonConst.NAM_DAILY_APPROVAL);
		}
		// FҔf
		if (part().kintaiApproval().isApprover(kCode, userBasis.getKCode(), dto.getSnRiyuu(), targetDate)) {
			// ΑӏF
			runDayApprovalProcess(kCode, DateUtil.convDateFormatted(targetDate), reason, comment, userBasis.getKCode());
			return true;
		} else {
			// G[bZ[W
			addDenyApprovalMessage(kCode, targetDate, CommonConst.NAM_DAILY_APPROVAL);
		}
		return false;
	}
	
	/**
	 * FsbZ[Wo
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param requestName	Ώې\
	 * @throws Exception	Oꍇ
	 */
	protected void addDenyApprovalMessage(String kCode, Date targetDate, String requestName) throws Exception {
		// G[bZ[W
		addErrMessage(getMessage(CommonConst.MSG_CODE_DENY_APPROVAL, getApprovalMessage(kCode, targetDate, requestName,
				true)));
	}
	
	/**
	 * Fς݃bZ[Wo
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param requestName	Ώې\
	 * @throws Exception	Oꍇ
	 */
	protected void addAlreadyApprovedMessage(String kCode, Date targetDate, String requestName) throws Exception {
		// G[bZ[W
		addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_APPROVED, getApprovalMessage(kCode, targetDate,
				requestName, false)));
	}
	
	/**
	 * ߂bZ[Wo
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param requestName	Ώې\
	 * @throws Exception	Oꍇ
	 */
	protected void addAlreadyReturnedMessage(String kCode, Date targetDate, String requestName) throws Exception {
		// G[bZ[W
		addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_RETURNED, getApprovalMessage(kCode, targetDate,
				requestName, false)));
	}
	
	/**
	 * FG[pbZ[W
	 * @param kCode			ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @param requestName	Ώې\
	 * @param isSeparate	bZ[Wf
	 * @return	FG[pbZ[W
	 * @throws Exception 	Oꍇ
	 */
	protected String getApprovalMessage(String kCode, Date targetDate, String requestName, boolean isSeparate)
			throws Exception {
		StringBuffer sb = new StringBuffer();
		sb.append(getKName(kCode));
		sb.append(CommonConst.MSG_OF);
		sb.append(DateUtil.convDateToFormatDateJP(targetDate));
		if (isSeparate) {
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
		} else {
			sb.append(CommonConst.MSG_OF);
		}
		sb.append(requestName);
		return sb.toString();
	}
	
	/**
	 * xɐ\EF̃`FbN
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * xɐ\\܂͏FłꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkHolidayRequest(KtHolidayRequestDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			String kCode = dto.getKCode();
			Date targetDate = dto.getHolidayDate();
			// \̃`FbN
			if (KintaiApprovalPart.isApproved(part().kintai().getSyukkinboInfo(kCode, targetDate))) {
				// G[bZ[W
				addErrMessage(getMessage(CommonConst.MSG_ALREADY_APPROVED, DateUtil
					.convDateFormattedByComma(targetDate)));
				return false;
			}
			// \̏d`FbN
			if (checkHolidayRequestDuplicate(dto)) {
				// Lx̏ꍇ
				if (HolidayRequestPart.isPaidHoliday(dto)) {
					// cAcԂ̃`FbN
					return checkRemainPaidHoliday(dto);
				} else if (HolidayRequestPart.isSubHoliday(dto) && part().mospcode().useSubstituteHolidayFunction()) {
					// 60ԎԊOɂx̏ꍇ
					// x̎c̃`FbN
					return checkRemainSubstitute(dto);
				}
				return true;
			}
		}
		return false;
	}
	
	/**
	 * \̏d`FbN
	 * @param dto ΏDTO
	 * @return \̑̐\ƏdȂꍇtrueAłȂꍇfalseB
	 * @throws Exception  	Oꍇ
	 */
	protected boolean checkHolidayRequestDuplicate(KtHolidayRequestDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			String kCode = dto.getKCode();
			Date targetDate = dto.getHolidayDate();
			// \̏oΕ
			MScheduleDto scheduleDto = part().kintai().getScheduleInfo(kCode, targetDate);
			// \̋xɐ\ꗗ
			List<KtHolidayRequestDto> currentList = part().holidayRequest().getDateRequestList(kCode, targetDate);
			// ̐\Jbg
			HolidayRequestPart.removeSameRequest(dto, currentList);
			// Αӏݒ
			setCalcParam();
			// Lx܂͌60ԎԊOɂx̏ꍇ
			if (HolidayRequestPart.isPaidHoliday(dto) || HolidayRequestPart.isSubHoliday(dto)) {
				// Sx
				if (HolidayRequestPart.isAllHolidayType(dto)) {
					if (currentList.size() == 0) {
						return true;
					} else {
						// G[bZ[W
						addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
							.convDateToFormatDateJPShort(targetDate)));
						return false;
					}
				} else if (HolidayRequestPart.isHalfHolidayType(dto)) {
					// x̐\̏ꍇ
					// \̊mF
					if (VariousUtil.isNull(scheduleDto)) {
						// G[bZ[W
						StringBuffer sb = new StringBuffer();
						sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
						sb.append(getKName(kCode));
						addErrMessage(getMessage("WC2054", sb.toString()));
						return false;
					}
					// ɑ̐\ꍇ
					// V\Ƌ\ŎԂ̏d͂Ȃ
					for (KtHolidayRequestDto currentDto : currentList) {
						if (HolidayRequestPart.isAllHolidayType(currentDto)) {
							// ̐\Sx̏ꍇ
							addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
								.convDateToFormatDateJPShort(targetDate)));
							return false;
						} else if (HolidayRequestPart.isStartHalfHolidayType(currentDto)) {
							// ̐\Ȍꍇ
							if (HolidayRequestPart.isStartHalfHolidayType(dto)) {
								// xɎނ̏ꍇ
								addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
									.convDateToFormatDateJPShort(targetDate)));
								return false;
							}
						} else if (HolidayRequestPart.isQuitHalfHolidayType(currentDto)) {
							// ̐\㔼̏ꍇ
							if (HolidayRequestPart.isQuitHalfHolidayType(dto)) {
								// xɎނ̏ꍇ
								addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
									.convDateToFormatDateJPShort(targetDate)));
								return false;
							}
						} else {
							// ԒPʔNx̎gp
							// ̐\ԒPʔNx̏ꍇ
							if (part().mospcode().useHourPaidHolidayFunction()
									&& HolidayRequestPart.isPaidHolidayTime(currentDto)) {
								// \oΎ
								int scheduleStart = KintaiCommonPart.getWorkStartTime(scheduleDto);
								// \ދΎ
								int scheduleQuit = KintaiCommonPart.getWorkQuitTime(scheduleDto);
								// Ox̐\̏ꍇ
								if (HolidayRequestPart.isStartHalfHolidayType(dto)) {
									scheduleQuit -= halfHoliday;
								}
								// 㔼x̐\̏ꍇ
								if (HolidayRequestPart.isQuitHalfHolidayType(dto)) {
									scheduleStart += halfHoliday;
								}
								// Jn
								int currentStartTime = currentDto.getStartTime();
								// I
								int currentEndTime = currentDto.getEndTime();
								// Ԃ̏d`FbN
								if (TimeUtil.coverPeriod(currentStartTime, currentEndTime, scheduleStart, scheduleQuit)) {
									// G[bZ[W
									addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
										.convDateToFormatDateJPShort(targetDate)));
									return false;
								}
							}
						}
					}
					return true;
				} else if (HolidayRequestPart.isPaidHolidayTime(dto) && part().mospcode().useHourPaidHolidayFunction()) {
					// ԒPʔNx̐\̃`FbN
					// \̊mF
					if (VariousUtil.isNull(scheduleDto)) {
						// G[bZ[W
						StringBuffer sb = new StringBuffer();
						sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
						sb.append(getKName(kCode));
						addErrMessage(getMessage("WC2054", sb.toString()));
						return false;
					}
					int workStart = KintaiCommonPart.getWorkStartTime(scheduleDto);
					int workQuit = KintaiCommonPart.getWorkQuitTime(scheduleDto);
					int requestStart = dto.getStartTime();
					int requestEnd = dto.getEndTime();
					// PʎԂ̊mF
					if (requestEnd - requestStart != TimeUtil.convHourToMinutes(part().mospcode()
						.getHourPaidHolidayUnit())) {
						// G[bZ[W
						StringBuffer sb = new StringBuffer();
						sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
						sb.append(getKName(kCode));
						addErrMessage(getMessage("WC2055", sb.toString()));
						return false;
					}
					// ԓ̐\
					if (requestStart >= workStart && workQuit >= requestEnd) {
						// ɑ̐\ꍇ
						// V\Ƌ\ŎԂ̏d͂Ȃ
						for (KtHolidayRequestDto currentDto : currentList) {
							if (HolidayRequestPart.isAllHolidayType(currentDto)) {
								// ̐\Sx̏ꍇ
								addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
									.convDateToFormatDateJPShort(targetDate)));
								return false;
							} else if (HolidayRequestPart.isHalfHolidayType(currentDto)) {
								int holidayStart = workStart;
								int holidayEnd = workQuit;
								// ̐\Ȍꍇ
								if (HolidayRequestPart.isStartHalfHolidayType(currentDto)) {
									holidayEnd -= halfHoliday;
								} else if (HolidayRequestPart.isQuitHalfHolidayType(currentDto)) {
									// ̐\㔼̏ꍇ
									holidayStart += halfHoliday;
								}
								// Ԃ̏d`FbN
								if (TimeUtil.coverPeriod(holidayStart, holidayEnd, requestStart, requestEnd)) {
									// G[bZ[W
									addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
										.convDateToFormatDateJPShort(targetDate)));
									return false;
								}
							} else if (HolidayRequestPart.isPaidHolidayTime(currentDto)) {
								// ̐\ԒPʔNx̏ꍇ
								// Jn
								int currentStartTime = currentDto.getStartTime();
								// I
								int currentEndTime = currentDto.getEndTime();
								// Ԃ̏d`FbN
								if (TimeUtil.coverPeriod(currentStartTime, currentEndTime, requestStart, requestEnd)) {
									// G[bZ[W
									addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
										.convDateToFormatDateJPShort(targetDate)));
									return false;
								}
							}
						}
					} else {
						// G[bZ[W
						StringBuffer sb = new StringBuffer();
						sb.append(getKName(kCode));
						sb.append(CommonConst.STR_UNDER_SEPARATOR);
						sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
						addErrMessage(getMessage("WC2055", sb.toString()));
						return false;
					}
					return true;
				}
			} else {
				// ̑
				if (currentList.size() != 0) {
					// G[bZ[W
					addErrMessage(getMessage(CommonConst.MSG_CODE_SELECT_ALREADY_INSERT, DateUtil
						.convDateToFormatDateJPShort(targetDate)));
					return false;
				}
				// xɗR̃`FbN
				if (VariousUtil.checkCodeExist(dto.getReason(), aryHolidayReason)) {
					return true;
				}
			}
		}
		return false;
	}
	
	/**
	 * Lx̎cAcԂ̃`FbN
	 * @param dto ΏDTO
	 * @return 
	 * <p>
	 * Lxɐ\̍ہAcEcԏ擾A\EF\ȏꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception   	Oꍇ
	 */
	protected boolean checkRemainPaidHoliday(KtHolidayRequestDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			String kCode = dto.getKCode();
			Date targetDate = dto.getHolidayDate();
			// ͓
			double inputDays = 0;
			// ͎
			int inputHour = 0;
			if (HolidayRequestPart.isPaidHolidayAll(dto)) {
				inputDays++;
			}
			if (HolidayRequestPart.isPaidHolidayHalf(dto)) {
				inputDays = CommonConst.NUM_HALF_DAY;
			}
			if (HolidayRequestPart.isPaidHolidayTime(dto)) {
				inputHour = HolidayRequestPart.getHolidayTime(dto);
			}
			return checkRemainPaidHoliday(kCode, targetDate, inputDays, inputHour);
		}
		return false;
	}
	
	/**
	 * Lx̎cAcԂ̃`FbN
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param inputDays ͓
	 * @param inputHour ͎
	 * @return cEcԏ擾A\EF\ȏꍇtrueAłȂꍇfalseB
	 * @throws Exception   	Oꍇ
	 */
	protected boolean checkRemainPaidHoliday(String kCode, Date targetDate, double inputDays, int inputHour)
			throws Exception {
		// Ώ۔N܂ł̗Lx
		Map<String, Double> map = part().paidHoliday().getTargetPaidHolidayInfoMap(kCode, targetDate);
		// Jg
		setLaborAgreementInfo(kCode, targetDate);
		// J
		int prescribedTime = LaborAgreementPart.getPrescribedTime(agreement);
		if (inputDays > 0 || inputHour > 0) {
			// Lx̎cAcԂ̃`FbN
			if (!PaidHolidayPart.checkRemainInfoMap(PaidHolidayPart.calcRemainMap(inputDays, inputHour, map,
					prescribedTime))) {
				// G[bZ[W
				StringBuffer sb = new StringBuffer();
				sb.append(getKName(kCode));
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
				addErrMessage(getMessage("WC2050", sb.toString()));
			} else {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * ԊOx̎c擾
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return ԊOx̎c
	 * @throws Exception 	Oꍇ
	 */
	protected double getRemainSubstituteHoliday(String kCode, Date targetDate) throws Exception {
		return part().subHoliday().getRemainSubstituteHoliday(kCode, targetDate);
	}
	
	/**
	 * ԊOx̎c̃`FbN
	 * @param dto ΏDTO
	 * @return
	 * <p>
	 * \ec𒴂ȂꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkRemainSubstitute(KtHolidayRequestDto dto) throws Exception {
		if (VariousUtil.isNotNull(dto)) {
			// p
			double useDay = 0;
			// S̏ꍇ
			if (HolidayRequestPart.isSubHolidayAll(dto)) {
				useDay = 1;
			} else if (HolidayRequestPart.isSubHolidayHalf(dto)) {
				// ̏ꍇ
				useDay = CommonConst.NUM_HALF_DAY;
			}
			return checkRemainSubstitute(dto.getKCode(), dto.getHolidayDate(), useDay);
		}
		return false;
	}
	
	/**
	 * ԊOx̎c̃`FbN
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param useDay p
	 * @return
	 * <p>
	 * \ec𒴂ȂꍇtrueAłȂꍇfalseB
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected boolean checkRemainSubstitute(String kCode, Date targetDate, double useDay) throws Exception {
		// x擾\
		double remainDays = getRemainSubstituteHoliday(kCode, targetDate) - useDay;
		if (remainDays < 0) {
			// G[bZ[W
			StringBuffer sb = new StringBuffer();
			sb.append(getKName(kCode));
			sb.append(CommonConst.STR_UNDER_SEPARATOR);
			sb.append(DateUtil.convDateToFormatDateJPShort(targetDate));
			addErrMessage(getMessage("WC2051", sb.toString()));
			return false;
		}
		return true;
	}
	
	private void registSubstituteInfo(KtHolidayRequestDto dto) throws Exception {
		// ЈR[h
		String kCode = dto.getKCode();
		// Ώ۔N
		Date targetDate = dto.getHolidayDate();
		// Jgݒ
		setLaborAgreementInfo(kCode, targetDate);
		// J
		int prescribedTime = LaborAgreementPart.getPrescribedTime(agreement);
		// p
		int useTime = 0;
		if (HolidayRequestPart.isSubHolidayAll(dto)) {
			useTime = prescribedTime;
		}
		if (HolidayRequestPart.isSubHolidayHalf(dto)) {
			useTime = Double.valueOf(prescribedTime / 2d).intValue();
		}
		// DAȌ
		KdSubstituteHolidayDao dao = part().subHoliday().getKdSubstituteHolidayDao();
		// O
		Date oneMonthBefore = DateUtil.addMonth(getCalcAttendanceMonth(targetDate), -1);
		KdSubstituteHolidayDto oneMonthBeforeDto = dao.findForOccurMonth(kCode, MospUtility.getYear(oneMonthBefore),
				MospUtility.getMonth(oneMonthBefore), CommonConst.CODE_ACQUISITION_STATUS_REMAIN,
				CommonConst.CODE_DECISION_STATUS_FIXED);
		// L
		if (part().subHoliday().isPeriodTwoMonths()) {
			// 2̏ꍇ
			// OX
			Date twoMonthBefore = DateUtil.addMonth(getCalcAttendanceMonth(targetDate), -2);
			KdSubstituteHolidayDto twoMonthBeforeDto = dao.findForOccurMonth(kCode,
					MospUtility.getYear(twoMonthBefore), MospUtility.getMonth(twoMonthBefore),
					CommonConst.CODE_ACQUISITION_STATUS_REMAIN, CommonConst.CODE_DECISION_STATUS_FIXED);
			// c
			// OX
			int acquireTwo = 0;
			// OX
			if (VariousUtil.isNotNull(twoMonthBeforeDto)) {
				acquireTwo = twoMonthBeforeDto.getPaymentAcquireTime() + twoMonthBeforeDto.getPaymentAcquireHoliday();
			}
			// p
			int useTimeTwo = 0;
			int useTimeOne = 0;
			if (acquireTwo > 0) {
				useTimeTwo = useTime;
				// OX̋x{𒴉߂ꍇ
				if (acquireTwo - useTime < 0) {
					useTimeTwo = acquireTwo;
					useTimeOne = useTime - acquireTwo;
				}
			} else {
				useTimeOne = useTime;
			}
			// OX
			if (useTimeTwo > 0) {
				dto.setOccurDate2(DateUtil.convDateToStringYearMonthShort(twoMonthBefore));
				dto.setUseTime2(useTimeTwo);
				KdSubstituteHolidayDto twoCurrentDto = dao.findForUpdate(twoMonthBeforeDto.getSubstituteId());
				// pԂZbg
				twoCurrentDto.setUseHolidayTime(twoCurrentDto.getUseHolidayTime() + useTimeTwo);
				// c̊mF
				if (SubstituteHolidayPart.isSubstituteUseFinished(twoCurrentDto)) {
					// g؂ꍇA擾ςݕύXB
					twoCurrentDto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
				}
				// XV
				dao.update(twoCurrentDto);
			}
			// O
			if (useTimeOne > 0) {
				dto.setOccurDate1(DateUtil.convDateToStringYearMonthShort(oneMonthBefore));
				dto.setUseTime1(useTimeOne);
				KdSubstituteHolidayDto oneCurrentDto = dao.findForUpdate(oneMonthBeforeDto.getSubstituteId());
				// pԂZbg
				oneCurrentDto.setUseHolidayTime(oneCurrentDto.getUseHolidayTime() + useTimeOne);
				// c̊mF
				if (SubstituteHolidayPart.isSubstituteUseFinished(oneCurrentDto)) {
					// g؂ꍇA擾ςݕύXB
					oneCurrentDto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
				}
				// XV
				dao.update(oneCurrentDto);
			}
		} else if (part().subHoliday().isPeriodOneMonth()) {
			// 1̏ꍇAO擾
			// pNAԂo^
			dto.setOccurDate1(DateUtil.convDateToStringYearMonthShort(oneMonthBefore));
			dto.setUseTime1(useTime);
			KdSubstituteHolidayDto currentDto = dao.findForUpdate(oneMonthBeforeDto.getSubstituteId());
			// pԂZbg
			currentDto.setUseHolidayTime(currentDto.getUseHolidayTime() + useTime);
			// c̊mF
			if (SubstituteHolidayPart.isSubstituteUseFinished(currentDto)) {
				// g؂ꍇA擾ςݕύXB
				currentDto.setAcquisitionStatus(CommonConst.CODE_ACQUISITION_STATUS_FINISH);
			}
			// XV
			dao.update(currentDto);
		}
		// xɐ\̍XV
		KtHolidayRequestDao requestDao = part().holidayRequest().getKtHolidayRequestDao();
		chkExclusive(dto, requestDao.findForUpdate(dto.getVoucher()));
		requestDao.update(dto);
	}
	
}
