/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.common.part;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.dao.MYukyuDao;
import jp.mosp.kintai.dto.MYukyuDto;
import jp.mosp.kintai.payroll.dao.KdPaidHolidayDao;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;
import jp.mosp.payroll.dto.KintaiCompileDto;
import jp.mosp.workflow.dto.KtHolidayRequestDto;

/**
 * @author yoshida
 *
 */
public class PaidHolidayPart extends KintaiBasePart {
	
	/**
	 * LxǗe[uij
	 */
	public static final String	OLD_TABLE				= MYukyuDao.TABLE;
	/**
	 * LxǗe[uiVj
	 */
	public static final String	NEW_TABLE				= KdPaidHolidayDao.TABLE;
	
	/**
	 * ONxc
	 */
	public static final String	KEY_LAST_REMAIN_DAYS	= "keyLastRemainDays";
	/**
	 * ONxc
	 */
	public static final String	KEY_LAST_REMAIN_HOUR	= "keyLastRemainHour";
	/**
	 * Nxc
	 */
	public static final String	KEY_REMAIN_DAYS			= "keyRemainDays";
	/**
	 * Nxc
	 */
	public static final String	KEY_REMAIN_HOUR			= "keyRemainHour";
	/**
	 * ԒPʂŎ擾\ȓ
	 */
	public static final String	KEY_POSSIBLE			= "keyPossible";
	/**
	 * x
	 */
	public static final String	KEY_SUPPLY_DAYS			= "keySupplyDays";
	/**
	 * x
	 */
	public static final String	KEY_SUPPLY_HOUR			= "keySupplyHour";
	/**
	 * p
	 */
	public static final String	KEY_WASTE_DAYS			= "keyWasteDays";
	/**
	 * p
	 */
	public static final String	KEY_WASTE_HOUR			= "keyWasteHour";
	/**
	 * p
	 */
	public static final String	KEY_USE_DAYS			= "keyUseDays";
	/**
	 * p
	 */
	public static final String	KEY_USE_HOUR			= "keyUseHour";
	/**
	 * ԒPʂŎ擾\ȍői5j
	 */
	public static final int		MAX_POSSIBLE_DAYS		= 5;
	

	/**
	 * RXgN^
	 */
	public PaidHolidayPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	public PaidHolidayPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MYukyuDao	yukyuDao;
	

	/**
	 * @return yukyuDao
	 * @throws MospException  	MosPOꍇ
	 */
	public MYukyuDao getMYukyuDao() throws MospException {
		if (VariousUtil.isNull(yukyuDao)) {
			yukyuDao = (MYukyuDao)getPreparedDao(MYukyuDao.class.getCanonicalName());
		}
		return yukyuDao;
	}
	
	/**
	 * Lxij
	 * @param kCode ЈR[h(L[)
	 * @param targetDate Ώ۔N(yyyyMMdd)
	 * @return	Ώ۔NLx
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public MYukyuDto getYukyuInfo(String kCode, String targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getMYukyuDao().findForKey(kCode, targetDate);
	}
	
	/**
	 * Lxij
	 * @param kCode ЈR[h(L[)
	 * @param targetDate Ώ۔N(yyyyMMdd)
	 * @return	Ώ۔NLx
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public MYukyuDto getYukyuInfo(String kCode, int targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getMYukyuDao().findForKey(kCode, targetDate);
	}
	
	/**
	 * Lxij
	 * @param kCode ЈR[h(L[)
	 * @param targetDate Ώ۔N
	 * @return	Ώ۔NLx
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public MYukyuDto getYukyuInfo(String kCode, Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getYukyuInfo(kCode, DateUtil.convDateToString(targetDate));
	}
	
	/**
	 * Lxij
	 * @param kCode ΏێЈR[h
	 * @param startDate Ώ۔NJn
	 * @param endDate Ώ۔NI
	 * @return Ώ۔NLx
	 * @throws Exception Oꍇ
	 */
	public MYukyuDto getTargetMonthYukyuInfo(String kCode, Date startDate, Date endDate) throws Exception {
		return getMYukyuDao().findForPeriod(kCode, DateUtil.convDateToInteger(startDate),
				DateUtil.convDateToInteger(endDate));
	}
	
	/**
	 * Lxij
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return Ώ۔NɈԋ߂Lx
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public MYukyuDto getNearlyYukyuInfo(String kCode, Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		return getMYukyuDao().findForDateNearly(kCode, DateUtil.convDateToInteger(targetDate));
	}
	
	/**
	 * LxJzij
	 * @param lastRemainDays	ONxc
	 * @param remainDays		Nxc
	 * @param useDays			
	 * @param supply			x
	 * @param isCarryForward	Jzf
	 * @return	Jzʃ}bv
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> getOldCarryForwardInfo(double lastRemainDays, double remainDays, double useDays,
			int supply, boolean isCarryForward) throws Exception {
		// ciONxj
		double dLastRemainDays = lastRemainDays;
		// ciNxj
		double dRemainDays = remainDays;
		// gp
		double use = useDays;
		// j
		double waste = 0;
		// Lx\萔iONxj
		double carryLastRemainDays = 0;
		// Lx\萔iNxj
		double carryRemainDays = 0;
		if (isCarryForward) {
			// Jz敪
			String carriedForwardType = part().mospcode().getCarriedForwardType();
			// Jz敪
			// N̂
			if (StringUtil.isFlagOff(carriedForwardType)) {
				// pXV
				// OXNxjB
				if (dLastRemainDays < use) {
					use = Math.abs(dLastRemainDays - use);
					waste = 0;
				} else {
					waste = dLastRemainDays - use;
					use = 0;
				}
				// OONx𓖌ONxɈړB
				carryLastRemainDays = dRemainDays;
			} else if (StringUtil.isFlagOn(carriedForwardType)) {
				// vŌJz
				// Jz
				int carriedForwardDays = part().mospcode().getCarriedForwardDays();
				// OvČJzJzB
				if ((dLastRemainDays + dRemainDays) >= carriedForwardDays) {
					waste = (dLastRemainDays + dRemainDays) - carriedForwardDays;
				} else {
					waste = 0;
				}
				carryLastRemainDays = dLastRemainDays + dRemainDays - waste;
			}
			carryRemainDays += supply;
			// LXV
			if (use <= carryLastRemainDays) {
				carryLastRemainDays -= use;
			} else {
				// 
				use -= carryLastRemainDays;
				carryLastRemainDays = 0;
				carryRemainDays -= use;
			}
		} else {
			// L擾XV
			carryRemainDays = dRemainDays;
			carryLastRemainDays = dLastRemainDays;
			// LXV
			if (use <= carryLastRemainDays) {
				carryLastRemainDays -= use;
			} else {
				// 
				use -= carryLastRemainDays;
				carryLastRemainDays = 0;
				carryRemainDays -= use;
			}
		}
		return createRemainMap(carryLastRemainDays, 0, carryRemainDays, 0, 0, Double.valueOf(supply), 0, Double
			.valueOf(waste), 0, use, 0);
	}
	
	/**
	 * e[uMAP̏ZbgB
	 * <p>
	 * pAt^ApANxcAONxcZbgB
	 * </p>
	 * @param dto ΏDTO
	 * @param map ΏMAP
	 */
	public static void setMapInfoToOldInfo(MYukyuDto dto, Map<String, Double> map) {
		if (VariousUtil.isNotNull(dto)) {
			dto.setSyoka(getMapUseDays(map));
			dto.setSyutoku(Double.valueOf(getMapSupplyDays(map)).intValue());
			dto.setHaiki(getMapWasteDays(map));
			dto.setTZanT(getMapRemainDays(map));
			dto.setTZanZ(getMapLastRemainDays(map));
		}
	}
	
	/**
	 * e[uMAP̏ɕϊĎ擾B
	 * @param dto ΏDTO
	 * @return  ΏMAP
	 */
	public static Map<String, Double> convOldInfoToMap(MYukyuDto dto) {
		if (VariousUtil.isNotNull(dto)) {
			return createRemainMap(dto.getTZanZ(), 0, dto.getTZanT(), 0, MAX_POSSIBLE_DAYS, dto.getSyutoku(), 0, dto
				.getHaiki(), 0, dto.getSyoka(), 0);
		}
		return null;
	}
	
	/**
	 * Lxɏ񃊃Xg擾
	 * @param kCode			ΏێЈR[h
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<MYukyuDto> getOldYukyuInfoList(String kCode, Date startDate, Date endDate) throws Exception {
		return getMYukyuDao().findForCondition(kCode, DateUtil.convDateToInteger(startDate),
				DateUtil.convDateToInteger(endDate));
	}
	

	/* J@pVe[u */

	private KdPaidHolidayDao	paidHolidayDao;
	

	/**
	 * @return KdPaidHolidayDaoCX^XB
	 * @throws MospException  	MosPOꍇ
	 */
	public KdPaidHolidayDao getPaidHolidayDao() throws MospException {
		if (VariousUtil.isNull(paidHolidayDao)) {
			paidHolidayDao = (KdPaidHolidayDao)getPreparedDao(KdPaidHolidayDao.class.getCanonicalName());
		}
		return paidHolidayDao;
	}
	
	/**
	 * @param kCode ЈR[h
	 * @param targetDate Ώ۔N
	 * @param processType R[h
	 * @return Ώ۔N̗LxǗiVj
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public KdPaidHolidayDto getPaidHolidayInfo(String kCode, Date targetDate, String processType) throws SQLException,
			IllegalAccessException, NoSuchFieldException, MospException {
		return getPaidHolidayDao().findForProcess(kCode, processType, targetDate);
	}
	
	/**
	 * @param kCode  ЈR[h
	 * @param targetDate  Ώ۔N
	 * @param processType R[h
	 * @return  Ώ۔Nɍł߂LxǗiVj
	 * @throws MospException  	MosPOꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws SQLException  SQLOꍇ
	 * 
	 */
	public KdPaidHolidayDto getNearlyPaidHolidayInfo(String kCode, Date targetDate, String processType)
			throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		return getPaidHolidayDao().findForProcessNearlyDate(kCode, processType, targetDate);
	}
	
	/**
	 * cEcԂ̌vZB
	 * @param inputDays 		p
	 * @param inputHour 		p
	 * @param lastRemainDays 	ONxc
	 * @param lastRemainHour 	ONxc
	 * @param remainDays 		Nxc
	 * @param remainHour 		Nxc
	 * @param possible 			ԒPʂŎ擾\ȓ
	 * @param prescribedTime 	Jԁij
	 * @return LxcEcԏiVj
	 */
	public static Map<String, Double> calcRemain(double inputDays, int inputHour, double lastRemainDays,
			int lastRemainHour, double remainDays, int remainHour, int possible, int prescribedTime) {
		int iInputHour = inputHour;
		double dLastRemainDays = lastRemainDays;
		int iLastRemainHour = lastRemainHour;
		double dRemainDays = remainDays;
		int iRemainHour = remainHour;
		int iPossible = possible;
		final int iPrescribedHour = Double.valueOf(Math.ceil(TimeUtil.convMinutesToDoubleHour(prescribedTime)))
			.intValue();
		// 
		double inputAll = Double.valueOf(inputDays).intValue();
		if (dLastRemainDays > 0) {
			if (inputAll > 0) {
				double tmpRemainDay = dLastRemainDays - inputAll;
				if (tmpRemainDay <= 0) {
					dLastRemainDays = 0;
					dRemainDays -= Math.abs(tmpRemainDay);
				} else {
					dLastRemainDays -= inputAll;
				}
			}
		} else {
			dRemainDays -= inputAll;
		}
		// 
		double inputHalf = inputDays % 1;
		if (inputHalf > 0) {
			if (dLastRemainDays > 0) {
				dLastRemainDays -= inputHalf;
			} else {
				dRemainDays -= inputHalf;
			}
		}
		// ԒP
		if (inputHour > 0) {
			// ONxc̈̓
			int iLastRemainDays = Double.valueOf(dLastRemainDays).intValue();
			// JԂ̉񐔁i1ȏj
			int numPrescribed = Double.valueOf(Math.ceil(iInputHour / Double.valueOf(iPrescribedHour))).intValue();
			// ONxc𒴂
			int overLastRemainDays = iLastRemainDays - numPrescribed;
			int absOverLastRemainDays = Math.abs(overLastRemainDays);
			// ONxcԂ𒴂鎞ԁB
			int overLastRemainHour = iLastRemainHour - iInputHour;
			// p\Ԑ痘pԂTB
			iPossible -= inputHour;
			// ONxcԂꍇ
			if (iLastRemainHour > 0) {
				// ONxcԂg؂ꍇ
				if (overLastRemainHour < 0) {
					// ONxc𒴂ꍇ
					if (overLastRemainDays <= 0) {
						// ONxcꍇ
						if (dLastRemainDays > 0) {
							dLastRemainDays = 0;
							iLastRemainHour += iLastRemainDays * iPrescribedHour;
							int tmpLastRemainHour = iLastRemainHour - iInputHour;
							if (tmpLastRemainHour < 0) {
								iLastRemainHour = 0;
								iInputHour = Math.abs(tmpLastRemainHour);
							} else {
								iLastRemainHour -= iInputHour;
								iInputHour = 0;
							}
							if (iInputHour > 0) {
								dRemainDays -= absOverLastRemainDays;
								iRemainHour += absOverLastRemainDays * iPrescribedHour;
								iRemainHour -= iInputHour;
							}
						} else {
							// ONxcȂꍇ
							// ONxc܂T
							iLastRemainHour = 0;
							iInputHour = Math.abs(overLastRemainHour);
							if (numPrescribed > 1) {
								numPrescribed--;
							}
							if (iInputHour > 0) {
								dRemainDays -= numPrescribed;
								iRemainHour += numPrescribed * iPrescribedHour;
								iRemainHour -= iInputHour;
							}
						}
					} else {
						// ONxcꍇ
						if (dLastRemainDays > 0) {
							dLastRemainDays -= numPrescribed;
							iLastRemainHour += numPrescribed * iPrescribedHour;
							iLastRemainHour -= iInputHour;
						} else {
							iLastRemainHour = 0;
							iInputHour = Math.abs(overLastRemainHour);
							dRemainDays--;
							iRemainHour += iPrescribedHour;
							iRemainHour -= iInputHour;
						}
					}
				} else {
					iLastRemainHour -= iInputHour;
				}
			} else {
				if (dLastRemainDays > 0) {
					// ONxccĂꍇ
					if (overLastRemainDays < 0) {
						// ONx𒴉߂ꍇ
						dLastRemainDays = 0;
						iLastRemainHour += iLastRemainDays * iPrescribedHour;
						int tmpLastRemainHour = iLastRemainHour - iInputHour;
						if (tmpLastRemainHour < 0) {
							iLastRemainHour = 0;
							iInputHour = Math.abs(tmpLastRemainHour);
						} else {
							iLastRemainHour -= iInputHour;
							iInputHour = 0;
						}
						if (iInputHour > 0) {
							dRemainDays -= absOverLastRemainDays;
							iRemainHour += absOverLastRemainDays * iPrescribedHour;
							iRemainHour -= iInputHour;
						}
					} else {
						dLastRemainDays -= numPrescribed;
						
						iLastRemainHour += numPrescribed * iPrescribedHour;
						iLastRemainHour -= iInputHour;
					}
				} else {
					int numInputDays = iInputHour / iPrescribedHour;
					int numInputHour = iInputHour % iPrescribedHour;
					int overRemainHour = iRemainHour - iInputHour;
//					int absOverRemainHour = Math.abs(overRemainHour);
					if (overRemainHour < 0) {
//						if (numInputDays > 0 && numInputHour > 0 || numInputHour >= absOverRemainHour) {
//							numInputDays++;
//						}
//						if (iRemainHour - numInputHour > 0) {
//							numInputDays--;
//						}
						if (iRemainHour - numInputHour < 0) {
							numInputDays++;
						}
						dRemainDays -= numInputDays;
						iRemainHour += numInputDays * iPrescribedHour;
						iRemainHour -= iInputHour;
					} else {
						iRemainHour -= iInputHour;
					}
				}
			}
		}
		return createRemainMap(dLastRemainDays, iLastRemainHour, dRemainDays, iRemainHour, iPossible, 0d, 0, 0d, 0,
				inputDays, inputHour);
	}
	
	/**
	 * cEcԂ̌vZB
	 * @param inputDays 		p
	 * @param inputHour 		p
	 * @param map LxcEcԏiVj
	 * @param prescribedTime 	Jԁij
	 * @return LxcEcԏiVj
	 */
	public static Map<String, Double> calcRemainMap(double inputDays, int inputHour, Map<String, Double> map,
			int prescribedTime) {
		return calcRemain(inputDays, inputHour, getMapLastRemainDays(map), getMapLastRemainHour(map),
				getMapRemainDays(map), getMapRemainHour(map), getMapPossible(map), prescribedTime);
	}
	
	/**
	 * JziVj
	 * @param lastRemainDays 	ONxc
	 * @param lastRemainHour 	ONxc
	 * @param remainDays 		Nxc
	 * @param remainHour 		Nxc
	 * @param supplyDays x
	 * @param prescribedTime J
	 * @return	JzLxcEcԏiVj
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> carryForward(double lastRemainDays, int lastRemainHour, double remainDays,
			int remainHour, int supplyDays, int prescribedTime) throws Exception {
		// ciONxj
		double dLastRemainDays = lastRemainDays;
		// cԁiONxj
		int iLastRemainHour = lastRemainHour;
		// ciNxj
		double dRemainDays = remainDays;
		// cԁiNxj
		int iRemainHour = remainHour;
		// p
		double wasteDays = 0;
		// p
		int wasteHour = 0;
		// Lx\萔iONxj
		double carryLastRemainDays = 0;
		// cԁiONxj
		int carryLastRemainHour = 0;
		// Jz敪
		String carriedForwardType = part().mospcode().getCarriedForwardType();
		// J()
		int prescribedHour = Double.valueOf(Math.ceil(TimeUtil.convMinutesToDoubleHour(prescribedTime))).intValue();
		// Jz敪
		// N̂
		if (StringUtil.isFlagOff(carriedForwardType)) {
			// pXV
			wasteDays = dLastRemainDays;
			wasteHour = iLastRemainHour;
			dLastRemainDays = 0;
			iLastRemainHour = 0;
			// NxONxɈړB
			carryLastRemainDays = dRemainDays;
			carryLastRemainHour = iRemainHour;
		} else if (StringUtil.isFlagOn(carriedForwardType)) {
			// vŌJz
			// Jz
			int carriedForwardDays = part().mospcode().getCarriedForwardDays();
			int cfLastRemain = 0;
			int cfRemainHour = 0;
			// ONxc
			if (iLastRemainHour > 0) {
				cfLastRemain++;
			}
			// ONxc
			if (dLastRemainDays % 1 > 0) {
				cfLastRemain++;
			}
			// Nxc
			if (iRemainHour > 0) {
				cfRemainHour++;
			}
			// AcԂ܂߂v
			double totalDays = dLastRemainDays + dRemainDays + cfLastRemain + cfRemainHour;
			double totalWaste = totalDays - carriedForwardDays;
			if (totalWaste < 0) {
				totalWaste = 0;
			}
			// OvČJzJzB
			wasteDays = dLastRemainDays + dRemainDays - carriedForwardDays;
			if (wasteDays < 0) {
				wasteDays = 0;
			}
			// čJz
			if (totalWaste == 0) {
				carryLastRemainDays = dLastRemainDays + dRemainDays;
				carryLastRemainHour = iLastRemainHour + iRemainHour;
			} else {
				carryLastRemainDays = dLastRemainDays + dRemainDays - wasteDays;
				if (cfLastRemain > 0) {
					if (dRemainDays >= carriedForwardDays || cfLastRemain > 1) {
						wasteHour += iLastRemainHour;
					}
					if (cfRemainHour > 0) {
						wasteDays += CommonConst.NUM_HALF_DAY;
						carryLastRemainDays -= CommonConst.NUM_HALF_DAY;
						carryLastRemainHour = iRemainHour;
					}
				}
			}
		}
		// ԒPʂ̉\̐ݒ
		// 
		int iPossible = MAX_POSSIBLE_DAYS * prescribedHour;
		return createRemainMap(carryLastRemainDays, carryLastRemainHour, supplyDays, 0, iPossible, supplyDays, 0,
				wasteDays, wasteHour, 0, 0);
	}
	
	/**
	 * xpDTO̐
	 * @param kCode ΏێЈR[h
	 * @param supplyDate ΏێxN
	 * @param supplyLastDay ONxx
	 * @param supplyLastHour ONxx
	 * @param supplyDay Nxx
	 * @param supplyHour Nxx
	 * @return xpDTO
	 */
	public static KdPaidHolidayDto createSupplyDto(String kCode, Date supplyDate, double supplyLastDay,
			int supplyLastHour, double supplyDay, int supplyHour) {
		KdPaidHolidayDto dto = new KdPaidHolidayDto();
		dto.setKCode(kCode);
		dto.setProcessType(CommonConst.CODE_PROCESS_SUPPLY);
		dto.setProcessDate(supplyDate);
		dto.setLastRemainDays(supplyLastDay);
		dto.setLastRemainHour(supplyLastHour);
		dto.setRemainDays(supplyDay);
		dto.setRemainHour(supplyHour);
		return dto;
	}
	
	/**
	 * ppDTO̐
	 * @param kCode ΏێЈR[h
	 * @param wasteDate Ώ۔pN
	 * @param wasteLastDay ONxp
	 * @param wasteLastHour ONxp
	 * @param wasteDay Nxp
	 * @param wasteHour Nxp
	 * @return ppDTO
	 */
	public static KdPaidHolidayDto createWasteDto(String kCode, Date wasteDate, double wasteLastDay, int wasteLastHour,
			double wasteDay, int wasteHour) {
		KdPaidHolidayDto dto = new KdPaidHolidayDto();
		dto.setKCode(kCode);
		dto.setProcessType(CommonConst.CODE_PROCESS_WASTE);
		dto.setProcessDate(wasteDate);
		dto.setLastRemainDays(wasteLastDay);
		dto.setLastRemainHour(wasteLastHour);
		dto.setRemainDays(wasteDay);
		dto.setRemainHour(wasteHour);
		return dto;
	}
	
	/**
	 * pDTO̐
	 * @param kCode ΏێЈR[h
	 * @param processDate Ώ۔N
	 * @param map cEcԏ
	 * @return pDTO
	 */
	public static KdPaidHolidayDto createMonthlyDto(String kCode, Date processDate, Map<String, Double> map) {
		KdPaidHolidayDto dto = new KdPaidHolidayDto();
		dto.setKCode(kCode);
		dto.setProcessDate(processDate);
		dto.setProcessType(CommonConst.CODE_PROCESS_MONTHLY);
		setMapInfoToNewInfo(dto, map);
		return dto;
	}
	
	/**
	 * ΏۊԂ̎cAcԏ擾
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊԊJn
	 * @param endDate ΏۊԏI
	 * @return ΏۊԂ̎cAcԏ
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> getAvairablePaidHolidayMap(String kCode, Date startDate, Date endDate) throws Exception {
		return getAvairablePaidHolidayMap(kCode, startDate, endDate, getPeriodRemainInfoMap(kCode, startDate, endDate));
	}
	
	/**
	 * ΏۊԂ̎cAcԏ擾
	 * @param kCode ΏێЈR[h
	 * @param startDate xɐ\ΏۊԊJn
	 * @param endDate xɐ\ΏۊԏI
	 * @param map ΏۊԎc
	 * @return ΏۊԂ̎cAcԏ
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> getAvairablePaidHolidayMap(String kCode, Date startDate, Date endDate,
			Map<String, Double> map) throws Exception {
		// cAc
		double lastRemainDays = getMapLastRemainDays(map);
		int lastRemainHour = getMapLastRemainHour(map);
		double remainDays = getMapRemainDays(map);
		int remainHour = getMapRemainHour(map);
		int possible = getMapPossible(map);
		// t^
		double totalSupplyDays = getMapSupplyDays(map);
		int totalSupplyHour = getMapSupplyHour(map);
		// T
		double totaolWasteDays = getMapWasteDays(map);
		int totalWasteHour = getMapWasteHour(map);
		double useDays = 0;
		int useHour = 0;
		// ΑӏF@\𗘗pꍇ
		if (part().mospcode().isAttendanceApprovalFunction()) {
			// ̏FςݗLx\擾
			List<KtHolidayRequestDto> requestList = part().holidayRequest().getApprovedPaidHolidayRequestList(kCode,
					startDate, endDate);
			
			for (KtHolidayRequestDto requestDto : requestList) {
				double inputDays = 0;
				int inputHour = 0;
				if (HolidayRequestPart.isPaidHolidayAll(requestDto)) {
					inputDays++;
				}
				if (HolidayRequestPart.isPaidHolidayHalf(requestDto)) {
					inputDays += CommonConst.NUM_HALF_DAY;
				}
				if (HolidayRequestPart.isPaidHolidayTime(requestDto)) {
					inputHour += HolidayRequestPart.getHolidayTime(requestDto);
				}
				useDays += inputDays;
				useHour += inputHour;
			}
		} else {
			// F@\𗘗pȂꍇ
			KintaiCompileDto compileDto = part().compile().getCompileInfo(kCode,
					part().calculate().getCalcAttendanceMonth(endDate));
			useDays = compileDto.getTotalPaidHoliday();
		}
		// J
		int prescribedTime = LaborAgreementPart.getPrescribedTime(part().laborAgreement().getUserLaborAgreement(kCode,
				startDate));
		Map<String, Double> retMap = calcRemain(useDays, useHour, lastRemainDays, lastRemainHour, remainDays,
				remainHour, possible, prescribedTime);
		lastRemainDays = getMapLastRemainDays(retMap);
		lastRemainHour = getMapLastRemainHour(retMap);
		remainDays = getMapRemainDays(retMap);
		remainHour = getMapRemainHour(retMap);
		possible = getMapPossible(retMap);
		return createRemainMap(lastRemainDays, lastRemainHour, remainDays, remainHour, possible, totalSupplyDays,
				totalSupplyHour, totaolWasteDays, totalWasteHour, useDays, useHour);
	}
	
	/**
	 * ΏۊԂ̎cAcԏ
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊԊJnN
	 * @param endDate ΏۊԏIN
	 * @return ΏۊԂ̎cAcԏ
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> getPeriodRemainInfoMap(String kCode, Date startDate, Date endDate) throws Exception {
		// ̏擾
		KdPaidHolidayDto dto = getPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
		if (VariousUtil.isNull(dto)) {
			// ꍇAԋ߂Lx擾B
			dto = getNearlyPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
		}
		// e[ȕ擾
		if (VariousUtil.isNull(dto)) {
			dto = new KdPaidHolidayDto();
			setMapInfoToNewInfo(dto, convOldInfoToMap(getNearlyYukyuInfo(kCode, startDate)));
		}
		return getRemainInfoMap(dto, startDate, endDate);
	}
	
	/**
	 * Ώ۔N̎cAcԏ擾
	 * @param kCode ΏێЈR[h
	 * @param targetYear Ώ۔N
	 * @param targetMonth Ώی
	 * @return Ώ۔N̎cAcԏ
	 * @throws Exception Oꍇ
	 */
	public Map<String, Double> getAvairablePaidHolidayMap(String kCode, int targetYear, int targetMonth)
			throws Exception {
		// LxɎx
		int carryForwardMonth = 0;
		if (part().mospcode().useProvideEmployMonth()) {
			// ΏێЈ̓ЌZbgB
			carryForwardMonth = MospUtility.getMonth(part().human().getEmployDate(kCode));
		} else {
			// JzZbgB
			carryForwardMonth = part().mospcode().getCarriedForwardMonth();
		}
		// JzN
		Date carryForward = DateUtil.getYearMonth(targetYear, carryForwardMonth);
		// JnN
		Date startDate = part().calculate().getStartDate(carryForward);
		// IN
		Date endDate = DateUtil.addDay(DateUtil.addYear(startDate, 1), -1);
		KdPaidHolidayDto carryDto;
		if (targetMonth == 0) {
			// x̏擾
			carryDto = getPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
			if (VariousUtil.isNull(carryDto)) {
				// xꍇAxɈԋ߂Ve[ȕ擾B
				carryDto = getNearlyPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
				if (VariousUtil.isNotNull(carryDto)) {
					// IJz̊JnO܂łɂB
					endDate = DateUtil.addDay(startDate, -1);
					startDate = carryDto.getProcessDate();
				}
			}
			// łꍇAe[ȕ擾B
			if (VariousUtil.isNull(carryDto)) {
				MYukyuDto yukyuDto = getTargetMonthYukyuInfo(kCode, startDate, endDate);
				if (VariousUtil.isNotNull(yukyuDto)) {
					startDate = part().calculate().getStartDate(DateUtil.convIntegerDateToDate(yukyuDto.getKyuyoYMD()));
				}
				carryDto = new KdPaidHolidayDto();
				setMapInfoToNewInfo(carryDto, convOldInfoToMap(yukyuDto));
			}
		} else {
			Date yearMonth = DateUtil.getYearMonth(targetYear, targetMonth);
			startDate = part().calculate().getStartDate(yearMonth);
			endDate = part().calculate().getEndDate(yearMonth);
			// ̏擾
			carryDto = getPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
			if (VariousUtil.isNull(carryDto)) {
				// ̏񂪖ꍇAɈԋ߂Ve[ȕ擾B
				carryDto = getNearlyPaidHolidayInfo(kCode, startDate, CommonConst.CODE_PROCESS_MONTHLY);
				if (VariousUtil.isNotNull(carryDto)) {
					startDate = carryDto.getProcessDate();
				}
			}
			// łꍇAe[ȕ擾B
			if (VariousUtil.isNull(carryDto)) {
				// 1Ő^x
				Date oneMonthBeforeCalcPayment = part().calculate().getCalcPayment(DateUtil.addMonth(yearMonth, -1));
				MYukyuDto yukyuDto = getTargetMonthYukyuInfo(kCode, DateUtil
					.getFirstDateOfMonth(oneMonthBeforeCalcPayment), DateUtil
					.getLastDateOfMonth(oneMonthBeforeCalcPayment));
				carryDto = new KdPaidHolidayDto();
				setMapInfoToNewInfo(carryDto, convOldInfoToMap(yukyuDto));
			}
		}
		return getAvairablePaidHolidayMap(kCode, startDate, endDate, getRemainInfoMap(carryDto, startDate, endDate));
	}
	
	/**
	 * ΏۊԂ̎cAcԏ
	 * @param dto ΏDTO
	 * @param startDate ΏۊԊJnN
	 * @param endDate ΏۊԏIN
	 * @return ΏۊԂ̎cAcԏ
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public Map<String, Double> getRemainInfoMap(KdPaidHolidayDto dto, Date startDate, Date endDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		// cAc
		double lastRemainDays = 0;
		int lastRemainHour = 0;
		double remainDays = 0;
		int remainHour = 0;
		int possible = 0;
		// t^
		double supplyLastDay = 0;
		int supplyLastHour = 0;
		double supplyDay = 0;
		int supplyHour = 0;
		// T
		double wasteLastDay = 0;
		int wasteLastHour = 0;
		double wasteDay = 0;
		int wasteHour = 0;
		// v
		double totalSupplyDays = 0;
		int totalSupplyHour = 0;
		double totaolWasteDays = 0;
		int totalWasteHour = 0;
		if (VariousUtil.isNotNull(dto)) {
			String kCode = dto.getKCode();
			lastRemainDays = dto.getLastRemainDays();
			lastRemainHour = dto.getLastRemainHour();
			remainDays = dto.getRemainDays();
			remainHour = dto.getRemainHour();
			possible = dto.getPossible();
			// ̕t^擾
			List<KdPaidHolidayDto> supplyList = getPaidHolidayDao().findForCondition(kCode,
					CommonConst.CODE_PROCESS_SUPPLY, startDate, endDate);
			for (KdPaidHolidayDto supplyDto : supplyList) {
				supplyLastDay += supplyDto.getLastRemainDays();
				supplyLastHour += supplyDto.getLastRemainHour();
				supplyDay += supplyDto.getRemainDays();
				supplyHour += supplyDto.getRemainHour();
			}
			// ̍T擾
			List<KdPaidHolidayDto> wasteList = getPaidHolidayDao().findForCondition(kCode,
					CommonConst.CODE_PROCESS_WASTE, startDate, endDate);
			for (KdPaidHolidayDto wasteDto : wasteList) {
				wasteLastDay += wasteDto.getLastRemainDays();
				wasteLastHour += wasteDto.getLastRemainHour();
				wasteDay += wasteDto.getRemainDays();
				wasteHour += wasteDto.getRemainHour();
			}
			// vcAc
			lastRemainDays = lastRemainDays + supplyLastDay - wasteLastDay;
			lastRemainHour = lastRemainHour + supplyLastHour - wasteLastHour;
			remainDays = remainDays + supplyDay - wasteDay;
			remainHour = remainHour + supplyHour - wasteHour;
			totalSupplyDays = supplyLastDay + supplyDay;
			totalSupplyHour = supplyLastHour + supplyHour;
			totaolWasteDays = wasteLastDay + wasteDay;
			totalWasteHour = wasteLastHour + wasteHour;
		}
		return createRemainMap(lastRemainDays, lastRemainHour, remainDays, remainHour, possible, totalSupplyDays,
				totalSupplyHour, totaolWasteDays, totalWasteHour, 0, 0);
	}
	
	/**
	 * Ve[uMAP̏ZbgB
	 * <p>
	 * ONxcAONxcԁANxcANxcԁAԒPʔNxp\ZbgB
	 * </p>
	 * @param dto ΏDTO
	 * @param map ΏMAP
	 */
	public static void setMapInfoToNewInfo(KdPaidHolidayDto dto, Map<String, Double> map) {
		if (VariousUtil.isNotNull(dto)) {
			dto.setLastRemainDays(getMapLastRemainDays(map));
			dto.setLastRemainHour(getMapLastRemainHour(map));
			dto.setRemainDays(getMapRemainDays(map));
			dto.setRemainHour(getMapRemainHour(map));
			dto.setPossible(getMapPossible(map));
		}
	}
	
	/**
	 * LxcAcԏMAP
	 * @param lastRemainDays ONxc
	 * @param lastRemainHour ONxc
	 * @param remainDays Nxc
	 * @param remainHour Nxc
	 * @param possible ԒPʔNxp\
	 * @param supplyDays x
	 * @param supplyHour x
	 * @param wasteDays p
	 * @param wasteHour p
	 * @param useDays p
	 * @param useHour p
	 * @return LxcAcԏMAP
	 */
	public static Map<String, Double> createRemainMap(double lastRemainDays, int lastRemainHour, double remainDays,
			int remainHour, int possible, double supplyDays, int supplyHour, double wasteDays, int wasteHour,
			double useDays, int useHour) {
		Map<String, Double> map = new HashMap<String, Double>();
		map.put(KEY_LAST_REMAIN_DAYS, lastRemainDays);
		map.put(KEY_LAST_REMAIN_HOUR, Double.valueOf(lastRemainHour));
		map.put(KEY_REMAIN_DAYS, remainDays);
		map.put(KEY_REMAIN_HOUR, Double.valueOf(remainHour));
		map.put(KEY_POSSIBLE, Double.valueOf(possible));
		map.put(KEY_SUPPLY_DAYS, supplyDays);
		map.put(KEY_SUPPLY_HOUR, Double.valueOf(supplyHour));
		map.put(KEY_WASTE_DAYS, wasteDays);
		map.put(KEY_WASTE_HOUR, Double.valueOf(wasteHour));
		map.put(KEY_USE_DAYS, useDays);
		map.put(KEY_USE_HOUR, Double.valueOf(useHour));
		return map;
	}
	
	/**
	 * ONxc擾
	 * @param map LxcAcԏMAP
	 * @return ONxc
	 */
	public static double getMapLastRemainDays(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return map.get(KEY_LAST_REMAIN_DAYS);
		}
		return 0d;
	}
	
	/**
	 * ONxcԎ擾
	 * @param map LxcAcԏMAP
	 * @return ONxc
	 */
	public static int getMapLastRemainHour(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_LAST_REMAIN_HOUR)).intValue();
		}
		return 0;
	}
	
	/**
	 * Nxc擾
	 * @param map LxcAcԏMAP
	 * @return Nxc
	 */
	public static double getMapRemainDays(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return map.get(KEY_REMAIN_DAYS);
		}
		return 0d;
	}
	
	/**
	 * NxcԎ擾
	 * @param map LxcAcԏMAP
	 * @return Nxc
	 */
	public static int getMapRemainHour(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_REMAIN_HOUR)).intValue();
		}
		return 0;
	}
	
	/**
	 * ԒPʔNxp\擾
	 * @param map LxcAcԏMAP
	 * @return ԒPʔNxp\
	 */
	public static int getMapPossible(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_POSSIBLE)).intValue();
		}
		return 0;
	}
	
	/**
	 * x擾
	 * @param map LxcAcԏMAP
	 * @return x
	 */
	public static double getMapSupplyDays(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return map.get(KEY_SUPPLY_DAYS);
		}
		return 0d;
	}
	
	/**
	 * xԎ擾
	 * @param map LxcAcԏMAP
	 * @return x
	 */
	public static int getMapSupplyHour(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_SUPPLY_HOUR)).intValue();
		}
		return 0;
	}
	
	/**
	 * p擾
	 * @param map LxcAcԏMAP
	 * @return p
	 */
	public static double getMapWasteDays(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return map.get(KEY_WASTE_DAYS);
		}
		return 0d;
	}
	
	/**
	 * pԎ擾
	 * @param map LxcAcԏMAP
	 * @return p
	 */
	public static int getMapWasteHour(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_WASTE_HOUR)).intValue();
		}
		return 0;
	}
	
	/**
	 * p擾
	 * @param map LxcAcԏMAP
	 * @return p
	 */
	public static double getMapUseDays(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return map.get(KEY_USE_DAYS);
		}
		return 0d;
	}
	
	/**
	 * pԎ擾
	 * @param map LxcAcԏMAP
	 * @return p
	 */
	public static int getMapUseHour(Map<String, Double> map) {
		if (VariousUtil.isNotNull(map)) {
			return Double.valueOf(map.get(KEY_USE_HOUR)).intValue();
		}
		return 0;
	}
	
	/**
	 * cEcԂ̃`FbN
	 * @param map LxcAcԏMAP
	 * @return
	 * <p>
	 * cEcԂcĂꍇtrueAڂɃ}CiXꍇfalseB
	 * </p>
	 */
	public static boolean checkRemainInfoMap(Map<String, Double> map) {
		return getMapLastRemainDays(map) >= 0 && getMapLastRemainHour(map) >= 0 && getMapRemainDays(map) >= 0
				&& getMapRemainHour(map) >= 0 && getMapPossible(map) >= 0;
	}
	
	/**
	 * ΏۊԂJ@{sOł邩̔fB
	 * @param startDate JnN
	 * @param endDate IN
	 * @return J@{sȌꍇtrueAłȂꍇfalseB
	 */
	public static boolean checkBeforeReformDate(Date startDate, Date endDate) {
		return endDate.compareTo(startDate) > 0 && DateUtil.getLegalReformDate().compareTo(endDate) > 0;
	}
	
	/**
	 * ΏۊԂJ@{sȌł邩̔fB
	 * @param startDate JnN
	 * @param endDate IN
	 * @return J@{sȌ̏ꍇtrueAłȂꍇfalseB
	 */
	public static boolean checkAfterReformDate(Date startDate, Date endDate) {
		return endDate.compareTo(startDate) > 0 && DateUtil.getLegalReformDate().compareTo(endDate) <= 0;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊԊJnN
	 * @param endDate ΏۊԏIN
	 * @return LxɏMAP
	 * @throws Exception 	Oꍇ
	 */
	public Map<String, Double> getPeriodPaidHolidayInfoMap(String kCode, Date startDate, Date endDate) throws Exception {
		if (checkBeforeReformDate(startDate, endDate)) {
			Date calcAttendanceMonth = part().calculate().getCalcAttendanceMonth(endDate);
			// 񃖌Ő^x
			Date twoMonthBeforeCalcPayment = part().calculate().getCalcPayment(
					DateUtil.addMonth(calcAttendanceMonth, -2));
			// 1Ő^x
			Date oneMonthBeforeCalcPayment = part().calculate().getCalcPayment(
					DateUtil.addMonth(calcAttendanceMonth, -1));
			return convOldInfoToMap(getTargetMonthYukyuInfo(kCode, DateUtil.addDay(twoMonthBeforeCalcPayment, 1),
					oneMonthBeforeCalcPayment));
		} else if (checkAfterReformDate(startDate, endDate)) {
			return getAvairablePaidHolidayMap(kCode, startDate, endDate);
		}
		return null;
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param targetMonth Ώ۔N
	 * @return LxɏMAP
	 * @throws Exception 	Oꍇ
	 */
	public Map<String, Double> getPaidHolidayInfoMap(String kCode, Date targetMonth) throws Exception {
		Date startDate = part().calculate().getStartDate(targetMonth);
		Date endDate = part().calculate().getEndDate(targetMonth);
		return getPeriodPaidHolidayInfoMap(kCode, startDate, endDate);
	}
	
	/**
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @return LxɏMAP
	 * @throws Exception 	Oꍇ
	 */
	public Map<String, Double> getTargetPaidHolidayInfoMap(String kCode, Date targetDate) throws Exception {
		// Ώ۔N̗Lx擾B
		Date startDate = part().calculate().getStartDateForList(targetDate);
		Date endDate = part().calculate().getEndDateForList(targetDate);
		return getPeriodPaidHolidayInfoMap(kCode, startDate, endDate);
	}
	
	/**
	 * Lxɏ񃊃Xg擾
	 * @param kCode			ΏێЈR[h
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @return	(DTOList)
	 * @throws Exception	Oꍇ
	 */
	public List<KdPaidHolidayDto> getPaidHolidayInfoList(String kCode, Date startDate, Date endDate) throws Exception {
		return getPaidHolidayDao().findForCondition(kCode, startDate, endDate);
	}
	
	/**
	 * ΑɂLx擾
	 * @param kCode ΏێЈR[h
	 * @return ΑɂLx
	 * @throws Exception 	Oꍇ
	 */
	public int getCarryForwardSupplyDays(String kCode) throws Exception {
		int supplyDays = 0;
		// Α擾
		double yearOfService = part().human().getYearsOfService(kCode);
		// ΑLx擾
		String[][] aryPaidHoliday = part().mospcode().getPaidHolidayArray();
		for (String[] aryPaidHolidayInfo : aryPaidHoliday) {
			if (yearOfService >= NumberUtil.getIntParam(aryPaidHolidayInfo[0])) {
				supplyDays = NumberUtil.getIntParam(aryPaidHolidayInfo[1]);
			}
		}
		return supplyDays;
	}
	
	/**
	 * Lxf
	 * @param code ΏۃR[h
	 * @return
	 * <p>
	 * ΏۃR[hLxłꍇtrueAłȂꍇfalseB
	 * </p>
	 */
	public static boolean isPaidHoliday(String code) {
		return CommonConst.CODE_HOLIDAY_REASON_PAID.equals(code);
	}
	
	/**
	 * CSVt@Cpwb_[z(e[u)擾
	 * @return	CSVt@Cpwb_[z
	 * @throws Exception 	Oꍇ
	 */
	public String[] getOldPaidHolidayCsvHeader() throws Exception {
		List<String> headerList = new LinkedList<String>();
		String[] aryColumnInfo = part().export().getTableColumnInfo(OLD_TABLE);
		for (String columnInfo : aryColumnInfo) {
			headerList.add(VariousUtil.getCsvSplitInfo(columnInfo, 3));
		}
		return StringUtil.listToArray(headerList);
	}
	
	/**
	 * CSVt@Cpwb_[z(Ve[u)擾
	 * @return	CSVt@Cpwb_[z
	 * @throws Exception 	Oꍇ
	 */
	public String[] getNewPaidHolidayCsvHeader() throws Exception {
		List<String> headerList = new LinkedList<String>();
		String[] aryColumnInfo = part().export().getTableColumnInfo(NEW_TABLE);
		for (String columnInfo : aryColumnInfo) {
			headerList.add(VariousUtil.getCsvSplitInfo(columnInfo, 3));
		}
		return StringUtil.listToArray(headerList);
	}
	
	/**
	 * @param kCode		string	ЈR[h
	 * @param kyuyoYMD	int		^vZN
	 * @param zZanT		double	Oc(N)
	 * @param zZanZ		double	Oc(ON)
	 * @param syoka		double	gp
	 * @param syutoku	int		擾
	 * @param haiki		double	p
	 * @param tZanT		double	c(N)
	 * @param tZanZ		double	c(ON)
	 * @return	dto		dto		LxDto
	 */
	public static MYukyuDto createMYukyuDto(String kCode, int kyuyoYMD, double zZanT, double zZanZ, double syoka,
			int syutoku, double haiki, double tZanT, double tZanZ) {
		MYukyuDto dto = new MYukyuDto();
		dto.setKCode(kCode);
		dto.setKyuyoYMD(kyuyoYMD);
		dto.setZZanT(zZanT);
		dto.setZZanZ(zZanZ);
		dto.setSyoka(syoka);
		dto.setSyutoku(syutoku);
		dto.setHaiki(haiki);
		dto.setTZanT(tZanT);
		dto.setTZanZ(tZanZ);
		return dto;
	}
	
	/**
	 * @param paidHolidayId		LxID
	 * @param kCode				ЈR[h
	 * @param processType		R[h
	 * @param processDate		
	 * @param lastRemainDays	ONxc
	 * @param lastRemainHour	ONxc
	 * @param remainDays		Nxc
	 * @param remainHour		NxZ
	 * @param possible			ԒPʎ擾\
	 * @param deleteFlag		폜tO
	 * @return					VLxDto
	 */
	public static KdPaidHolidayDto createKdPaidHolidayDto(long paidHolidayId, String kCode, String processType,
			Date processDate, double lastRemainDays, int lastRemainHour, double remainDays, int remainHour,
			int possible, int deleteFlag) {
		KdPaidHolidayDto dto = new KdPaidHolidayDto();
		dto.setPaidId(paidHolidayId);
		dto.setKCode(kCode);
		dto.setProcessType(processType);
		dto.setProcessDate(processDate);
		dto.setLastRemainDays(lastRemainDays);
		dto.setLastRemainHour(lastRemainHour);
		dto.setRemainDays(remainDays);
		dto.setRemainHour(remainHour);
		dto.setPossible(possible);
		dto.setDeleteFlag(deleteFlag);
		return dto;
	}
}
