/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.HumanBasisDtoInterface;

/**
 * @author yoshida
 *
 */
public class EmployeePaidHolidayListVo extends MosPVo {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 2444148041246502111L;
	// p[^
	/**
	 * txtKCode
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * txtKName
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * pltSection
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_STATION;
	/**
	 * 
	 */
	public String				NAM_YEAR_MONTH;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_NAME;
	
	// tB[h
	private String[][]			aryEmployee;
	
	private String				txtKCode;
	private String				txtKName;
	private String				pltSection;
	private String				pltYear;
	private String				pltMonth;
	
	private String				hidSelectYearMonth;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * 
	 */
	public final String			KEY_K_NAME			= "keyKName";
	/**
	 * 
	 */
	public final String			KEY_SECTION			= "keySection";
	/**
	 * 
	 */
	public final String			KEY_POSITION		= "keyPosition";
	

	/**
	 * RXgN^
	 */
	public EmployeePaidHolidayListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		pltSection = "";
		aryEmployee = new String[0][0];
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_EMPLOYEE_YUKYU_SELECT;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuPaidHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_STATION = CommonConst.NAM_STATION;
		NAM_YEAR_MONTH = "IN";
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	@Override
	public void setFields(List<?> list) throws Exception {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryEmployee = new String[count][5];
		int i = 0;
		for (Object obj : list) {
			HumanBasisDtoInterface dto = (HumanBasisDtoInterface)obj;
			// JڐR}h
			aryEmployee[i][0] = escapeHTML(dto.getJCode());
			aryEmployee[i][1] = escapeHTML(dto.getKCode());
			aryEmployee[i][2] = escapeHTML(dto.getSimei());
			aryEmployee[i][3] = escapeHTML(dto.getSCode());
			aryEmployee[i][4] = escapeHTML(dto.getYCode());
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return aryEmployee
	 */
	public String[][] getEscAryEmployee() {
		return aryEmployee.clone();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return txtKName
	 */
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	/**
	 * @return hidSelectYearMonth
	 */
	public String getEscHidSelectYearMonth() {
		return escapeHTML(hidSelectYearMonth);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return hidSelectYearMonth
	 */
	public String getHidSelectYearMonth() {
		return hidSelectYearMonth;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param hidSelectYearMonth Zbg hidSelectYearMonth
	 */
	public void setHidSelectYearMonth(String hidSelectYearMonth) {
		this.hidSelectYearMonth = hidSelectYearMonth;
	}
	
}
