/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.payroll.dto.SubstitudeHolidayDto;

/**
 * @author saito
 *
 */
public class EmployeeSubHolidayListVo extends MosPVo {
	
	/**
	 * 
	 */
	public String				NAM_K_OCCUR_YEARMONTH		= "N";
	/**
	 * 
	 */
	public String				NAM_K_ATTITUDE_STATUS		= "ӌ";
	/**
	 * 
	 */
	public String				NAM_K_ACQUISITION_STATUS	= "擾";
	/**
	 * 
	 */
	public String				NAM_K_DECISION_STATUS		= "Ϗ";
	
	/**
	 * 
	 */
	private static final long	serialVersionUID			= 2343187573011069153L;
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF					= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON					= 1;
	/**
	 * 
	 */
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE				= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_NAME				= "txtKName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_YEAR				= "PltYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_MONTH				= "PltMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_ATTITUDE_STATUS		= "pltAttitudeStatus";
	/**
	 * 
	 */
	public static final String	PRM_PLT_ACQUISITION_STATUS	= "pltAcquisitionStatus";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DECISION_STATUS		= "pltDecisionStatus";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_YEAR;
	/**
	 * 
	 */
	public String				NAM_MONTH;
	/**
	 * 
	 */
	public String				NAM_ATTITUDE_STATUS;
	/**
	 * 
	 */
	public String				NAM_ACQUISITION_STATUS;
	/**
	 * 
	 */
	public String				NAM_DECISION_STATUS;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_NAME;
	
	// tB[h
	private String[][]			aryEmployee;
	
	private String				txtKCode;
	private String				txtKName;
	/**
	 * N
	 */
	public String				pltYear;
	/**
	 * 
	 */
	public String				pltMonth;
	/**
	 * ӌ
	 */
	public String				pltAttitudeStatus;
	/**
	 * 擾
	 */
	public String				pltAcquisitionStatus;
	/**
	 * Ϗ
	 */
	public String				pltDecisionStatus;
	
	// [h(0FȂA1F)
	private int					searchmode;
	
	// v_EXg
	/**
	 * N
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * ӌ
	 */
	public String[][]			aryPltAttitudeStatus;
	/**
	 * 擾
	 */
	public String[][]			aryPltAcquisitionStatus;
	/**
	 * Ϗ
	 */
	public String[][]			aryPltDecisionStatus;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_K_CODE					= "keyKCode";
	/**
	 * 
	 */
	public final String			KEY_K_NAME					= "keyKName";
	/**
	 * 
	 */
	public final String			KEY_YEAR					= "keyYear";
	/**
	 * 
	 */
	public final String			KEY_MONTH					= "keyMonth";
	/**
	 * 
	 */
	public final String			KEY_ATTITUDE				= "keyAttitude";
	/**
	 * 
	 */
	public final String			KEY_ACQUISITION				= "keyAcquisition";
	/**
	 * 
	 */
	public final String			KEY_DECISION				= "keyDecision";
	

	/**
	 * RXgN^
	 */
	public EmployeeSubHolidayListVo() {
		super();
		setViewPath(getClassName());
		txtKCode = "";
		txtKName = "";
		pltMonth = "";
		pltYear = "";
		aryPltAttitudeStatus = new String[0][0];
		aryPltAcquisitionStatus = new String[0][0];
		aryPltDecisionStatus = new String[0][0];
		aryEmployee = new String[0][0];
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "xǗ";
		aryMenu = new String[][]{ { CMD_MENU_PAYROLL, CommonConst.NAM_TO_MENU },
			MosPMenuConst.getMenuSubHolidayManagement() };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_YEAR = "N";
		NAM_MONTH = "";
		NAM_ATTITUDE_STATUS = "ӌ";
		NAM_ACQUISITION_STATUS = "擾";
		NAM_DECISION_STATUS = "Ϗ";
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		pltAttitudeStatus = request.getParameter(PRM_PLT_ATTITUDE_STATUS);
		pltAcquisitionStatus = request.getParameter(PRM_PLT_ACQUISITION_STATUS);
		pltDecisionStatus = request.getParameter(PRM_PLT_DECISION_STATUS);
	}
	
	@Override
	public void setFields(List<?> list) throws Exception {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryEmployee = new String[count][8];
		int i = 0;
		for (Object obj : list) {
			SubstitudeHolidayDto dto = (SubstitudeHolidayDto)obj;
			// JڐR}h
			aryEmployee[i][0] = escapeHTML(String.valueOf(dto.getSubstituteId()));
			aryEmployee[i][1] = escapeHTML(dto.getKCode());
			aryEmployee[i][2] = escapeHTML(dto.getKName());
			aryEmployee[i][3] = escapeHTML(String.valueOf(dto.getOccurYear()));
			aryEmployee[i][4] = escapeHTML(String.valueOf(dto.getOccurMonth()));
			aryEmployee[i][5] = escapeHTML(dto.getAttitudeStatus());
			aryEmployee[i][6] = escapeHTML(dto.getAcquisitionStatus());
			aryEmployee[i][7] = escapeHTML(dto.getDecisionStatus());
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return aryEmployee
	 */
	public String[][] getEscAryEmployee() {
		return aryEmployee.clone();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return pltAttitudeStatus
	 */
	public String getAryPltAttitudeStatus() {
		return pltAttitudeStatus;
	}
	
	/**
	 * @return pltAcquisitionStatus
	 */
	public String getAryPltAcquisitionStatus() {
		return pltAcquisitionStatus;
	}
	
	/**
	 * @return pltDecisionStatus
	 */
	public String getAryPltDecisionStatus() {
		return pltDecisionStatus;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param pltAttitudeStatus Zbg pltAttitudeStatus
	 */
	public void setPltAttitudeStatus(String pltAttitudeStatus) {
		pltMonth = pltAttitudeStatus;
	}
	
	/**
	 * @param pltAcquisitionStatus Zbg pltAcquisitionStatus
	 */
	public void setPltAcquisitionStatus(String pltAcquisitionStatus) {
		pltMonth = pltAcquisitionStatus;
	}
	
	/**
	 * @param pltDecisionStatus Zbg pltDecisionStatus
	 */
	public void setPltDecisionStatus(String pltDecisionStatus) {
		pltMonth = pltDecisionStatus;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return T[`[hԂ
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @return aryEmployee
	 */
	public String[][] getAryEmployee() {
		return aryEmployee.clone();
	}
	
	/**
	 * @param aryEmployee Zbg aryEmployee
	 */
	public void setAryEmployee(String[][] aryEmployee) {
		this.aryEmployee = aryEmployee.clone();
	}
	
}
