/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.payroll.dto.KdWorkDto;

import org.apache.commons.fileupload.FileItem;

/**
 * @author nakamura
 *
 */
public class WorkCompileImportCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -5921622593478797532L;
	
	// 萔
	/**
	 * \[h
	 */
	public static final int		MODE_VIEW			= 0;
	/**
	 * Abv[h[h
	 */
	public static final int		MODE_UPLOAD			= 1;
	/**
	 * |[g[h
	 */
	public static final int		MODE_REPORT			= 2;
	
	/**
	 * ΑӃ[h
	 */
	public static final int		TABLE_OLD			= 1;
	/**
	 * VΑӃ[h
	 */
	public static final int		TABLE_NEW			= 2;
	
	// p[^[
	/**
	 * Abv[ht@C
	 */
	public static final String	PRM_FIL_UPLOAD_FILE	= "filUploadFile";
	
	// tB[h
	private FileItem			filUploadFile;
	private String[][]			aryKintai;
	
	private List<KdWorkDto>		newImportList;
	private StringBuffer		errorReport;
	
	private String[]			aryColumnName;
	
	// [h
	private int					mode;
	private int					table;
	
	// tB[hyѐ
	/**
	 * ЈR[h
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_SIKYU_YM;
	/**
	 * 
	 */
	public String				NAM_S_YMD;
	/**
	 * 
	 */
	public String				NAM_S_NISSU;
	/**
	 * 
	 */
	public String				NAM_S_KAISU;
	/**
	 * 
	 */
	public String				NAM_KINMU_JI;
	/**
	 * 
	 */
	public String				NAM_KYUKEI_JI;
	/**
	 * 
	 */
	public String				NAM_YUKYU;
	/**
	 * 
	 */
	public String				NAM_TOKUKYU;
	/**
	 * 
	 */
	public String				NAM_KEKKIN;
	/**
	 * 
	 */
	public String				NAM_S_KEKKIN;
	/**
	 * 
	 */
	public String				NAM_DAIKYU;
	/**
	 * 
	 */
	public String				NAM_FURIKAE;
	/**
	 * 
	 */
	public String				NAM_KK_RIYUU_6;
	/**
	 * 
	 */
	public String				NAM_KK_RIYUU_7;
	/**
	 * 
	 */
	public String				NAM_KK_RIYUU_8;
	/**
	 * 
	 */
	public String				NAM_KK_RIYUU_9;
	/**
	 * 
	 */
	public String				NAM_SONOTA;
	/**
	 * 
	 */
	public String				NAM_TI_SO_KAI;
	/**
	 * 
	 */
	public String				NAM_TI_JIKAN;
	/**
	 * 
	 */
	public String				NAM_ZA_JIKAN;
	/**
	 * 
	 */
	public String				NAM_KS_JIKAN;
	/**
	 * 
	 */
	public String				NAM_SN_JIKAN;
	/**
	 * 
	 */
	public String				NAM_KAIKIN;
	/**
	 * 
	 */
	public String				NAM_SYOKUJI_KAISU;
	/**
	 * 
	 */
	public String				NAM_CYOKU_KAISU_1;
	/**
	 * 
	 */
	public String				NAM_CYOKU_KAISU_2;
	/**
	 * 
	 */
	public String				NAM_CYOKU_KAISU_3;
	/**
	 * 
	 */
	public String				NAM_HOKA_KAISU_1;
	/**
	 * 
	 */
	public String				NAM_HOKA_KAISU_2;
	/**
	 * 
	 */
	public String				NAM_HOKA_KAISU_3;
	/**
	 * 
	 */
	public String				NAM_HOKA_KAISU_4;
	/**
	 * 
	 */
	public String				NAM_HOKA_KAISU_5;
	/**
	 * 
	 */
	public String				NAM_SINSEI_GAKU;
	/**
	 * 
	 */
	public String				NAM_WARIMASI;
	/**
	 * 
	 */
	public String				NAM_WEEK_DAY_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_WEEK_HOLIDAY_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_MONTHLY_OVER_TIME;
	/**
	 * 
	 */
	public String				NAM_MONTHLY_WEEK_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_HOUR_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_HOLIDAY;
	/**
	 * 
	 */
	public String				NAM_AMEND_FLAG;
	

	/**
	 * RXgN^[
	 */
	public WorkCompileImportCardVo() {
		super();
		setViewPath(getClassName());
		aryKintai = new String[0][0];
		aryColumnName = StringUtil.getBlankArrayOneDimension(44);
		mode = MODE_VIEW;
		table = 0;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "ΑӏC|[g";
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_SIKYU_YM = "N";
		NAM_S_YMD = "N";
		NAM_S_NISSU = "o";
		NAM_S_KAISU = "o";
		NAM_KINMU_JI = "Ζ";
		NAM_KYUKEI_JI = "xe";
		NAM_YUKYU = "Lx";
		NAM_TOKUKYU = "x";
		NAM_KEKKIN = "";
		NAM_S_KEKKIN = "a";
		NAM_DAIKYU = "x";
		NAM_FURIKAE = "Ux";
		NAM_KK_RIYUU_6 = "x6";
		NAM_KK_RIYUU_7 = "x7";
		NAM_KK_RIYUU_8 = "x8";
		NAM_KK_RIYUU_9 = "x9";
		NAM_SONOTA = CommonConst.NAM_OTHER_SHORT;
		NAM_TI_SO_KAI = "x";
		NAM_TI_JIKAN = "x";
		NAM_ZA_JIKAN = "c";
		NAM_KS_JIKAN = "xo";
		NAM_SN_JIKAN = "[";
		NAM_KAIKIN = "F";
		NAM_SYOKUJI_KAISU = "H";
		NAM_CYOKU_KAISU_1 = "1";
		NAM_CYOKU_KAISU_2 = "2";
		NAM_CYOKU_KAISU_3 = "3";
		NAM_HOKA_KAISU_1 = "1";
		NAM_HOKA_KAISU_2 = "2";
		NAM_HOKA_KAISU_3 = "3";
		NAM_HOKA_KAISU_4 = "4";
		NAM_HOKA_KAISU_5 = "5";
		NAM_SINSEI_GAKU = "x";
		NAM_WARIMASI = "";
		NAM_WEEK_DAY_OVER_TIME = "O";
		NAM_WEEK_HOLIDAY_OVER_TIME = "xO";
		NAM_MONTHLY_OVER_TIME = "60O";
		NAM_MONTHLY_WEEK_HOLIDAY = "60xO";
		NAM_HOUR_HOLIDAY = "x";
		NAM_SUBSTITUTE_HOLIDAY = "60x";
		NAM_AMEND_FLAG = "C";
	}
	
	/**
	 * @param kintaiList		Αӏ
	 */
	@Override
	public void setFields(List<?> kintaiList) {
		// Xg̐ݒ
		list = kintaiList;
		// f[^̎擾
		count = list.size();
		// z̏
		aryKintai = new String[count][44];
		int i = 0;
		for (Object obj : kintaiList) {
			aryKintai[i] = escapeArray((String[])obj);
			i++;
		}
	}
	
	/**
	 * p[^ݒ
	 * @param list	NGXgXg
	 * @throws Exception O
	 */
	public void setFilUploadFile(List<?> list) throws Exception {
		filUploadFile = FileUploadUtility.getMultipartFile(list, PRM_FIL_UPLOAD_FILE);
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append(" var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(" var TABLE = ");
		sb.append(table);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return		Abv[ht@C
	 */
	public FileItem getFilUploadFile() {
		return filUploadFile;
	}
	
	/**
	 * @return		Αӏ
	 */
	public String[][] getEscAryKintai() {
		return aryKintai.clone();
	}
	
	/**
	 * @return		VΑӃ[h
	 */
	public int getTable() {
		return table;
	}
	
	/**
	 * @param mode		[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @param table Zbg table
	 */
	public void setTable(int table) {
		this.table = table;
	}
	
	/**
	 * @param newImportList Zbg newImportList
	 */
	public void setNewImportList(List<KdWorkDto> newImportList) {
		this.newImportList = newImportList;
	}
	
	/**
	 * @return newImportList
	 */
	public List<KdWorkDto> getNewImportList() {
		return newImportList;
	}
	
	/**
	 * @param errorReport Zbg errorReport
	 */
	public void setErrorReport(StringBuffer errorReport) {
		this.errorReport = errorReport;
	}
	
	/**
	 * @return errorReport
	 */
	public StringBuffer getErrorReport() {
		return errorReport;
	}
	
	/**
	 * @return aryColumnName
	 */
	public String[] getAryColumnName() {
		return aryColumnName.clone();
	}
	
	/**
	 * @param aryColumnName Zbg aryColumnName
	 */
	public void setAryColumnName(String[] aryColumnName) {
		this.aryColumnName = aryColumnName.clone();
	}
}
