/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;

/**
 * @author yoshida
 *
 */
public class ExportMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 1449101746145275687L;
	
	// 萔
	public static final int		MODE_INSERT			= 0;
	public static final int		MODE_UPDATE			= 1;
	public static final int		MODE_SYSTEM			= 2;
	
	// p[^
	public static final String	PRM_TXT_E_NAME		= "txtEName";
	public static final String	PRM_HID_E_FILE		= "hidEFile";
	public static final String	PRM_LBL_E_FILE		= "lblEFile";
	public static final String	PRM_PLT_SELECTED	= "pltSelected";
	
	// tB[h
	private String[]			pltSelected;
	private String				txtEName;
	private String				hidEFile;
	private String				lblEFile;
	// v_EXg
	public String[][]			aryPltKintaiDataItem;
	public String[][]			aryPltSelectDataItem;
	public String[][]			aryTargetTable;
	
	// tB[hyѐ
	public String				NAM_NAME;
	public String				NAM_FILE;
	public String				NAM_PLT_SELECTED;
	public int					LEN_NAME;
	public int					LEN_FILE;
	
	// [h(0FVKo^A1FXVA2F폜)
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public ExportMasterCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_EXPORT_MASTER_MAINT;
		aryMenu = new String[][]{ { CMD_MENU_PAYROLL, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_NAME = CommonConst.NAM_REGIST + CommonConst.NAM_COMMON_MEISYO;
		NAM_FILE = CommonConst.NAM_TABLE;
		NAM_PLT_SELECTED = CommonConst.NAM_HUMAN_DATA_SELECT;
		LEN_NAME = 10;
		LEN_FILE = 20;
	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtEName = request.getParameter(PRM_TXT_E_NAME);
		hidEFile = request.getParameter(PRM_HID_E_FILE);
		pltSelected = request.getParameterValues(PRM_PLT_SELECTED);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtEName, NAM_NAME, PRM_TXT_E_NAME);
		// 񒷊mF
		checkLength(txtEName, LEN_NAME, NAM_NAME, PRM_TXT_E_NAME);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String[] getPltSelected() {
		return pltSelected == null ? new String[0] : pltSelected.clone();
	}
	
	public String getTxtEName() {
		return txtEName;
	}
	
	public String getHidEFile() {
		return hidEFile;
	}
	
	public String getEscTxtEName() {
		return escapeHTML(txtEName);
	}
	
	public String getEscLblEFile() {
		return escapeHTML(lblEFile);
	}
	
	public void setTxtEName(String ename) {
		txtEName = ename;
	}
	
	public void setHidEFile(String efile) {
		hidEFile = efile;
	}
	
	public void setLblEFile(String efile) {
		lblEFile = efile;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
