/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.action;

import java.util.Calendar;
import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.mospcommon.system.dao.CmAgreementWorkOnDao;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;
import jp.mosp.mospcommon.system.vo.WorkOnHolidayAgreementCardVo;

/**
 * @author matsusita
 *
 */
public class WorkOnHolidayAgreementCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_AGREEMENT_CARD_SHOW		= "S2535";
	private static final String	CMD_AGREEMENT_CARD_SELECT	= "S2536";
	private static final String	CMD_AGREEMENT_CARD_INSERT	= "S2537";
	private static final String	CMD_AGREEMENT_CARD_UPDATE	= "S2538";
	

	/**
	 * RXgN^
	 */
	public WorkOnHolidayAgreementCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AGREEMENT_CARD_SHOW)) {
			// \iVKo^j
			show();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkOnHolidayAgreementCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		WorkOnHolidayAgreementCardVo vo = (WorkOnHolidayAgreementCardVo)getVo();
		// jv_EXg쐬
		vo.aryPltDayOfWeek = new String[][]{ { String.valueOf(Calendar.SUNDAY), CommonConst.NAM_SUNDAY },
			{ String.valueOf(Calendar.MONDAY), CommonConst.NAM_MONDAY },
			{ String.valueOf(Calendar.TUESDAY), CommonConst.NAM_TUESDAY },
			{ String.valueOf(Calendar.WEDNESDAY), CommonConst.NAM_WEDNESDAY },
			{ String.valueOf(Calendar.THURSDAY), CommonConst.NAM_THURSDAY },
			{ String.valueOf(Calendar.FRIDAY), CommonConst.NAM_FRIDAY },
			{ String.valueOf(Calendar.SATURDAY), CommonConst.NAM_SATURDAY } };
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()));
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	@Override
	protected void show() {
		WorkOnHolidayAgreementCardVo vo = (WorkOnHolidayAgreementCardVo)getVo();
		// 
		vo.setDefaultValues();
		Date date = DateUtil.getSystemDate();
		// lݒ
		vo.setTxtStandardHolidayRate("125");
		vo.setTxtOfficialHolidayRate("135");
		vo.setPltStartDateYear(String.valueOf(MospUtility.getYear(date)));
		vo.setPltStartDateMonth(String.valueOf(MospUtility.getMonth(date)));
		vo.setPltStartDateDay(String.valueOf(MospUtility.getDay(date)));
		// [hݒ
		vo.setMode(WorkOnHolidayAgreementCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		WorkOnHolidayAgreementCardVo vo = (WorkOnHolidayAgreementCardVo)getVo();
		CmAgreementWorkOnDao dao = new CmAgreementWorkOnDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		CmAgreementWorkOnDto dto = dao.findForKey(Integer.parseInt(key1));
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		// [hݒ
		vo.setMode(WorkOnHolidayAgreementCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		WorkOnHolidayAgreementCardVo vo = (WorkOnHolidayAgreementCardVo)getVo();
		vo.setParams(request);
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		CmAgreementWorkOnDto dto = new CmAgreementWorkOnDto();
		vo.setDtoFields(dto);
		// DAȌ
		CmAgreementWorkOnDao dao = new CmAgreementWorkOnDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ől擾
		String max = dao.findForMax();
		if (StringUtil.isNull(max)) {
			max = "-1";
		}
		dto.setWorkOnId(Integer.parseInt(max) + 1);
		// d`FbN
		chkDuplicate(dao.findForKey(dto.getWorkOnId()));
		chkDuplicate(dao.findForStartDate(dto.getWorkOnCode(), dto.getStartDate()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		CmAgreementWorkOnDto retDto = dao.findForKey(dto.getWorkOnId());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(WorkOnHolidayAgreementCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmAgreementWorkOnDto dto = (CmAgreementWorkOnDto)getSessionDto();
		WorkOnHolidayAgreementCardVo vo = (WorkOnHolidayAgreementCardVo)getVo();
		vo.setParams(request);
		vo.setTxtWorkOnCode(dto.getWorkOnCode());
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		CmAgreementWorkOnDao dao = new CmAgreementWorkOnDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getWorkOnId()));
		boolean comitFlag = true;
		// d`FbN
		if (MospConst.DELETE_FLAG_OFF == dto.getDeleteFlag()) {
			CmAgreementWorkOnDto workOnDto = dao.findForStartDate(dto.getWorkOnCode(), dto.getStartDate());
			if (VariousUtil.isNotNull(workOnDto) && (workOnDto.getWorkOnId() != dto.getWorkOnId())) {
				addErrMessage(getMessage(MospConst.MSG_DUPLICATE, ""));
				comitFlag = false;
			}
		}
		if (comitFlag) {
			// f[^̍XV
			dao.update(dto);
			// DTO̍Ď擾
			CmAgreementWorkOnDto retDto = dao.findForKey(dto.getWorkOnId());
			chkUpdate(retDto);
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_UPDATE, ""));
			// ZbVDTOZbg
			setSessionDto(retDto);
		}
		// [hݒ
		vo.setMode(WorkOnHolidayAgreementCardVo.MODE_UPDATE);
	}
	
}
