/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dto.PmBasisDto;

public class PmBasisDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE					= "UM_BASIS";
	public static final String	KEY_1					= "K_CODE";			// ЈR[h
																				
	// 
	public static final String	COL_K_CODE				= "K_CODE";			// ЈR[h
	public static final String	COL_K_NAME				= "K_NAME";			// Ј
	public static final String	COL_K_KANA				= "K_KANA";			// Јض
	public static final String	COL_STATION_CODE		= "STATION_CODE";		// R[h
	public static final String	COL_POSITION_CODE		= "POSITION_CODE";		// EʃR[h
	public static final String	COL_EMPLOYMENT_TYPE		= "EMPLOYMENT_TYPE";	// ٗp敪
	public static final String	COL_ENTRANCE_DATE		= "ENTRANCE_DATE";		// Г
	public static final String	COL_APPOINTMENT_DATE	= "APPOINTMENT_DATE";	// op
	public static final String	COL_RETIREMENT_DATE		= "RETIREMENT_DATE";	// ގГ
																				
	
	/**
	 * RXgN^
	 */
	public PmBasisDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PmBasisDto> mappingAll() throws SQLException {
		List<PmBasisDto> all = new ArrayList<PmBasisDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PmBasisDto UmBasisR[h
	 * @throws SQLException
	 */
	private PmBasisDto mapping() throws SQLException {
		PmBasisDto dto = new PmBasisDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setKKana(rs.getString(COL_K_KANA)); // Јض
		dto.setStationCode(rs.getString(COL_STATION_CODE)); // R[h
		dto.setPositionCode(rs.getString(COL_POSITION_CODE)); // EʃR[h
		dto.setEmploymentType(rs.getString(COL_EMPLOYMENT_TYPE)); // ٗp敪
		dto.setEntranceDate(rs.getDate(COL_ENTRANCE_DATE)); // Г
		dto.setAppointmentDate(rs.getDate(COL_APPOINTMENT_DATE)); // op
		dto.setRetirementDate(rs.getDate(COL_RETIREMENT_DATE)); // ގГ
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmBasisDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PmBasisDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PmBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmBasisDto findForKey(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			PmBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return PmBasisDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmBasisDto findForUpdate(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			PmBasisDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(Αӓ-Јꗗp)
	 * @param kCode       ЈR[h
	 * @param kName       Ј
	 * @param stationCode R[h
	 * @param selfKCode   ЈR[h
	 * @param datalevel   Јf[^x
	 * @param startDate   ЈWvJn
	 * @param endDate     ЈWvI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PmBasisDto> findForCondition(String kCode, String kName, String stationCode, String selfKCode,
			int dataLevel, Date startDate, Date endDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
//		//UhBasisDao uhBasisDao = new UhBasisDao();
//		index = 1;
//		StringBuffer sb = new StringBuffer();
//		sb.append("WHERE ");
//		sb.append("(");
//		sb.append(COL_K_CODE + " LIKE ? ");
//		sb.append("AND ");
//		sb.append(COL_K_NAME + " LIKE ? ");
//		sb.append("AND ");
//		sb.append("(");
//		sb.append("("); // 
//		sb.append(COL_K_CODE + " = ? ");
//		sb.append("AND ");
//		sb.append(COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
//		sb.append(") ");
//		sb.append("OR ");
//		sb.append("("); // +f[^x
//		sb.append(COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
//		sb.append("AND ");
//		sb.append(COL_POSITION_CODE + " IN (" + PmPositionDao.getQueryForLowerLevel() + ") ");
//		sb.append(") ");
//		sb.append("OR ");
//		sb.append("("); // +(Superior)
//		sb.append(COL_STATION_CODE + " IN (" + PmStationDao.getStationQuery() + ") ");
//		sb.append("AND ");
//		sb.append(COL_K_CODE + " IN (" + PtSuperiorDao.getSuperiorQuery() + ") ");
//		sb.append(") ");
//		sb.append("OR ");
//		sb.append("("); // x+f[^x
//		sb.append(COL_K_CODE + " IN (" + PtSupportDao.getTermSupportQuery() + ") ");
//		sb.append("AND ");
//		sb.append(COL_POSITION_CODE + " IN (" + PmPositionDao.getQueryForLowerLevel() + ") ");
//		sb.append(")");
//		sb.append(") ");
//		sb.append("AND ");
//		sb.append(getSearchEmployeeStatement());
//		sb.append(") ");
//		/*
//		sb.append("OR ");
//		sb.append("(");
//		sb.append(	COL_K_CODE + " IN ");	// e[u
//		sb.append(	"(");
//		sb.append(		uhBasisDao.getQueryForEmployeeSelect());
//		sb.append(	")");
//		sb.append(") ");
//		*/
//		try {
//			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
//			// UM_BASIS
//			setParam(index++, kCode + "%");
//			setParam(index++, "%" + kName + "%");
//			setParam(index++, selfKCode);
//			setParam(index++, stationCode);
//			setParam(index++, stationCode);
//			setParam(index++, dataLevel);
//			setParam(index++, stationCode);
//			setParam(index++, selfKCode);
//			setParam(index++, stationCode);
//			setParam(index++, startDate);
//			setParam(index++, endDate);
//			setParam(index++, startDate);
//			setParam(index++, endDate);
//			setParam(index++, dataLevel);
//			setParam(index++, startDate);
//			/*
//			// UH_BASISpt
//			setParam(index++, endDate);
//			// UH_BASIS
//			setParam(index++, kCode + "%");
//			setParam(index++, "%" + kName + "%");
//			setParam(index++, selfKCode);
//			setParam(index++, stationCode);
//			setParam(index++, stationCode);
//			setParam(index++, dataLevel);
//			setParam(index++, stationCode);
//			setParam(index++, selfKCode);
//			setParam(index++, stationCode);
//			setParam(index++, startDate);
//			setParam(index++, endDate);
//			setParam(index++, startDate);
//			setParam(index++, endDate);
//			setParam(index++, dataLevel);
//			setParam(index++, startDate);
//			*/
//			// s
//			executeQuery();
//			List<PmBasisDto> list = mappingAll();
//			return list;
//		} catch (SQLException e) {
//			throw e;
//		} finally {
//			releaseResultSet();
//			releasePreparedStatement();
//		}
	}
	
	/**
	 * ɂf[^擾(l}X^ێ-Јꗗp)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PmBasisDto> findForHumanList(String kCode, String kName, String kKana, String stationCode,
			String positionCode, String retirementFlag) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_KANA + " LIKE ? ");
		
		this.pob.appendLike(COL_K_CODE);
		this.pob.appendLike(COL_K_NAME);
		this.pob.appendLike(COL_K_KANA);
		
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_STATION_CODE + " =  ? ");
			this.pob.appendWhere(COL_STATION_CODE, Query.FilterOperator.EQUAL);
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_POSITION_CODE + " = ? ");
			this.pob.appendWhere(COL_POSITION_CODE, Query.FilterOperator.EQUAL);
		}
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_OFF))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " IS NULL ");
			this.pob.appendIsNull(COL_RETIREMENT_DATE);
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_ON))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " IS NOT NULL ");
			this.pob.appendIsNotNull(COL_RETIREMENT_DATE);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			// s
			executeQuery();
			List<PmBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(ScƏǗ-Јꗗp)
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PmBasisDto> findForTrainerList(int authority) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		PmUserDao pmUserDao = new PmUserDao();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" IN ");
		sb.append("(");
		sb.append(pmUserDao.getSelectForSubQuery());
		sb.append(") ");
		sb.append(" AND ");
		sb.append(COL_RETIREMENT_DATE + " IS NULL ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, authority);
			// s
			executeQuery();
			List<PmBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾(R[h)
	 * @param stationCode    R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmBasisDto> findForStation(String stationCode, Date date) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") ");
		sb.append("AND ");
		sb.append(getSearchEmployeeStatement());
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForPosition());
			setParam(index++, stationCode);
			setParam(index++, date);
			executeQuery();
			List<PmBasisDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^݃`FbN
	 * @param  targetMode ݊mF[h
	 * @param  targetCode `FbNR[h(L[)
	 * @return PmBasisDto (DTO)
	 * @throws SQLException
	 */
	public int findForExist(String targetMode, String targetCode) throws SQLException {
		int count = 0;
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(*) FROM " + TABLE);
		sb.append(" WHERE ");
		
		this.setPreparedStatement(Mode.SELECT);
		
		if (targetMode.equals("station")) {
			sb.append(COL_STATION_CODE + " = ? ");
			this.pob.appendWhere(COL_STATION_CODE, Query.FilterOperator.EQUAL);
		} else if (targetMode.equals("position")) {
			sb.append(COL_POSITION_CODE + " = ? ");
			this.pob.appendWhere(COL_POSITION_CODE, Query.FilterOperator.EQUAL);
		} else if (targetMode.equals("employment")) {
			sb.append(COL_EMPLOYMENT_TYPE + " = ? ");
			this.pob.appendWhere(COL_EMPLOYMENT_TYPE, Query.FilterOperator.EQUAL);
		}
		try {
			index = 1;
			prepareStatement(sb.toString());
			setParam(index++, targetCode);
			executeQuery();
			rs.next();
			count = rs.getInt(1);
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PmBasisDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PmBasisDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getKName()); // Ј
		setParam(index++, dto.getKKana()); // Јض
		setParam(index++, dto.getStationCode()); // R[h
		setParam(index++, dto.getPositionCode()); // EʃR[h
		setParam(index++, dto.getEmploymentType()); // ٗp敪
		setParam(index++, dto.getEntranceDate()); // Г
		setParam(index++, dto.getAppointmentDate()); // Г
		setParam(index++, dto.getRetirementDate()); // ގГ
		setCommonParams(isInsert);
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	private String getSearchEmployeeStatement() {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_RETIREMENT_DATE + " IS NULL ");
		sb.append("OR ");
		sb.append(COL_RETIREMENT_DATE + " >= ?");
		sb.append(") ");
		return sb.toString();*/
	}
	
	/**
	 * ݐEЈR[h擾p擾SQL擾
	 * @return ݐEЈ擾pSQL
	 */
	public String getSearchEmployeeStatementCode() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(TABLE + ".");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(getSearchEmployeeStatement());
		
		this.setPreparedStatement(Mode.SELECT, TABLE);
		
		return sb.toString();
	}
	
	/**
	 * EʂɂבւSQL擾
	 * @return EʂɂבւSQL
	 */
	private String getOrderForPosition() {
		StringBuffer sb = new StringBuffer();
		sb.append("ORDER BY ");
		sb.append(COL_POSITION_CODE + ", ");
		sb.append(COL_EMPLOYMENT_TYPE + ", ");
		sb.append(COL_STATION_CODE + ", ");
		sb.append(COL_K_CODE + " ");
		return sb.toString();
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return ЈR[hTuNG[
	 */
	public String getSelectForSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_KANA + " LIKE ? ");
		
		this.setPreparedStatement(Mode.SELECT, TABLE);
		this.pob.appendLike(COL_K_CODE);
		this.pob.appendLike(COL_K_NAME);
		this.pob.appendLike(COL_K_KANA);
		
		return sb.toString();
	}
	
	/**
	 * ɂf[^擾(lǉo͗p)
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws IllegalAccessException
	 */
	public String getForAddHumanListSubQuery(String stationCode, String positionCode, String retirementFlag)
			throws IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " ");
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_KANA + " LIKE ? ");
		
		this.setPreparedStatement(Mode.SELECT, TABLE);
		this.pob.appendLike(COL_K_CODE);
		this.pob.appendLike(COL_K_NAME);
		this.pob.appendLike(COL_K_KANA);
		
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_STATION_CODE + " =  ? ");
			this.pob.appendWhere(COL_STATION_CODE, Query.FilterOperator.EQUAL);
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_POSITION_CODE + " = ? ");
			this.pob.appendWhere(COL_POSITION_CODE, Query.FilterOperator.EQUAL);
		}
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_OFF))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " IS NULL ");
			this.pob.appendIsNull(COL_RETIREMENT_DATE);
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(BonusConst.RETIREMENT_FLAG_ON))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " IS NOT NULL ");
			this.pob.appendIsNotNull(COL_RETIREMENT_DATE);
		}
		sb.append(getOrderForKey(getClass()));
		return sb.toString();
	}
	
}
