/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;
import java.util.Map;

import jp.mosp.common.common.BaseDto;
import jp.mosp.payroll.bonus.BonusConst;

public class BonusDetailDto extends BaseDto {
	
	private static final long	serialVersionUID	= 2613587750422757053L;
	
	// tB[h
	protected String			kCode				= "";					// ЈR[h
	protected Date				calcDate;									// vZN
	protected Date				payday;									// ^x
	protected String			calcStatus			= "";					// vZXe[^X
	protected String			kName				= "";					// Ј
	protected String			stationCode			= "";					// R[h
	protected String			positionCode		= "";					// EʃR[h
	protected String			employmentType		= "";					// ٗp敪
	protected Integer			bonusAllowance01;							// ܗ^x01
	protected Integer			bonusAllowance02;							// ܗ^x02
	protected Integer			bonusAllowance03;							// ܗ^x03
	protected Integer			bonusAllowance04;							// ܗ^x04
	protected Integer			bonusAllowance05;							// ܗ^x05
	protected Integer			bonusAllowance06;							// ܗ^x06
	protected Integer			bonusAllowance07;							// ܗ^x07
	protected Integer			bonusAllowance08;							// ܗ^x08
	protected Integer			bonusAllowance09;							// ܗ^x09
	protected Integer			bonusAllowance10;							// ܗ^x10
	protected Integer			bonusAllowance11;							// ܗ^x11
	protected Integer			bonusAllowance12;							// ܗ^x12
	protected Integer			bonusAllowance13;							// ܗ^x13
	protected Integer			bonusAllowance14;							// ܗ^x14
	protected Integer			bonusAllowance15;							// ܗ^x15
	protected Integer			bonusAllowance16;							// ܗ^x16
	protected Integer			bonusAllowance17;							// ܗ^x17
	protected Integer			bonusAllowance18;							// ܗ^x18
	protected Integer			bonusAllowance19;							// ܗ^x19
	protected Integer			bonusAllowance20;							// ܗ^x20
	protected Integer			healthInsurance;							// Nی
	protected Integer			pensionInsurance;							// Nی
	protected Integer			employeeInsurance;							// ٗpی
	protected Integer			incomeTax;									// 
	protected Integer			nursingInsurance;							// ی
	protected Integer			bonusDeduction06;							// ܗ^T06
	protected Integer			bonusDeduction07;							// ܗ^T07
	protected Integer			bonusDeduction08;							// ܗ^T08
	protected Integer			bonusDeduction09;							// ܗ^T09
	protected Integer			bonusDeduction10;							// ܗ^T10
	protected Integer			bonusDeduction11;							// ܗ^T11
	protected Integer			bonusDeduction12;							// ܗ^T12
	protected Integer			bonusDeduction13;							// ܗ^T13
	protected Integer			bonusDeduction14;							// ܗ^T14
	protected Integer			bonusDeduction15;							// ܗ^T15
	protected Integer			bonusDeduction16;							// ܗ^T16
	protected Integer			bonusDeduction17;							// ܗ^T17
	protected Integer			bonusDeduction18;							// ܗ^T18
	protected Integer			bonusDeduction19;							// ܗ^T19
	protected Integer			bonusDeduction20;							// ܗ^T20
	protected Integer			allowanceTotal;							// xz
	protected Integer			deductionTotal;							// Tz
	protected Integer			paymentTotal;								// xz
	protected Integer			bank1PayAmount;							// s1Uz
	protected Integer			bank2PayAmount;							// s2Uz
	protected Integer			cashPayAmount;								// xz
	protected Integer			dependentCount;							// }{̐
	protected Integer			lastMonthTaxation;							// O^̉ېőΏۊz
	protected Integer			totalYearBonus;							// Nx݌vܗ^z
																			
	protected String			belongCode;								// cƏR[h
																			
	protected String			titleAllowance01;							// x01^Cg
	protected String			titleAllowance02;							// x02^Cg
	protected String			titleAllowance03;							// x03^Cg
	protected String			titleAllowance04;							// x04^Cg
	protected String			titleAllowance05;							// x05^Cg
	protected String			titleAllowance06;							// x06^Cg
	protected String			titleAllowance07;							// x07^Cg
	protected String			titleAllowance08;							// x08^Cg
	protected String			titleAllowance09;							// x09^Cg
	protected String			titleAllowance10;							// x10^Cg
	protected String			titleAllowance11;							// x11^Cg
	protected String			titleAllowance12;							// x12^Cg
	protected String			titleAllowance13;							// x13^Cg
	protected String			titleAllowance14;							// x14^Cg
	protected String			titleAllowance15;							// x15^Cg
	protected String			titleAllowance16;							// x16^Cg
	protected String			titleAllowance17;							// x17^Cg
	protected String			titleAllowance18;							// x18^Cg
	protected String			titleAllowance19;							// x19^Cg
	protected String			titleAllowance20;							// x20^Cg
	protected String			titleDeduction01;							// T01^Cg
	protected String			titleDeduction02;							// T02^Cg
	protected String			titleDeduction03;							// T03^Cg
	protected String			titleDeduction04;							// T04^Cg
	protected String			titleDeduction05;							// T05^Cg
	protected String			titleDeduction06;							// T06^Cg
	protected String			titleDeduction07;							// T07^Cg
	protected String			titleDeduction08;							// T08^Cg
	protected String			titleDeduction09;							// T09^Cg
	protected String			titleDeduction10;							// T10^Cg
	protected String			titleDeduction11;							// T11^Cg
	protected String			titleDeduction12;							// T12^Cg
	protected String			titleDeduction13;							// T13^Cg
	protected String			titleDeduction14;							// T14^Cg
	protected String			titleDeduction15;							// T15^Cg
	protected String			titleDeduction16;							// T16^Cg
	protected String			titleDeduction17;							// T17^Cg
	protected String			titleDeduction18;							// T18^Cg
	protected String			titleDeduction19;							// T19^Cg
	protected String			titleDeduction20;							// T20^Cg
																			
	protected String			year;
	protected String			month;
	

	/**
	 * RXgN^
	 */
	public BonusDetailDto(PdBonusDto dto, Map<String, PsDetailDto> mapDetail) {
		super();
		// ^f[^Ƃɒlݒ
		kCode = dto.getKCode();
		calcDate = dto.getCalcDate();
		payday = dto.getPayday();
		calcStatus = dto.getCalcStatus();
		kName = dto.getKName();
		stationCode = dto.getStationCode();
		positionCode = dto.getPositionCode();
		employmentType = dto.getEmploymentType();
		
		allowanceTotal = new Integer(dto.getAllowanceTotal());
		deductionTotal = new Integer(dto.getDeductionTotal());
		paymentTotal = new Integer(dto.getPaymentTotal());
		bank1PayAmount = new Integer(dto.getBank1PayAmount());
		bank2PayAmount = new Integer(dto.getBank2PayAmount());
		cashPayAmount = new Integer(dto.getCashPayAmount());
		dependentCount = new Integer(dto.getDependentCount());
		lastMonthTaxation = new Integer(dto.getLastMonthTaxation());
		totalYearBonus = new Integer(dto.getTotalYearBonus());
		
		// אݒƂɒlݒ
		
		bonusAllowance01 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_01), dto
			.getBonusAllowance01());
		bonusAllowance02 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_02), dto
			.getBonusAllowance02());
		bonusAllowance03 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_03), dto
			.getBonusAllowance03());
		bonusAllowance04 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_04), dto
			.getBonusAllowance04());
		bonusAllowance05 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_05), dto
			.getBonusAllowance05());
		bonusAllowance06 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_06), dto
			.getBonusAllowance06());
		bonusAllowance07 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_07), dto
			.getBonusAllowance07());
		bonusAllowance08 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_08), dto
			.getBonusAllowance08());
		bonusAllowance09 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_09), dto
			.getBonusAllowance09());
		bonusAllowance10 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_10), dto
			.getBonusAllowance10());
		bonusAllowance11 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_11), dto
			.getBonusAllowance11());
		bonusAllowance12 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_12), dto
			.getBonusAllowance12());
		bonusAllowance13 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_13), dto
			.getBonusAllowance13());
		bonusAllowance14 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_14), dto
			.getBonusAllowance14());
		bonusAllowance15 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_15), dto
			.getBonusAllowance15());
		bonusAllowance16 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_16), dto
			.getBonusAllowance16());
		bonusAllowance17 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_17), dto
			.getBonusAllowance17());
		bonusAllowance18 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_18), dto
			.getBonusAllowance18());
		bonusAllowance19 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_19), dto
			.getBonusAllowance19());
		bonusAllowance20 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_20), dto
			.getBonusAllowance20());
		healthInsurance = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_01), dto
			.getHealthInsurance());
		pensionInsurance = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_02), dto
			.getPensionInsurance());
		employeeInsurance = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_03), dto
			.getEmployeeInsurance());
		incomeTax = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_04), dto.getIncomeTax());
		nursingInsurance = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_05), dto
			.getNursingInsurance());
		bonusDeduction06 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_06), dto
			.getBonusDeduction06());
		bonusDeduction06 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_07), dto
			.getBonusDeduction07());
		bonusDeduction08 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_08), dto
			.getBonusDeduction08());
		bonusDeduction09 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_09), dto
			.getBonusDeduction09());
		bonusDeduction10 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_10), dto
			.getBonusDeduction10());
		bonusDeduction11 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_11), dto
			.getBonusDeduction11());
		bonusDeduction12 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_12), dto
			.getBonusDeduction12());
		bonusDeduction13 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_13), dto
			.getBonusDeduction13());
		bonusDeduction14 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_14), dto
			.getBonusDeduction14());
		bonusDeduction15 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_15), dto
			.getBonusDeduction15());
		bonusDeduction16 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_16), dto
			.getBonusDeduction16());
		bonusDeduction17 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_17), dto
			.getBonusDeduction17());
		bonusDeduction18 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_18), dto
			.getBonusDeduction18());
		bonusDeduction19 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_19), dto
			.getBonusDeduction19());
		bonusDeduction20 = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_20), dto
			.getBonusDeduction20());
		
		titleAllowance01 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_01), bonusAllowance01);
		titleAllowance02 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_02), bonusAllowance02);
		titleAllowance03 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_03), bonusAllowance03);
		titleAllowance04 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_04), bonusAllowance04);
		titleAllowance05 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_05), bonusAllowance05);
		titleAllowance06 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_06), bonusAllowance06);
		titleAllowance07 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_07), bonusAllowance07);
		titleAllowance08 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_08), bonusAllowance08);
		titleAllowance09 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_09), bonusAllowance09);
		titleAllowance10 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_10), bonusAllowance10);
		titleAllowance11 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_11), bonusAllowance11);
		titleAllowance12 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_12), bonusAllowance12);
		titleAllowance13 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_13), bonusAllowance13);
		titleAllowance14 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_14), bonusAllowance14);
		titleAllowance15 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_15), bonusAllowance15);
		titleAllowance16 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_16), bonusAllowance16);
		titleAllowance17 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_17), bonusAllowance17);
		titleAllowance18 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_18), bonusAllowance18);
		titleAllowance19 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_19), bonusAllowance19);
		titleAllowance20 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_20), bonusAllowance20);
		titleDeduction01 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_01), healthInsurance);
		titleDeduction02 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_02), pensionInsurance);
		titleDeduction03 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_03), employeeInsurance);
		titleDeduction04 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_04), incomeTax);
		titleDeduction05 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_05), nursingInsurance);
		titleDeduction06 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_06), bonusDeduction06);
		titleDeduction07 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_07), bonusDeduction07);
		titleDeduction08 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_08), bonusDeduction08);
		titleDeduction09 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_09), bonusDeduction09);
		titleDeduction10 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_10), bonusDeduction10);
		titleDeduction11 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_11), bonusDeduction11);
		titleDeduction12 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_12), bonusDeduction12);
		titleDeduction13 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_13), bonusDeduction13);
		titleDeduction14 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_14), bonusDeduction14);
		titleDeduction15 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_15), bonusDeduction15);
		titleDeduction16 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_16), bonusDeduction16);
		titleDeduction17 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_17), bonusDeduction17);
		titleDeduction18 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_18), bonusDeduction18);
		titleDeduction19 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_19), bonusDeduction19);
		titleDeduction20 = getDetailName(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_20), bonusDeduction20);
		
	}
	
	/**
	 * אݒ擾B<br>
	 * @param mapDetail  אݒ
	 * @param detailCode אݒR[h
	 * @return
	 */
	private PsDetailDto getDetail(Map<String, PsDetailDto> mapDetail, String detailCode) {
		if (mapDetail == null) {
			return null;
		}
		return mapDetail.get(detailCode);
	}
	
	/**
	 * ז̂擾B<br>
	 * @param detail אݒ
	 * @param value  גl
	 * @return ז
	 */
	private String getDetailName(PsDetailDto detail, Integer value) {
		// אݒ肪ꍇ
		if (detail == null) {
			return "";
		}
		// 0~\ł0~̏ꍇ
		if ((value == null || value.intValue() == 0) && BonusConst.DISPLAY_NOT_ZERO.equals(detail.getDetailDisplay())) {
			return "";
		}
		// ȊȌꍇ
		return detail.getDetailName();
	}
	
	/**
	 * גl擾B<br>
	 * @param detail אݒ
	 * @param value  גl
	 * @return גl
	 */
	private Integer getDetailValue(PsDetailDto detail, int value) {
		// אݒ肪0~̏ꍇ
		if (detail == null && value == 0) {
			return null;
		}
		// אݒ肪0~\ł0~̏ꍇ
		if (detail != null && value == 0 && BonusConst.DISPLAY_NOT_ZERO.equals(detail.getDetailDisplay())) {
			return null;
		}
		// ȊȌꍇ
		return new Integer(value);
	}
	
	// ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public Date getCalcDate() {
		return getDateField(calcDate);
	} // vZN
	
	public Date getPayday() {
		return getDateField(payday);
	} // ^x
	
	public String getCalcStatus() {
		return calcStatus;
	} // vZXe[^X
	
	public String getKName() {
		return kName;
	} // Ј
	
	public String getStationCode() {
		return stationCode;
	} // R[h
	
	public String getPositionCode() {
		return positionCode;
	} // EʃR[h
	
	public String getEmploymentType() {
		return employmentType;
	} // ٗp敪
	
	public Integer getBonusAllowance01() {
		return bonusAllowance01;
	} // ܗ^x01
	
	public Integer getBonusAllowance02() {
		return bonusAllowance02;
	} // ܗ^x02
	
	public Integer getBonusAllowance03() {
		return bonusAllowance03;
	} // ܗ^x03
	
	public Integer getBonusAllowance04() {
		return bonusAllowance04;
	} // ܗ^x04
	
	public Integer getBonusAllowance05() {
		return bonusAllowance05;
	} // ܗ^x05
	
	public Integer getBonusAllowance06() {
		return bonusAllowance06;
	} // ܗ^x06
	
	public Integer getBonusAllowance07() {
		return bonusAllowance07;
	} // ܗ^x07
	
	public Integer getBonusAllowance08() {
		return bonusAllowance08;
	} // ܗ^x08
	
	public Integer getBonusAllowance09() {
		return bonusAllowance09;
	} // ܗ^x09
	
	public Integer getBonusAllowance10() {
		return bonusAllowance10;
	} // ܗ^x10
	
	public Integer getBonusAllowance11() {
		return bonusAllowance11;
	} // ܗ^x11
	
	public Integer getBonusAllowance12() {
		return bonusAllowance12;
	} // ܗ^x12
	
	public Integer getBonusAllowance13() {
		return bonusAllowance13;
	} // ܗ^x13
	
	public Integer getBonusAllowance14() {
		return bonusAllowance14;
	} // ܗ^x14
	
	public Integer getBonusAllowance15() {
		return bonusAllowance15;
	} // ܗ^x15
	
	public Integer getBonusAllowance16() {
		return bonusAllowance16;
	} // ܗ^x16
	
	public Integer getBonusAllowance17() {
		return bonusAllowance17;
	} // ܗ^x17
	
	public Integer getBonusAllowance18() {
		return bonusAllowance18;
	} // ܗ^x18
	
	public Integer getBonusAllowance19() {
		return bonusAllowance19;
	} // ܗ^x19
	
	public Integer getBonusAllowance20() {
		return bonusAllowance20;
	} // ܗ^x20
	
	public Integer getHealthInsurance() {
		return healthInsurance;
	} // Nی
	
	public Integer getPensionInsurance() {
		return pensionInsurance;
	} // Nی
	
	public Integer getEmployeeInsurance() {
		return employeeInsurance;
	} // ٗpی
	
	public Integer getIncomeTax() {
		return incomeTax;
	} // 
	
	public Integer getNursingInsurance() {
		return nursingInsurance;
	} // ی
	
	public Integer getBonusDeduction06() {
		return bonusDeduction06;
	} // ܗ^T06
	
	public Integer getBonusDeduction07() {
		return bonusDeduction07;
	} // ܗ^T07
	
	public Integer getBonusDeduction08() {
		return bonusDeduction08;
	} // ܗ^T08
	
	public Integer getBonusDeduction09() {
		return bonusDeduction09;
	} // ܗ^T09
	
	public Integer getBonusDeduction10() {
		return bonusDeduction10;
	} // ܗ^T10
	
	public Integer getBonusDeduction11() {
		return bonusDeduction11;
	} // ܗ^T11
	
	public Integer getBonusDeduction12() {
		return bonusDeduction12;
	} // ܗ^T12
	
	public Integer getBonusDeduction13() {
		return bonusDeduction13;
	} // ܗ^T13
	
	public Integer getBonusDeduction14() {
		return bonusDeduction14;
	} // ܗ^T14
	
	public Integer getBonusDeduction15() {
		return bonusDeduction15;
	} // ܗ^T15
	
	public Integer getBonusDeduction16() {
		return bonusDeduction16;
	} // ܗ^T16
	
	public Integer getBonusDeduction17() {
		return bonusDeduction17;
	} // ܗ^T17
	
	public Integer getBonusDeduction18() {
		return bonusDeduction18;
	} // ܗ^T18
	
	public Integer getBonusDeduction19() {
		return bonusDeduction19;
	} // ܗ^T19
	
	public Integer getBonusDeduction20() {
		return bonusDeduction20;
	} // ܗ^T20
	
	public Integer getAllowanceTotal() {
		return allowanceTotal;
	} // xz
	
	public Integer getDeductionTotal() {
		return deductionTotal;
	} // Tz
	
	public Integer getPaymentTotal() {
		return paymentTotal;
	} // xz
	
	public Integer getBank1PayAmount() {
		return bank1PayAmount;
	} // s1Uz
	
	public Integer getBank2PayAmount() {
		return bank2PayAmount;
	} // s2Uz
	
	public Integer getCashPayAmount() {
		return cashPayAmount;
	} // xz
	
	public Integer getDependentCount() {
		return dependentCount;
	} // }{̐
	
	public Integer getLastMonthTaxation() {
		return lastMonthTaxation;
	} // O^̉ېőΏۊz
	
	public Integer getTotalYearBonus() {
		return totalYearBonus;
	} // Nx݌vܗ^z
	
	public String getBelongCode() {
		return belongCode;
	} // cƏR[h
	
	public String getTitleAllowance01() {
		return titleAllowance01;
	} // x01^Cg
	
	public String getTitleAllowance02() {
		return titleAllowance02;
	} // x02^Cg
	
	public String getTitleAllowance03() {
		return titleAllowance03;
	} // x03^Cg
	
	public String getTitleAllowance04() {
		return titleAllowance04;
	} // x04^Cg
	
	public String getTitleAllowance05() {
		return titleAllowance05;
	} // x05^Cg
	
	public String getTitleAllowance06() {
		return titleAllowance06;
	} // x06^Cg
	
	public String getTitleAllowance07() {
		return titleAllowance07;
	} // x07^Cg
	
	public String getTitleAllowance08() {
		return titleAllowance08;
	} // x08^Cg
	
	public String getTitleAllowance09() {
		return titleAllowance09;
	} // x09^Cg
	
	public String getTitleAllowance10() {
		return titleAllowance10;
	} // x10^Cg
	
	public String getTitleAllowance11() {
		return titleAllowance11;
	} // x11^Cg
	
	public String getTitleAllowance12() {
		return titleAllowance12;
	} // x12^Cg
	
	public String getTitleAllowance13() {
		return titleAllowance13;
	} // x13^Cg
	
	public String getTitleAllowance14() {
		return titleAllowance14;
	} // x14^Cg
	
	public String getTitleAllowance15() {
		return titleAllowance15;
	} // x15^Cg
	
	public String getTitleAllowance16() {
		return titleAllowance16;
	} // x16^Cg
	
	public String getTitleAllowance17() {
		return titleAllowance17;
	} // x17^Cg
	
	public String getTitleAllowance18() {
		return titleAllowance18;
	} // x18^Cg
	
	public String getTitleAllowance19() {
		return titleAllowance19;
	} // x19^Cg
	
	public String getTitleAllowance20() {
		return titleAllowance20;
	} // x20^Cg
	
	public String getTitleDeduction01() {
		return titleDeduction01;
	} // T01^Cg
	
	public String getTitleDeduction02() {
		return titleDeduction02;
	} // T02^Cg
	
	public String getTitleDeduction03() {
		return titleDeduction03;
	} // T03^Cg
	
	public String getTitleDeduction04() {
		return titleDeduction04;
	} // T04^Cg
	
	public String getTitleDeduction05() {
		return titleDeduction05;
	} // T05^Cg
	
	public String getTitleDeduction06() {
		return titleDeduction06;
	} // T06^Cg
	
	public String getTitleDeduction07() {
		return titleDeduction07;
	} // T07^Cg
	
	public String getTitleDeduction08() {
		return titleDeduction08;
	} // T08^Cg
	
	public String getTitleDeduction09() {
		return titleDeduction09;
	} // T09^Cg
	
	public String getTitleDeduction10() {
		return titleDeduction10;
	} // T10^Cg
	
	public String getTitleDeduction11() {
		return titleDeduction11;
	} // T11^Cg
	
	public String getTitleDeduction12() {
		return titleDeduction12;
	} // T12^Cg
	
	public String getTitleDeduction13() {
		return titleDeduction13;
	} // T13^Cg
	
	public String getTitleDeduction14() {
		return titleDeduction14;
	} // T14^Cg
	
	public String getTitleDeduction15() {
		return titleDeduction15;
	} // T15^Cg
	
	public String getTitleDeduction16() {
		return titleDeduction16;
	} // T16^Cg
	
	public String getTitleDeduction17() {
		return titleDeduction17;
	} // T17^Cg
	
	public String getTitleDeduction18() {
		return titleDeduction18;
	} // T18^Cg
	
	public String getTitleDeduction19() {
		return titleDeduction19;
	} // T19^Cg
	
	public String getTitleDeduction20() {
		return titleDeduction20;
	} // T20^Cg
	
	public String getYear() {
		return year;
	}
	
	public String getMonth() {
		return month;
	}
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setCalcDate(Date calcDate) {
		this.calcDate = getDateField(calcDate);
	} // vZN
	
	public void setPayday(Date payday) {
		this.payday = getDateField(payday);
	} // ^x
	
	public void setCalcStatus(String calcStatus) {
		this.calcStatus = calcStatus;
	} // vZXe[^X
	
	public void setKName(String kName) {
		this.kName = kName;
	} // Ј
	
	public void setStationCode(String stationCode) {
		this.stationCode = stationCode;
	} // R[h
	
	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	} // EʃR[h
	
	public void setEmploymentType(String employmentType) {
		this.employmentType = employmentType;
	} // ٗp敪
	
	public void setBonusAllowance01(Integer bonusAllowance01) {
		this.bonusAllowance01 = bonusAllowance01;
	} // ܗ^x01
	
	public void setBonusAllowance02(Integer bonusAllowance02) {
		this.bonusAllowance02 = bonusAllowance02;
	} // ܗ^x02
	
	public void setBonusAllowance03(Integer bonusAllowance03) {
		this.bonusAllowance03 = bonusAllowance03;
	} // ܗ^x03
	
	public void setBonusAllowance04(Integer bonusAllowance04) {
		this.bonusAllowance04 = bonusAllowance04;
	} // ܗ^x04
	
	public void setBonusAllowance05(Integer bonusAllowance05) {
		this.bonusAllowance05 = bonusAllowance05;
	} // ܗ^x05
	
	public void setBonusAllowance06(Integer bonusAllowance06) {
		this.bonusAllowance06 = bonusAllowance06;
	} // ܗ^x06
	
	public void setBonusAllowance07(Integer bonusAllowance07) {
		this.bonusAllowance07 = bonusAllowance07;
	} // ܗ^x07
	
	public void setBonusAllowance08(Integer bonusAllowance08) {
		this.bonusAllowance08 = bonusAllowance08;
	} // ܗ^x08
	
	public void setBonusAllowance09(Integer bonusAllowance09) {
		this.bonusAllowance09 = bonusAllowance09;
	} // ܗ^x09
	
	public void setBonusAllowance10(Integer bonusAllowance10) {
		this.bonusAllowance10 = bonusAllowance10;
	} // ܗ^x10
	
	public void setBonusAllowance11(Integer bonusAllowance11) {
		this.bonusAllowance11 = bonusAllowance11;
	} // ܗ^x11
	
	public void setBonusAllowance12(Integer bonusAllowance12) {
		this.bonusAllowance12 = bonusAllowance12;
	} // ܗ^x12
	
	public void setBonusAllowance13(Integer bonusAllowance13) {
		this.bonusAllowance13 = bonusAllowance13;
	} // ܗ^x13
	
	public void setBonusAllowance14(Integer bonusAllowance14) {
		this.bonusAllowance14 = bonusAllowance14;
	} // ܗ^x14
	
	public void setBonusAllowance15(Integer bonusAllowance15) {
		this.bonusAllowance15 = bonusAllowance15;
	} // ܗ^x15
	
	public void setBonusAllowance16(Integer bonusAllowance16) {
		this.bonusAllowance16 = bonusAllowance16;
	} // ܗ^x16
	
	public void setBonusAllowance17(Integer bonusAllowance17) {
		this.bonusAllowance17 = bonusAllowance17;
	} // ܗ^x17
	
	public void setBonusAllowance18(Integer bonusAllowance18) {
		this.bonusAllowance18 = bonusAllowance18;
	} // ܗ^x18
	
	public void setBonusAllowance19(Integer bonusAllowance19) {
		this.bonusAllowance19 = bonusAllowance19;
	} // ܗ^x19
	
	public void setBonusAllowance20(Integer bonusAllowance20) {
		this.bonusAllowance20 = bonusAllowance20;
	} // ܗ^x20
	
	public void setHealthInsurance(Integer healthInsurance) {
		this.healthInsurance = healthInsurance;
	} // Nی
	
	public void setPensionInsurance(Integer pensionInsurance) {
		this.pensionInsurance = pensionInsurance;
	} // Nی
	
	public void setEmployeeInsurance(Integer employeeInsurance) {
		this.employeeInsurance = employeeInsurance;
	} // ٗpی
	
	public void setIncomeTax(Integer incomeTax) {
		this.incomeTax = incomeTax;
	} // 
	
	public void setNursingInsurance(Integer nursingInsurance) {
		this.nursingInsurance = nursingInsurance;
	} // ی
	
	public void setBonusDeduction06(Integer bonusDeduction06) {
		this.bonusDeduction06 = bonusDeduction06;
	} // ܗ^T06
	
	public void setBonusDeduction07(Integer bonusDeduction07) {
		this.bonusDeduction07 = bonusDeduction07;
	} // ܗ^T07
	
	public void setBonusDeduction08(Integer bonusDeduction08) {
		this.bonusDeduction08 = bonusDeduction08;
	} // ܗ^T08
	
	public void setBonusDeduction09(Integer bonusDeduction09) {
		this.bonusDeduction09 = bonusDeduction09;
	} // ܗ^T09
	
	public void setBonusDeduction10(Integer bonusDeduction10) {
		this.bonusDeduction10 = bonusDeduction10;
	} // ܗ^T10
	
	public void setBonusDeduction11(Integer bonusDeduction11) {
		this.bonusDeduction11 = bonusDeduction11;
	} // ܗ^T11
	
	public void setBonusDeduction12(Integer bonusDeduction12) {
		this.bonusDeduction12 = bonusDeduction12;
	} // ܗ^T12
	
	public void setBonusDeduction13(Integer bonusDeduction13) {
		this.bonusDeduction13 = bonusDeduction13;
	} // ܗ^T13
	
	public void setBonusDeduction14(Integer bonusDeduction14) {
		this.bonusDeduction14 = bonusDeduction14;
	} // ܗ^T14
	
	public void setBonusDeduction15(Integer bonusDeduction15) {
		this.bonusDeduction15 = bonusDeduction15;
	} // ܗ^T15
	
	public void setBonusDeduction16(Integer bonusDeduction16) {
		this.bonusDeduction16 = bonusDeduction16;
	} // ܗ^T16
	
	public void setBonusDeduction17(Integer bonusDeduction17) {
		this.bonusDeduction17 = bonusDeduction17;
	} // ܗ^T17
	
	public void setBonusDeduction18(Integer bonusDeduction18) {
		this.bonusDeduction18 = bonusDeduction18;
	} // ܗ^T18
	
	public void setBonusDeduction19(Integer bonusDeduction19) {
		this.bonusDeduction19 = bonusDeduction19;
	} // ܗ^T19
	
	public void setBonusDeduction20(Integer bonusDeduction20) {
		this.bonusDeduction20 = bonusDeduction20;
	} // ܗ^T20
	
	public void setAllowanceTotal(Integer allowanceTotal) {
		this.allowanceTotal = allowanceTotal;
	} // xz
	
	public void setDeductionTotal(Integer deductionTotal) {
		this.deductionTotal = deductionTotal;
	} // Tz
	
	public void setPaymentTotal(Integer paymentTotal) {
		this.paymentTotal = paymentTotal;
	} // xz
	
	public void setBank1PayAmount(Integer bank1PayAmount) {
		this.bank1PayAmount = bank1PayAmount;
	} // s1Uz
	
	public void setBank2PayAmount(Integer bank2PayAmount) {
		this.bank2PayAmount = bank2PayAmount;
	} // s2Uz
	
	public void setCashPayAmount(Integer cashPayAmount) {
		this.cashPayAmount = cashPayAmount;
	} // xz
	
	public void setDependentCount(Integer dependentCount) {
		this.dependentCount = dependentCount;
	} // }{̐
	
	public void setLastMonthTaxation(Integer lastMonthTaxation) {
		this.lastMonthTaxation = lastMonthTaxation;
	} // }{̐
	
	public void setTotalYearBonus(Integer totalYearBonus) {
		this.totalYearBonus = totalYearBonus;
	} // }{̐
	
	public void setBelongCode(String belongCode) {
		this.belongCode = belongCode;
	} // R[h
	
	public void setTitleAllowance01(String titleAllowance01) {
		this.titleAllowance01 = titleAllowance01;
	} // x01^Cg
	
	public void setTitleAllowance02(String titleAllowance02) {
		this.titleAllowance02 = titleAllowance02;
	} // x02^Cg
	
	public void setTitleAllowance03(String titleAllowance03) {
		this.titleAllowance03 = titleAllowance03;
	} // x03^Cg
	
	public void setTitleAllowance04(String titleAllowance04) {
		this.titleAllowance04 = titleAllowance04;
	} // x04^Cg
	
	public void setTitleAllowance05(String titleAllowance05) {
		this.titleAllowance05 = titleAllowance05;
	} // x05^Cg
	
	public void setTitleAllowance06(String titleAllowance06) {
		this.titleAllowance06 = titleAllowance06;
	} // x06^Cg
	
	public void setTitleAllowance07(String titleAllowance07) {
		this.titleAllowance07 = titleAllowance07;
	} // x07^Cg
	
	public void setTitleAllowance08(String titleAllowance08) {
		this.titleAllowance08 = titleAllowance08;
	} // x08^Cg
	
	public void setTitleAllowance09(String titleAllowance09) {
		this.titleAllowance09 = titleAllowance09;
	} // x09^Cg
	
	public void setTitleAllowance10(String titleAllowance10) {
		this.titleAllowance10 = titleAllowance10;
	} // x10^Cg
	
	public void setTitleAllowance11(String titleAllowance11) {
		this.titleAllowance11 = titleAllowance11;
	} // x11^Cg
	
	public void setTitleAllowance12(String titleAllowance12) {
		this.titleAllowance12 = titleAllowance12;
	} // x12^Cg
	
	public void setTitleAllowance13(String titleAllowance13) {
		this.titleAllowance13 = titleAllowance13;
	} // x13^Cg
	
	public void setTitleAllowance14(String titleAllowance14) {
		this.titleAllowance14 = titleAllowance14;
	} // x14^Cg
	
	public void setTitleAllowance15(String titleAllowance15) {
		this.titleAllowance15 = titleAllowance15;
	} // x15^Cg
	
	public void setTitleAllowance16(String titleAllowance16) {
		this.titleAllowance16 = titleAllowance16;
	} // x16^Cg
	
	public void setTitleAllowance17(String titleAllowance17) {
		this.titleAllowance17 = titleAllowance17;
	} // x17^Cg
	
	public void setTitleAllowance18(String titleAllowance18) {
		this.titleAllowance18 = titleAllowance18;
	} // x18^Cg
	
	public void setTitleAllowance19(String titleAllowance19) {
		this.titleAllowance19 = titleAllowance19;
	} // x19^Cg
	
	public void setTitleAllowance20(String titleAllowance20) {
		this.titleAllowance20 = titleAllowance20;
	} // x20^Cg
	
	public void setTitleDeduction01(String titleDeduction01) {
		this.titleDeduction01 = titleDeduction01;
	} // T01^Cg
	
	public void setTitleDeduction02(String titleDeduction02) {
		this.titleDeduction02 = titleDeduction02;
	} // T02^Cg
	
	public void setTitleDeduction03(String titleDeduction03) {
		this.titleDeduction03 = titleDeduction03;
	} // T03^Cg
	
	public void setTitleDeduction04(String titleDeduction04) {
		this.titleDeduction04 = titleDeduction04;
	} // T04^Cg
	
	public void setTitleDeduction05(String titleDeduction05) {
		this.titleDeduction05 = titleDeduction05;
	} // T05^Cg
	
	public void setTitleDeduction06(String titleDeduction06) {
		this.titleDeduction06 = titleDeduction06;
	} // T06^Cg
	
	public void setTitleDeduction07(String titleDeduction07) {
		this.titleDeduction07 = titleDeduction07;
	} // T07^Cg
	
	public void setTitleDeduction08(String titleDeduction08) {
		this.titleDeduction08 = titleDeduction08;
	} // T08^Cg
	
	public void setTitleDeduction09(String titleDeduction09) {
		this.titleDeduction09 = titleDeduction09;
	} // T09^Cg
	
	public void setTitleDeduction10(String titleDeduction10) {
		this.titleDeduction10 = titleDeduction10;
	} // T10^Cg
	
	public void setTitleDeduction11(String titleDeduction11) {
		this.titleDeduction11 = titleDeduction11;
	} // T11^Cg
	
	public void setTitleDeduction12(String titleDeduction12) {
		this.titleDeduction12 = titleDeduction12;
	} // T12^Cg
	
	public void setTitleDeduction13(String titleDeduction13) {
		this.titleDeduction13 = titleDeduction13;
	} // T13^Cg
	
	public void setTitleDeduction14(String titleDeduction14) {
		this.titleDeduction14 = titleDeduction14;
	} // T14^Cg
	
	public void setTitleDeduction15(String titleDeduction15) {
		this.titleDeduction15 = titleDeduction15;
	} // T15^Cg
	
	public void setTitleDeduction16(String titleDeduction16) {
		this.titleDeduction16 = titleDeduction16;
	} // T16^Cg
	
	public void setTitleDeduction17(String titleDeduction17) {
		this.titleDeduction17 = titleDeduction17;
	} // T17^Cg
	
	public void setTitleDeduction18(String titleDeduction18) {
		this.titleDeduction18 = titleDeduction18;
	} // T18^Cg
	
	public void setTitleDeduction19(String titleDeduction19) {
		this.titleDeduction19 = titleDeduction19;
	} // T19^Cg
	
	public void setTitleDeduction20(String titleDeduction20) {
		this.titleDeduction20 = titleDeduction20;
	} // T20^Cg
	
	public void setYear(String year) {
		this.year = year;
	}
	
	public void setMonth(String month) {
		this.month = month;
	}
	
}
