/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.payroll.common.part;

import jp.mosp.common.common.MospException;
import jp.mosp.common.part.PartInfo;
import jp.mosp.kintai.common.part.KintaiPartStore;

/**
 * @author koike
 *
 */
public class PayrollPartStore extends KintaiPartStore {
	
	/**
	 * RXgN^
	 */
	public PayrollPartStore() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo Part𗘗pۂɕKvȏ
	 */
	private PayrollPartStore(PartInfo partInfo) {
		this();
		setPartInfo(partInfo);
	}
	
	/**
	 * PayrollPartStoreCX^X
	 * @param partInfo		Part𗘗pۂɕKvȏ
	 * @return	PayrollPartStoreCX^X
	 */
	public static PayrollPartStore getInstance(PartInfo partInfo) {
		return new PayrollPartStore(partInfo);
	}
	
	/**
	 * PayrollMosPMenuPartCX^X擾
	 * @return	ςPayrollMosPMenuPartCX^X
	 * @throws MospException MosPOꍇ
	 */
	public PayrollMosPMenuPart payrollMenu() throws MospException {
		return (PayrollMosPMenuPart)get(PayrollMosPMenuPart.class);
	}
}
