/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmCityDto;

public class CmCityDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE					= "CM_CITY";
	public static final String	KEY_1					= "CITY_CODE";			// sR[h
																				
	// 
	public static final String	COL_CITY_CODE			= "CITY_CODE";			// sR[h
	public static final String	COL_CITY_NAME			= "CITY_NAME";			// s
	public static final String	COL_CITY_KANA			= "CITY_KANA";			// sJi
	public static final String	COL_CITY_ACCOUNT		= "CITY_ACCOUNT";		// sԍ
	public static final String	COL_CITY_ACCOUNT_NAME1	= "CITY_ACCOUNT_NAME1"; // 1
	public static final String	COL_CITY_ACCOUNT_NAME2	= "CITY_ACCOUNT_NAME2"; // 2
	public static final String	COL_DESIGNATED_NUMBER	= "DESIGNATED_NUMBER";	// wԍ
	public static final String	COL_CO_BANK_CODE		= "CO_BANK_CODE";		// ЋsR[h
	public static final String	COL_MASTER_OFFICE		= "MASTER_OFFICE";		// ܂Ƃߋ
	public static final String	COL_CITY_POSTAL_CODE	= "CITY_POSTAL_CODE";	// sX֔ԍ
	public static final String	COL_CITY_ADDRESS1		= "CITY_ADDRESS1";		// sZ1
	public static final String	COL_CITY_ADDRESS2		= "CITY_ADDRESS2";		// sZ2
	public static final String	COL_CITY_OFFICE1		= "CITY_OFFICE1";		// ꖼ1
	public static final String	COL_CITY_OFFICE2		= "CITY_OFFICE2";		// ꖼ2
	public static final String	COL_CITY_PHONE			= "CITY_PHONE";		// sdbԍ
																				
	
	/**
	 * RXgN^
	 */
	public CmCityDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmCityDto> mappingAll() throws SQLException {
		List<CmCityDto> all = new ArrayList<CmCityDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmCityDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private CmCityDto mapping() throws SQLException {
		CmCityDto dto = new CmCityDto();
		dto.setCityCode(rs.getString(COL_CITY_CODE)); // sR[h
		dto.setCityName(rs.getString(COL_CITY_NAME)); // s
		dto.setCityKana(rs.getString(COL_CITY_KANA)); // sJi
		dto.setCityAccount(rs.getString(COL_CITY_ACCOUNT)); // sԍ
		dto.setCityAccountName1(rs.getString(COL_CITY_ACCOUNT_NAME1)); // 1
		dto.setCityAccountName2(rs.getString(COL_CITY_ACCOUNT_NAME2)); // 2
		dto.setDesignatedNumber(rs.getString(COL_DESIGNATED_NUMBER)); // wԍ
		dto.setCoBankCode(rs.getString(COL_CO_BANK_CODE)); // ЋsR[h
		dto.setMasterOffice(rs.getString(COL_MASTER_OFFICE)); // ܂Ƃߋ
		dto.setCityPostalCode(rs.getString(COL_CITY_POSTAL_CODE)); // sX֔ԍ
		dto.setCityAddress1(rs.getString(COL_CITY_ADDRESS1)); // sZ1
		dto.setCityAddress2(rs.getString(COL_CITY_ADDRESS2)); // sZ2
		dto.setCityOffice1(rs.getString(COL_CITY_OFFICE1)); // ꖼ1
		dto.setCityOffice2(rs.getString(COL_CITY_OFFICE2)); // ꖼ2
		dto.setCityPhone(rs.getString(COL_CITY_PHONE)); // sdbԍ
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCityDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmCityDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param cityCode      s撬R[h(L[)
	 * @return CmCityDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCityDto findForKey(String cityCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, cityCode);
			executeQuery();
			CmCityDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param cityCode      s撬R[h(L[)
	 * @return CmCityDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCityDto findForUpdate(String cityCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, cityCode);
			executeQuery();
			CmCityDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param cityCode         sR[h(L[)
	 * @param cityName         s(L[)
	 * @param cityKana         ض(L[)
	 * @param designatedNumber ԍ(L[)
	 * @param coBankCode       ЋsR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCityDto> findForCondition(String cityCode, String cityName, String cityKana, String designatedNumber,
			String coBankCode

	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		if (cityCode != null && !cityCode.equals("") || cityName != null && !cityName.equals("") || cityKana != null
				&& !cityKana.equals("") || designatedNumber != null && !designatedNumber.equals("")
				|| coBankCode != null && !coBankCode.equals("")) {
			sb.append("WHERE ");
		}
		if (cityCode != null && !cityCode.equals("")) {
			sb.append(COL_CITY_CODE + "  like  ? ");
			this.pob.appendLike(COL_CITY_CODE);
			if (cityName != null && !cityName.equals("") || cityKana != null && !cityKana.equals("")
					|| designatedNumber != null && !designatedNumber.equals("") || coBankCode != null
					&& !coBankCode.equals("")) {
				sb.append("AND ");
				
			}
		}
		if (cityName != null && !cityName.equals("")) {
			sb.append(COL_CITY_NAME + "  like  ? ");
			this.pob.appendLike(COL_CITY_NAME);
			if (cityKana != null && !cityKana.equals("") || designatedNumber != null && !designatedNumber.equals("")
					|| coBankCode != null && !coBankCode.equals("")) {
				sb.append("AND ");
				
			}
		}
		if (cityKana != null && !cityKana.equals("")) {
			sb.append(COL_CITY_KANA + "  like  ? ");
			this.pob.appendLike(COL_CITY_KANA);
			if (designatedNumber != null && !designatedNumber.equals("") || coBankCode != null
					&& !coBankCode.equals("")) {
				sb.append("AND ");
				
			}
		}
		if (designatedNumber != null && !designatedNumber.equals("")) {
			sb.append(COL_DESIGNATED_NUMBER + "  like  ? ");
			this.pob.appendLike(COL_DESIGNATED_NUMBER);
			if (coBankCode != null && !coBankCode.equals("")) {
				sb.append("AND ");
				
			}
		}
		if (coBankCode != null && !coBankCode.equals("")) {
			sb.append(COL_CO_BANK_CODE + "  =  ? ");
			this.pob.appendWhere(COL_CO_BANK_CODE, Query.FilterOperator.EQUAL);
		}
		
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (cityCode != null && !cityCode.equals("")) {
				setParam(index++, cityCode + "%");
			}
			if (cityName != null && !cityName.equals("")) {
				setParam(index++, "%" + cityName + "%");
			}
			if (cityKana != null && !cityKana.equals("")) {
				setParam(index++, "%" + cityKana + "%");
			}
			if (designatedNumber != null && !designatedNumber.equals("")) {
				setParam(index++, designatedNumber + "%");
			}
			if (coBankCode != null && !coBankCode.equals("")) {
				setParam(index++, coBankCode);
			}
			
			executeQuery();
			List<CmCityDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param coBankCode ЋsR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCityDto> findForFirmBanking(String coBankCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CO_BANK_CODE + "  =  ? ");
		this.pob.appendWhere(COL_CO_BANK_CODE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, coBankCode);
			executeQuery();
			List<CmCityDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCityDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCityDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmCityDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getCityCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmCityDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getCityCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmCityDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getCityCode()); // sR[h
		setParam(index++, dto.getCityName()); // s
		setParam(index++, dto.getCityKana()); // sJi
		setParam(index++, dto.getCityAccount()); // sԍ
		setParam(index++, dto.getCityAccountName1()); // 1
		setParam(index++, dto.getCityAccountName2()); // 2
		setParam(index++, dto.getDesignatedNumber()); // wԍ
		setParam(index++, dto.getCoBankCode()); // ЋsR[h
		setParam(index++, dto.getMasterOffice()); // ܂Ƃߋ
		setParam(index++, dto.getCityPostalCode()); // sX֔ԍ
		setParam(index++, dto.getCityAddress1()); // sZ1
		setParam(index++, dto.getCityAddress2()); // sZ2
		setParam(index++, dto.getCityOffice1()); // ꖼ1
		setParam(index++, dto.getCityOffice2()); // ꖼ2
		setParam(index++, dto.getCityPhone()); // sdbԍ
		
		setCommonParams(isInsert);
	}
	
}
