/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.payroll.dto.CompileAmendmentDto;

/**
 * @author yoshida
 *
 */
public class CompileAmendmentListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -8518087820826308466L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 0;
	/**
	 * 
	 */
	public static final int		MODE_POSSIBLE		= 1;
	
	// p[^
	/**
	 * txtKCode
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * txtKName
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * pltSection
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	/**
	 * pltApproval
	 */
	public static final String	PRM_PLT_APPROVAL	= "pltApproval";
	/**
	 * pltCompile
	 */
	public static final String	PRM_PLT_COMPILE		= "pltCompile";
	/**
	 * hidSelectDate
	 */
	public static final String	PRM_HID_SELECT_DATE	= "hidSelectDate";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_CALCULATE_TARGET;
	/**
	 * 
	 */
	public String				NAM_APPROVAL;
	/**
	 * 
	 */
	public String				NAM_COMPILE;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_NAME;
	
	// tB[h
	private String				txtKCode;
	private String				txtKName;
	private String				pltSection;
	private String				pltYear;
	private String				pltMonth;
	private String				pltApproval;
	private String				pltCompile;
	private String				hidSelectDate;
	
	private String[][]			aryCompile;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	/**
	 * 
	 */
	public String[][]			aryPltApprovalFlag;
	/**
	 * 
	 */
	public String[][]			aryPltCompileFlag;
	
	// \[gL[
	/**
	 * keyKCode
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * keyKName
	 */
	public final String			KEY_K_NAME			= "keyKName";
	/**
	 * keySection
	 */
	public final String			KEY_SECTION			= "keySection";
	
	// [h(0FȂA1F)
	private int					searchmode;
	
	// ΑӏF@\[h(0FLA1F)
	private int					mode;
	
	private boolean				useOver60Hour;
	

	/**
	 * RXgN^
	 */
	public CompileAmendmentListVo() {
		super();
		setViewPath(getClassName());
		mode = MODE_IMPOSSIBLE;
		txtKCode = "";
		txtKName = "";
		pltSection = "";
		pltYear = "";
		pltMonth = "";
		pltApproval = "";
		pltCompile = "";
		hidSelectDate = "";
		setFormerKey(KEY_K_CODE);
		aryCompile = new String[0][0];
		searchmode = SEARCH_OFF;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_AMENDMENT;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_CALCULATE_TARGET = CommonConst.NAM_TARGET_MONTH;
		NAM_APPROVAL = CommonConst.NAM_REMAIN_APPROVED;
		NAM_COMPILE = CommonConst.NAM_REMAIN_COMPILE;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		pltApproval = request.getParameter(PRM_PLT_APPROVAL);
		pltCompile = request.getParameter(PRM_PLT_COMPILE);
	}
	
	/**
	 * tB[hݒ
	 * @param listCompile ΑӏWvʃXg
	 */
	@Override
	public void setFields(List<?> listCompile) {
		// Xg̐ݒ
		list = listCompile;
		// f[^̎擾
		count = list.size();
		// z̏
		aryCompile = new String[count][16];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = list.iterator();
		while (it.hasNext()) {
			CompileAmendmentDto dto = (CompileAmendmentDto)it.next();
			aryCompile[i][0] = escapeHTML(dto.getKCode());
			aryCompile[i][1] = escapeHTML(dto.getKName());
			aryCompile[i][2] = escapeHTML(dto.getSCode());
			aryCompile[i][3] = String.valueOf(dto.getSNissu());
			aryCompile[i][4] = String.valueOf(dto.getYukyu());
			aryCompile[i][5] = String.valueOf(dto.getTokuKyu());
			aryCompile[i][6] = String.valueOf(dto.getKekkin());
			aryCompile[i][7] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
			aryCompile[i][8] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
			aryCompile[i][9] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTisoJi()));
			aryCompile[i][10] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getZaJikan()));
			aryCompile[i][11] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKsJikan()));
			aryCompile[i][12] = TimeUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSnJikan()));
			// FL
			aryCompile[i][13] = getCodeName(StringUtil.convTrueIsOff(dto.isApprovedFlag()), aryPltApprovalFlag);
			aryCompile[i][14] = getCodeName(StringUtil.convTrueIsOff(dto.isCompiledFlag()), aryPltCompileFlag);
			aryCompile[i][15] = "";
			// ԊOx
			if (useOver60Hour) {
				if (dto.getZaJikan() > dto.getCautionMonthly() && dto.getCautionMonthly() > 0) {
					aryCompile[i][15] = CommonConst.CSS_CLASS_CAUTION_TD;
				}
				if (dto.getZaJikan() > CommonConst.NUM_OVER_TIME_60_HOUR) {
					aryCompile[i][15] = CommonConst.CSS_CLASS_WARNING_TD;
				}
			}
			i++;
		}
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return txtKName
	 */
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	/**
	 * @return pltApproval
	 */
	public String getEscPltApproval() {
		return escapeHTML(pltApproval);
	}
	
	/**
	 * @return pltCompile
	 */
	public String getEscPltCompile() {
		return escapeHTML(pltCompile);
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return pltApproval
	 */
	public String getPltApproval() {
		return pltApproval;
	}
	
	/**
	 * @return pltCompile
	 */
	public String getPltCompile() {
		return pltCompile;
	}
	
	/**
	 * @return hidSelectDate
	 */
	public String getHidSelectDate() {
		return hidSelectDate;
	}
	
	/**
	 * @return aryCompile
	 */
	public String[][] getAryCompile() {
		return aryCompile.clone();
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param pltApproval Zbg pltApproval
	 */
	public void setPltApproval(String pltApproval) {
		this.pltApproval = pltApproval;
	}
	
	/**
	 * @param pltCompile Zbg pltCompile
	 */
	public void setPltCompile(String pltCompile) {
		this.pltCompile = pltCompile;
	}
	
	/**
	 * @param hidSelectDate Zbg hidSelectDate
	 */
	public void setHidSelectDate(String hidSelectDate) {
		this.hidSelectDate = hidSelectDate;
	}
	
	/**
	 * @param aryCompile Zbg aryCompile
	 */
	public void setAryCompile(String[][] aryCompile) {
		this.aryCompile = aryCompile.clone();
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return useOver60Hour
	 */
	public boolean isUseOver60Hour() {
		return useOver60Hour;
	}
	
	/**
	 * @param useOver60Hour Zbg useOver60Hour
	 */
	public void setUseOver60Hour(boolean useOver60Hour) {
		this.useOver60Hour = useOver60Hour;
	}
	
}
