/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.vo.DayApprovalCardVo;

/**
 * @author yoshida
 *
 */
public class DayApprovalCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_CARD_SELECT		= "K2146";
	private static final String	CMD_CARD_APPROVED	= "K2147";
	private static final String	CMD_CARD_RETURNED	= "K2148";
	

	/**
	 * 
	 */
	public DayApprovalCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (CMD_CARD_SELECT.equals(cmd)) {
			// \(L[ŏ)
			select();
		} else if (CMD_CARD_APPROVED.equals(cmd)) {
			// F
			approved();
		} else if (CMD_CARD_RETURNED.equals(cmd)) {
			// 
			returned();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new DayApprovalCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// 蓖ꗗ
		vo.setAryAllowance(getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME));
	}
	
	@Override
	protected void select() throws Exception {
		MSyukkinboDto dto = kintai().getSyukkinboInfo(key1, key2);
		chkExist(dto);
		// F󋵂̐ݒ
		setFields(dto);
	}
	
	/**
	 * ΑӏF
	 * @throws Exception 	Oꍇ
	 */
	private void approved() throws Exception {
		// DTO̎擾
		MSyukkinboDto dto = (MSyukkinboDto)getSessionDto();
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		// rmF
		chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
		// DTO̍Ď擾
		MSyukkinboDto retDto = dto;
		// F
		if (runDailyApprovalProcess(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke()), vo.getTxtComment(),
				true)) {
			// R~bg
			commit();
			// DTO̍Ď擾
			retDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
			chkUpdate(retDto);
			// bZ[Wݒ
			if (KintaiApprovalPart.is1stApproved(retDto)) {
				setMessage(getMessage(CommonConst.MSG_DONE, CommonConst.NAM_1ST_APPROVED));
			}
			if (KintaiApprovalPart.is2ndApproved(retDto)) {
				setMessage(getMessage(CommonConst.MSG_DONE, CommonConst.NAM_2ND_APPROVED));
			}
		}
		// VOɏZbg
		setFields(retDto);
	}
	
	/**
	 * ΑӍߏ
	 * @throws Exception 	Oꍇ
	 */
	private void returned() throws Exception {
		// DTO̎擾
		MSyukkinboDto dto = (MSyukkinboDto)getSessionDto();
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
		// DTO̍Ď擾
		MSyukkinboDto retDto = dto;
		// ߏ
		if (runDailyApprovalProcess(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke()), vo.getTxtComment(),
				false)) {
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(CommonConst.MSG_APPROVAL_RETURNED, ""));
			// DTO̍Ď擾
			retDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
			chkUpdate(retDto);
		}
		// VOɏZbg
		setFields(retDto);
	}
	
	/**
	 * ΑӏVOZbg
	 * @param dto		ΏDTO
	 * @throws Exception 	Oꍇ
	 */
	private void setFields(MSyukkinboDto dto) throws Exception {
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		// ̐ݒ
		kintai().replaceCodeToName(dto);
		// VOɏZbg
		vo.setFields(dto);
		// [hݒ
		setApprovalStatus(dto);
		// e\ݒ
		setRequestInfo(dto);
		// Jgݒ
		setLaborAgreementInfo(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke()));
		// ԊOxΉ
		vo.setCaution(checkCautionOverTimeMonthly(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke())));
		// 60ԎԊOxΉ
		vo.setWarning(checkWarningOverTimeMonthly(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke())));
	}
	
	/**
	 * F󋵏̐ݒ
	 * @param dto			ΏDTO
	 * @throws Exception  	Oꍇ
	 */
	private void setApprovalStatus(MSyukkinboDto dto) throws Exception {
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		setLabelBasisInfo(part().human().getBasisInfo(dto.getKCode()));
		String statusCode = dto.getSnRiyuu();
		vo.setLblStatus(getApprovalName(statusCode));
		// [hݒ
		vo.setMode(DayApprovalCardVo.MODE_VIEW);
		// FҊmF
		if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), statusCode,
				DateUtil.convStringDateToDate(dto.getHizuke()))) {
			vo.setMode(DayApprovalCardVo.MODE_SELECT);
			if (KintaiApprovalPart.is1stApproved(statusCode)) {
				vo.setMode(DayApprovalCardVo.MODE_APPROVED);
			}
		}
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	/**
	 * e\ݒ
	 * @param dto		ΏDTO
	 * @throws Exception 	Oꍇ
	 */
	private void setRequestInfo(MSyukkinboDto dto) throws Exception {
		DayApprovalCardVo vo = (DayApprovalCardVo)getVo();
		String kCode = dto.getKCode();
		Date targetDate = DateUtil.convStringDateToDate(dto.getHizuke());
		// xɐ\
		vo.setAryLblHolidayRequest(getLabelHolidayRequestStatusArray(kCode, targetDate));
		// cƐ\
		CtOvertimeRequestDto overtimeDto = getOverTimeRequest(kCode, targetDate);
		if (VariousUtil.isNotNull(overtimeDto)) {
			StringBuffer sb = new StringBuffer();
			String statusCode = toKintaiApprovalStatus(overtimeDto.getWorkflow());
			// ȊO
			if (!KintaiApprovalPart.isDraft(statusCode)) {
				// \
				sb.append(TimeUtil.convIntegerTimeToJPHours(overtimeDto.getOverTime()));
				// F
				sb.append(StringUtil.surroundBracket(getApprovalName(statusCode)));
				vo.setLblOverTimeRequest(sb.toString());
			}
		}
	}
	
}
