/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.Date;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.LaborAgreementPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.workflow.dto.KtHolidayRequestDto;
import jp.mosp.workflow.vo.HolidayApprovalCardVo;

/**
 * @author yoshida
 *
 */
public class HolidayApprovalCardAction extends MosPWorkflowAction {
	
	// R}h
	/**
	 * 
	 */
	public static final String	CMD_CARD_SELECT		= "K2141";
	private static final String	CMD_CARD_APPROVED	= "K2142";
	private static final String	CMD_CARD_RETURNED	= "K2143";
	

	/**
	 * RXgN^
	 */
	public HolidayApprovalCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (CMD_CARD_SELECT.equals(cmd)) {
			// \(L[ŏ)
			select();
		} else if (CMD_CARD_APPROVED.equals(cmd)) {
			// F
			approved();
		} else if (CMD_CARD_RETURNED.equals(cmd)) {
			// 
			returned();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new HolidayApprovalCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// [U̎擾
		getInfo(user.getUserId());
	}
	
	@Override
	protected void select() throws Exception {
		// f[^̎擾
		KtHolidayRequestDto dto = holidayDao().findForKey(NumberUtil.getIntParam(key2));
		chkExist(dto);
		// VOɏZbg
		setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * F
	 * @throws Exception 	Oꍇ
	 */
	private void approved() throws Exception {
		// DTO̎擾
		KtHolidayRequestDto dto = (KtHolidayRequestDto)getSessionDto();
		// xɐ\F
		if (runHolidayRequestApproved(dto)) {
			// R~bg
			commit();
			// bZ[W̕\
			setMessage(getMessage(CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
		// VOɏZbg
		setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * ߏ
	 * @throws Exception 	Oꍇ
	 */
	private void returned() throws Exception {
		// DTO̎擾
		KtHolidayRequestDto dto = (KtHolidayRequestDto)getSessionDto();
		HolidayApprovalCardVo vo = (HolidayApprovalCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// ߏ
		if (runWorkflowReturnProcess(dto.getKCode(), dto.getHolidayDate(), dto.getWorkflow(),
				CommonConst.NAM_HOLIDAY_REQUEST, vo.getTxtComment())) {
			// R~bg
			commit();
			// bZ[W̕\
			setMessage(getMessage(CommonConst.MSG_CODE_WORKFLOW_UPDATE, ""));
		}
		// VOɏZbg
		setFields(dto);
		// F󋵂̐ݒ
		setApprovalStatus(dto);
	}
	
	/**
	 * F󋵏̐ݒ
	 * @param dto			ΏDTO
	 * @throws Exception  	Oꍇ
	 */
	private void setApprovalStatus(KtHolidayRequestDto dto) throws Exception {
		HolidayApprovalCardVo vo = (HolidayApprovalCardVo)getVo();
		setLabelBasisInfo(part().human().getBasisInfo(dto.getKCode()));
		String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
		vo.setLblApprovalStatus(getApprovalName(statusCode));
		// [hݒ
		vo.setMode(HolidayApprovalCardVo.MODE_VIEW);
		// FҊmF
		if (part().kintaiApproval().isApprover(dto.getKCode(), userBasis.getKCode(), statusCode, dto.getHolidayDate())) {
			vo.setMode(HolidayApprovalCardVo.MODE_SELECT);
			if (KintaiApprovalPart.is1stApproved(statusCode)) {
				vo.setMode(HolidayApprovalCardVo.MODE_APPROVED);
			}
		}
		// ߂Rgꗗ
		setReturnedComment(dto.getKCode(), dto.getWorkflow());
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 * @throws Exception   	Oꍇ
	 */
	public void setFields(KtHolidayRequestDto dto) throws Exception {
		HolidayApprovalCardVo vo = (HolidayApprovalCardVo)getVo();
		vo.setHidVoucher(String.valueOf(dto.getVoucher()));
		Date holidayDate = dto.getHolidayDate();
		vo.setLblHolidayDate(DateUtil.convDateToFormatDateJP(holidayDate));
		StringBuffer sb = new StringBuffer();
		if (dto.getEndTime() - dto.getStartTime() > 0) {
			sb.append(TimeUtil.convIntegerTimeToStringTime(dto.getStartTime()));
			sb.append(CommonConst.STR_TERM);
			sb.append(TimeUtil.convIntegerTimeToStringTime(dto.getEndTime()));
		}
		// xɗR̎擾
		vo.setLblHolidayTime(sb.toString());
		vo.setLblReason(part().holidayRequest().getReasonNameWithType(dto, false));
		vo.setLblReqestDate(DateUtil.convDateToFormatDateJP(dto.getInsertDate()));
		vo.setLblCauseComment(dto.getCauseComment());
		// LxΉ
		Map<String, Double> map = part().paidHoliday().getAvairablePaidHolidayMap(dto.getKCode(),
				MospUtility.getYear(holidayDate), MospUtility.getMonth(holidayDate));
		vo.setLblTotalRemainDays("");
		vo.setLblTotalRemainHour("");
		vo.setUseHourHoliday(part().mospcode().useHourPaidHolidayFunction());
		sb = new StringBuffer();
		sb.append(PaidHolidayPart.getMapLastRemainDays(map) + PaidHolidayPart.getMapRemainDays(map));
		if (vo.isUseHourHoliday()) {
			// Jg
			setLaborAgreementInfo(userBasis.getKCode(), holidayDate);
			int prescribedTime = LaborAgreementPart.getPrescribedTime(agreement);
			int prescribedHour = Double.valueOf(Math.ceil(TimeUtil.convMinutesToDoubleHour(prescribedTime))).intValue();
			sb.append(StringUtil.surroundRoundBracket(String.valueOf(PaidHolidayPart.getMapPossible(map)
					/ prescribedHour)));
			vo.setLblTotalRemainHour(String.valueOf(PaidHolidayPart.getMapPossible(map) % prescribedHour));
		}
		vo.setLblTotalRemainDays(sb.toString());
		// xΉ
		double subRemainDays = part().subHoliday().getRemainSubstituteHoliday(dto.getKCode(), holidayDate);
		vo.setLblSubstituteRemain("");
		vo.setLblSubstituteRemain(NumberUtil.getNumberString(subRemainDays, 3, 1));
		vo.setUseSubstitute(part().mospcode().useSubstituteHolidayFunction());
	}
	
}
