/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class CtOvertimeRequestDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3402105154211410548L;
	
	// tB[h
	private int					voucher				= 0;
	private long				workflow			= 0;
	private String				kcode				= "";
	private Date				requestdate			= null;
	private Date				workdate			= null;
	private int					overtime			= 0;
	private String				reason				= "";
	private int					deleteflag			= 0;
	

	/**
	 * RXgN^B
	 */
	public CtOvertimeRequestDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return voucher 	cƐ\`[ԍB
	 */
	public int getVoucher() {
		return voucher;
	}
	
	/**
	 * @return workflow 	[Nt[ԍB
	 */
	public long getWorkflow() {
		return workflow;
	}
	
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return requestdate 	\B
	 */
	public Date getRequestDate() {
		return (Date)requestdate.clone();
	}
	
	/**
	 * @return workdate 	ΖB
	 */
	public Date getWorkDate() {
		return (Date)workdate.clone();
	}
	
	/**
	 * @return overtime 	\ԁB
	 */
	public int getOverTime() {
		return overtime;
	}
	
	/**
	 * @return reason 	RB
	 */
	public String getReason() {
		return reason;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param voucher 	ZbgcƐ\`[ԍB
	 */
	public void setVoucher(int voucher) {
		this.voucher = voucher;
	}
	
	/**
	 * @param workflow 	Zbg郏[Nt[ԍB
	 */
	public void setWorkflow(long workflow) {
		this.workflow = workflow;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param requestdate 	Zbg\B
	 */
	public void setRequestDate(Date requestdate) {
		this.requestdate = (Date)requestdate.clone();
	}
	
	/**
	 * @param workdate 	ZbgΖB
	 */
	public void setWorkDate(Date workdate) {
		this.workdate = (Date)workdate.clone();
	}
	
	/**
	 * @param overtime 	Zbg\ԁB
	 */
	public void setOverTime(int overtime) {
		this.overtime = overtime;
	}
	
	/**
	 * @param reason 	Zbg鎖RB
	 */
	public void setReason(String reason) {
		this.reason = reason;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
