/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dto;

/**
 * @author yoshida
 *
 */
public class HolidayRequestDto extends KtHolidayRequestDto {
	
	private static final long	serialVersionUID	= -6608629387490561372L;
	
	// tB[h
	private String				approverName		= "";
	private String				approvalStatus		= "";
	

	/**
	 * RXgN^
	 * @param dto ΏDTO
	 */
	public HolidayRequestDto(KtHolidayRequestDto dto) {
		setVoucher(dto.getVoucher());
		setWorkflow(dto.getWorkflow());
		setKCode(dto.getKCode());
		setHolidayDate(dto.getHolidayDate());
		setStartTime(dto.getStartTime());
		setEndTime(dto.getEndTime());
		setReason(dto.getReason());
		setOccurDate1(dto.getOccurDate1());
		setUseTime1(dto.getUseTime1());
		setOccurDate2(dto.getOccurDate2());
		setUseTime2(dto.getUseTime2());
		setSubstituteDate(dto.getSubstituteDate());
		setCauseComment(dto.getCauseComment());
		setDeleteFlag(dto.getDeleteFlag());
	}
	
	// ANZT\bh
	/**
	 * @return approverName
	 */
	public String getApproverName() {
		return approverName;
	}
	
	/**
	 * @return approvalStatus
	 */
	public String getApprovalStatus() {
		return approvalStatus;
	}
	
	/**
	 * @param approverName Zbg鏳FҖ
	 */
	public void setApproverName(String approverName) {
		this.approverName = approverName;
	}
	
	/**
	 * @param approvalStatus Zbg鏳F
	 */
	public void setApprovalStatus(String approvalStatus) {
		this.approvalStatus = approvalStatus;
	}
	
}
