/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.workflow.dto.AmRouteDto;

/**
 * @author yoshida
 *
 */
public class ApprovalRouteCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= -8505387639842276947L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	/**
	 * 
	 */
	public static final int		MODE_IMPOSSIBLE		= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_ROUTE_CODE	= "txtRouteCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAYER1		= "pltLayer1";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAYER2		= "pltLayer2";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAYER3		= "pltLayer3";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAYER4		= "pltLayer4";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAYER5		= "pltLayer5";
	/**
	 * 
	 */
	public static final String	PRM_PLT_LAST_LAYER	= "pltLastLayer";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtRouteCode;
	private String				pltLayer1;
	private String				pltLayer2;
	private String				pltLayer3;
	private String				pltLayer4;
	private String				pltLayer5;
	private String				pltLastLayer;
	private String				pltDelete;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltUnit;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_ROUTE_CODE;
	/**
	 * 
	 */
	public String				NAM_CODE;
	/**
	 * 
	 */
	public String				NAM_LAYER1;
	/**
	 * 
	 */
	public String				NAM_LAYER2;
	/**
	 * 
	 */
	public String				NAM_LAYER3;
	/**
	 * 
	 */
	public String				NAM_LAYER4;
	/**
	 * 
	 */
	public String				NAM_LAYER5;
	/**
	 * 
	 */
	public String				NAM_LAST_LAYER;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_CODE;
	/**
	 * 
	 */
	public String				REG_DELETE;
	
	// [h
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public ApprovalRouteCardVo() {
		super();
		mode = MODE_INSERT;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_ROUTE;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_ROUTE_CODE = CommonConst.NAM_APPROVAL_ROUTE + CommonConst.NAM_COMMON_CODE;
		NAM_CODE = CommonConst.NAM_COMMON_CODE;
		NAM_LAYER1 = CommonConst.NAM_1ST_APPROVED;
		NAM_LAYER2 = CommonConst.NAM_2ND_APPROVED;
		NAM_LAYER3 = CommonConst.NAM_3RD_APPROVED;
		NAM_LAYER4 = CommonConst.NAM_4TH_APPROVED;
		NAM_LAYER5 = CommonConst.NAM_5TH_APPROVED;
		NAM_LAST_LAYER = CommonConst.NAM_LAST_APPROVED;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_CODE = 10;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtRouteCode("");
		setPltLayer1("");
		setPltLayer2("");
		setPltLayer3("");
		setPltLayer4("");
		setPltLayer5("");
		setPltLastLayer("");
		setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtRouteCode = request.getParameter(PRM_TXT_ROUTE_CODE);
		pltLayer1 = request.getParameter(PRM_PLT_LAYER1);
		pltLayer2 = request.getParameter(PRM_PLT_LAYER2);
		pltLayer3 = request.getParameter(PRM_PLT_LAYER3);
		pltLayer4 = request.getParameter(PRM_PLT_LAYER4);
		pltLayer5 = request.getParameter(PRM_PLT_LAYER5);
		pltLastLayer = request.getParameter(PRM_PLT_LAST_LAYER);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(AmRouteDto dto) {
		txtRouteCode = dto.getRtCode();
		pltLayer1 = dto.getLayer1();
		pltLayer2 = dto.getLayer2();
		pltLayer3 = dto.getLayer3();
		pltLayer4 = dto.getLayer4();
		pltLayer5 = dto.getLayer5();
		pltLastLayer = dto.getLastLayer();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(AmRouteDto dto) {
		dto.setRtCode(txtRouteCode);
		dto.setLayer1(pltLayer1);
		dto.setLayer2(pltLayer2);
		dto.setLayer3(pltLayer3);
		dto.setLayer4(pltLayer4);
		dto.setLayer5(pltLayer5);
		dto.setLastLayer(pltLastLayer);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtRouteCode, NAM_ROUTE_CODE, PRM_TXT_ROUTE_CODE);
		// 񒷊mF
		checkLength(txtRouteCode, LEN_CODE, NAM_ROUTE_CODE, PRM_TXT_ROUTE_CODE);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return txtRouteCode
	 */
	public String getEscTxtRouteCode() {
		return escapeHTML(txtRouteCode);
	}
	
	/**
	 * @return txtRouteCode
	 */
	public String getTxtRouteCode() {
		return txtRouteCode;
	}
	
	/**
	 * @return pltLayer1
	 */
	public String getPltLayer1() {
		return pltLayer1;
	}
	
	/**
	 * @return pltLayer2
	 */
	public String getPltLayer2() {
		return pltLayer2;
	}
	
	/**
	 * @return pltLayer3
	 */
	public String getPltLayer3() {
		return pltLayer3;
	}
	
	/**
	 * @return pltLayer4
	 */
	public String getPltLayer4() {
		return pltLayer4;
	}
	
	/**
	 * @return pltLayer5
	 */
	public String getPltLayer5() {
		return pltLayer5;
	}
	
	/**
	 * @return pltLastLayer
	 */
	public String getPltLastLayer() {
		return pltLastLayer;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param txtRouteCode Zbg txtRouteCode
	 */
	public void setTxtRouteCode(String txtRouteCode) {
		this.txtRouteCode = txtRouteCode;
	}
	
	/**
	 * @param pltLayer1 Zbg pltLayer1
	 */
	public void setPltLayer1(String pltLayer1) {
		this.pltLayer1 = pltLayer1;
	}
	
	/**
	 * @param pltLayer2 Zbg pltLayer2
	 */
	public void setPltLayer2(String pltLayer2) {
		this.pltLayer2 = pltLayer2;
	}
	
	/**
	 * @param pltLayer3 Zbg pltLayer3
	 */
	public void setPltLayer3(String pltLayer3) {
		this.pltLayer3 = pltLayer3;
	}
	
	/**
	 * @param pltLayer4 Zbg pltLayer4
	 */
	public void setPltLayer4(String pltLayer4) {
		this.pltLayer4 = pltLayer4;
	}
	
	/**
	 * @param pltLayer5 Zbg pltLayer5
	 */
	public void setPltLayer5(String pltLayer5) {
		this.pltLayer5 = pltLayer5;
	}
	
	/**
	 * @param pltLastLayer Zbg pltLastLayer
	 */
	public void setPltLastLayer(String pltLastLayer) {
		this.pltLastLayer = pltLastLayer;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
