/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.workflow.dto.OverTimeRequestDto;

/**
 * @author yoshida
 *
 */
public class OverTimeRequestListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -1598511432661195806L;
	
	// p[^
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	// tB[h	
	private String[][]			aryOverTime;
	private String				pltYear;
	private String				pltMonth;
	
	private String				lblOverTime;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_WORK_MONTH;
	/**
	 * 
	 */
	public String				NAM_WORK_DATE;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_REQUEST_TIME;
	/**
	 * 
	 */
	public String				NAM_REQUEST_DATE;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_APPROVER;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_WORK_DATE		= "keyWorkDate";
	/**
	 * 
	 */
	public final String			KEY_REQUEST_DATE	= "keyRequestDate";
	/**
	 * 
	 */
	public final String			KEY_STATUS			= "keyStatus";
	/**
	 * 
	 */
	public final String			KEY_APPROVER		= "keyApprover";
	

	/**
	 * RXgN^
	 */
	public OverTimeRequestListVo() {
		super();
		setViewPath(getClassName());
		aryOverTime = new String[0][0];
		pltYear = "";
		pltMonth = "";
		lblOverTime = "";
		setFormerKey(KEY_WORK_DATE);
	}
	
	@Override
	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuApplication(), };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_WORK_MONTH = CommonConst.NAM_WORKING + CommonConst.NAM_MONTH;
		NAM_WORK_DATE = CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
		NAM_REASON = CommonConst.NAM_REASON;
		NAM_REQUEST_TIME = CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
		NAM_REQUEST_DATE = CommonConst.NAM_APPLICATION + CommonConst.NAM_DAY;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_APPROVER = CommonConst.NAM_APPROVER;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	@Override
	public void setFields(List<?> listRequest) {
		// Xg̐ݒ
		list = listRequest;
		// f[^̎擾
		count = listRequest.size();
		// z̏
		aryOverTime = new String[count][7];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listRequest.iterator();
		while (it.hasNext()) {
			OverTimeRequestDto dto = (OverTimeRequestDto)it.next();
			// `[ԍ
			aryOverTime[i][0] = escapeHTML(String.valueOf(dto.getVoucher()));
			// Ζ
			aryOverTime[i][1] = escapeHTML(DateUtil.convDateToFormatDateJP(dto.getWorkDate()));
			// R
			aryOverTime[i][2] = escapeHTML(dto.getReason());
			// \
			aryOverTime[i][3] = escapeHTML(TimeUtil.convIntegerTimeToJPHours(dto.getOverTime()));
			// \
			aryOverTime[i][4] = escapeHTML(DateUtil.convDateToFormatDateJP(dto.getRequestDate()));
			// F
			aryOverTime[i][5] = escapeHTML(dto.getApprovalStatus());
			// F
			aryOverTime[i][6] = escapeHTML(dto.getApproverName());
			i++;
		}
	}
	
	// ANZT\bh	
	/**
	 * @return aryOverTime
	 */
	public String[][] getEscAryOverTime() {
		return aryOverTime.clone();
	}
	
	/**
	 * @return pltYear
	 */
	public String getEscPltYear() {
		return escapeHTML(pltYear);
	}
	
	/**
	 * @return pltMonth
	 */
	public String getEscPltMonth() {
		return escapeHTML(pltMonth);
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @return lblOverTime
	 */
	public String getLblOverTime() {
		return lblOverTime;
	}
	
	/**
	 * @param lblOverTime Zbg lblOverTime
	 */
	public void setLblOverTime(String lblOverTime) {
		this.lblOverTime = lblOverTime;
	}
	
}
